/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.exchange.lcmacro.AccessoryOkayPoint;
import org.bidib.jbidibc.exchange.lcmacro.AnalogPortPoint;
import org.bidib.jbidibc.exchange.lcmacro.BacklightPortPoint;
import org.bidib.jbidibc.exchange.lcmacro.CriticalSectionPoint;
import org.bidib.jbidibc.exchange.lcmacro.DelayPoint;
import org.bidib.jbidibc.exchange.lcmacro.FlagPoint;
import org.bidib.jbidibc.exchange.lcmacro.InputPortPoint;
import org.bidib.jbidibc.exchange.lcmacro.LcMacroExporter;
import org.bidib.jbidibc.exchange.lcmacro.LcMacroPointType;
import org.bidib.jbidibc.exchange.lcmacro.LcMacroType;
import org.bidib.jbidibc.exchange.lcmacro.LightPortPoint;
import org.bidib.jbidibc.exchange.lcmacro.MacroActionPoint;
import org.bidib.jbidibc.exchange.lcmacro.MotorPortPoint;
import org.bidib.jbidibc.exchange.lcmacro.PortModelType;
import org.bidib.jbidibc.exchange.lcmacro.RandomDelayPoint;
import org.bidib.jbidibc.exchange.lcmacro.RepeatPeriodType;
import org.bidib.jbidibc.exchange.lcmacro.RepeatWeekdayType;
import org.bidib.jbidibc.exchange.lcmacro.ServoMoveQueryPoint;
import org.bidib.jbidibc.exchange.lcmacro.ServoPortPoint;
import org.bidib.jbidibc.exchange.lcmacro.SoundPortPoint;
import org.bidib.jbidibc.exchange.lcmacro.StartClkType;
import org.bidib.jbidibc.exchange.lcmacro.SwitchPairPortPoint;
import org.bidib.jbidibc.exchange.lcmacro.SwitchPortPoint;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRepeatDay;
import org.bidib.wizard.api.model.MacroRepeatTime;
import org.bidib.wizard.api.model.PortsProvider;
import org.bidib.wizard.api.model.StartCondition;
import org.bidib.wizard.api.model.TimeStartCondition;
import org.bidib.wizard.api.model.function.AccessoryOkayFunction;
import org.bidib.wizard.api.model.function.AnalogPortAction;
import org.bidib.wizard.api.model.function.BacklightPortAction;
import org.bidib.wizard.api.model.function.CriticalFunction;
import org.bidib.wizard.api.model.function.DelayFunction;
import org.bidib.wizard.api.model.function.EmptyFunction;
import org.bidib.wizard.api.model.function.FlagFunction;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.InputFunction;
import org.bidib.wizard.api.model.function.LightPortAction;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.api.model.function.MotorPortAction;
import org.bidib.wizard.api.model.function.RandomDelayFunction;
import org.bidib.wizard.api.model.function.ServoMoveQueryFunction;
import org.bidib.wizard.api.model.function.ServoPortAction;
import org.bidib.wizard.api.model.function.SoundPortAction;
import org.bidib.wizard.api.model.function.SwitchPairPortAction;
import org.bidib.wizard.api.model.function.SwitchPortAction;
import org.bidib.wizard.model.ports.AnalogPort;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.AccessoryOkayStatus;
import org.bidib.wizard.model.status.AnalogPortStatus;
import org.bidib.wizard.model.status.BacklightPortStatus;
import org.bidib.wizard.model.status.CriticalFunctionStatus;
import org.bidib.wizard.model.status.FlagStatus;
import org.bidib.wizard.model.status.InputStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.model.status.ServoPortStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.model.MacroFactory;
import org.bidib.wizard.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MacroFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroFactory.class);

    private MacroFactory() {
    }

    public static void saveMacro(String fileName, Macro macro, ExportFormat exportFormat) throws FileNotFoundException, IOException {
        MacroFactory.saveMacro((String)fileName, (Macro)macro, (ExportFormat)exportFormat, (boolean)true);
    }

    public static void saveMacro(String fileName, Macro macro, ExportFormat exportFormat, boolean gzip) throws FileNotFoundException, IOException {
        switch (exportFormat.ordinal()) {
            case 0: {
                new MacroFactory().saveMacroWithJaxb(fileName, macro, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported exportFormat!");
            }
        }
    }

    public static Macro loadMacro(String fileName, ExportFormat exportFormat, PortsProvider portsProvider) {
        Macro macro = null;
        switch (exportFormat.ordinal()) {
            case 0: {
                macro = new MacroFactory().loadMacroWithJaxb(fileName, portsProvider);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported exportFormat!");
            }
        }
        return macro;
    }

    protected void saveMacroWithJaxb(String fileName, Macro macro, boolean gzip) {
        LOGGER.debug("Save the macro to file: {}", (Object)fileName);
        LcMacroType lcMacro = new LcMacroType();
        lcMacro.setRepeat(macro.getCycles());
        lcMacro.setMacroId(macro.getId());
        lcMacro.setMacroName((String)(StringUtils.isNotBlank((CharSequence)macro.toString()) ? macro.toString() : "M_" + macro.getId()));
        lcMacro.setSlowdown(macro.getSpeed());
        lcMacro.setMaxMacroPoints(Integer.valueOf(macro.getFunctionSize()));
        lcMacro.setPortModel(macro.isFlatPortModel() ? PortModelType.FLAT : PortModelType.TYPE);
        if (macro.getStartConditions() != null) {
            Collection startConditions = macro.getStartConditions();
            for (StartCondition startCondition : startConditions) {
                if (!(startCondition instanceof TimeStartCondition)) continue;
                TimeStartCondition timeStartCondition = (TimeStartCondition)startCondition;
                MacroRepeatDay repeatDay = timeStartCondition.getRepeatDay();
                StartClkType startClk = new StartClkType();
                startClk.setWeekday(RepeatWeekdayType.fromValue((String)repeatDay.name()));
                MacroRepeatTime repeatTime = timeStartCondition.getRepeatTime();
                switch (1.$SwitchMap$org$bidib$wizard$api$model$MacroRepeatTime[repeatTime.ordinal()]) {
                    case 1: {
                        startClk.setRepeatPeriod(RepeatPeriodType.EVERY_MINUTE);
                        break;
                    }
                    case 2: {
                        startClk.setRepeatPeriod(RepeatPeriodType.EVERY_QUARTER_HOUR);
                        break;
                    }
                    case 3: {
                        startClk.setRepeatPeriod(RepeatPeriodType.EVERY_HALF_HOUR);
                        break;
                    }
                    case 4: {
                        startClk.setRepeatPeriod(RepeatPeriodType.EVERY_HOUR);
                        break;
                    }
                }
                Calendar cal = timeStartCondition.getTime();
                startClk.setHour((byte)cal.get(11));
                startClk.setMinute((byte)cal.get(12));
                lcMacro.setStartClk(startClk);
            }
        }
        for (Function function : macro.getFunctions()) {
            LOGGER.debug("Process current function: {}", (Object)function);
            lcMacro.getLcMacroPoint().add(function.toLcMacroPoint());
        }
        new LcMacroExporter().saveMacro(lcMacro, fileName, gzip);
    }

    private void addEmptyFunction(List<Function<?>> functions) {
        EmptyFunction function = new EmptyFunction();
        functions.add((Function<?>)function);
    }

    protected Macro loadMacroWithJaxb(String fileName, PortsProvider portsProvider) {
        LOGGER.debug("Load macro from file: {}", (Object)fileName);
        LcMacroType lcMacro = new LcMacroExporter().loadMacro(fileName);
        Macro macro = null;
        if (lcMacro != null) {
            macro = new Macro(lcMacro.getMaxMacroPoints());
            macro.setId(lcMacro.getMacroId());
            macro.setLabel(lcMacro.getMacroName());
            macro.setCycles(lcMacro.getRepeat());
            macro.setSpeed(lcMacro.getSlowdown());
            macro.setFlatPortModel(lcMacro.getPortModel() == PortModelType.FLAT);
            boolean nodeIsFlatPortModel = portsProvider.isFlatPortModel();
            LinkedList<Object> functions = new LinkedList<Object>();
            for (LcMacroPointType lcMacroPoint : lcMacro.getLcMacroPoint()) {
                DelayFunction function;
                LightPortAction action;
                AccessoryOkayFunction function2;
                ServoPort port;
                if (lcMacroPoint instanceof ServoMoveQueryPoint) {
                    ServoMoveQueryPoint servoMoveQueryPoint = (ServoMoveQueryPoint)lcMacroPoint;
                    port = (ServoPort)NodeUtils.getPort((List)portsProvider.getServoPorts(), (int)servoMoveQueryPoint.getOutputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                    if (port == null) {
                        LOGGER.warn("No ServoPort available with output number: {}", (Object)servoMoveQueryPoint.getOutputNumber());
                        this.addEmptyFunction(functions);
                        continue;
                    }
                    ServoMoveQueryFunction function3 = new ServoMoveQueryFunction(port);
                    functions.add(function3);
                    continue;
                }
                if (lcMacroPoint instanceof AccessoryOkayPoint) {
                    AccessoryOkayPoint accessoryOkayPoint = (AccessoryOkayPoint)lcMacroPoint;
                    AccessoryOkayStatus inputStatus = null;
                    InputPort port2 = null;
                    switch (1.$SwitchMap$org$bidib$jbidibc$exchange$lcmacro$AccessoryOkayActionType[accessoryOkayPoint.getAccessoryOkayActionType().ordinal()]) {
                        case 1: {
                            inputStatus = AccessoryOkayStatus.NO_FEEDBACK;
                            break;
                        }
                        case 2: {
                            port2 = (InputPort)NodeUtils.getPort((List)portsProvider.getEnabledInputPorts(), (int)accessoryOkayPoint.getInputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                            if (port2 == null) {
                                LOGGER.warn("No InputPort available with port number: {}", (Object)accessoryOkayPoint.getInputNumber());
                                port2 = InputPort.NONE;
                            }
                            inputStatus = AccessoryOkayStatus.QUERY1;
                            break;
                        }
                        default: {
                            port2 = (InputPort)NodeUtils.getPort((List)portsProvider.getEnabledInputPorts(), (int)accessoryOkayPoint.getInputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                            if (port2 == null) {
                                LOGGER.warn("No InputPort available with port number: {}", (Object)accessoryOkayPoint.getInputNumber());
                                port2 = InputPort.NONE;
                            }
                            inputStatus = AccessoryOkayStatus.QUERY0;
                        }
                    }
                    function2 = new AccessoryOkayFunction(inputStatus, port2);
                    functions.add(function2);
                    continue;
                }
                if (lcMacroPoint instanceof BacklightPortPoint) {
                    BacklightPortPoint backlightPortPoint = (BacklightPortPoint)lcMacroPoint;
                    port = (BacklightPort)NodeUtils.getPort((List)portsProvider.getBacklightPorts(), (int)backlightPortPoint.getOutputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                    if (port == null) {
                        LOGGER.warn("No BacklightPort available with output number: {}", (Object)backlightPortPoint.getOutputNumber());
                        this.addEmptyFunction(functions);
                        continue;
                    }
                    action = new BacklightPortAction(BacklightPortStatus.valueOf((String)backlightPortPoint.getBacklightPortActionType().getAction().name()), (BacklightPort)port, backlightPortPoint.getDelay().intValue(), backlightPortPoint.getBacklightPortActionType().getBrightness());
                    functions.add(action);
                    continue;
                }
                if (lcMacroPoint instanceof LightPortPoint) {
                    LightPortPoint lightPortPoint = (LightPortPoint)lcMacroPoint;
                    port = (LightPort)NodeUtils.getPort((List)portsProvider.getLightPorts(), (int)lightPortPoint.getOutputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                    if (port == null) {
                        LOGGER.warn("No LightPort available with output number: {}", (Object)lightPortPoint.getOutputNumber());
                        this.addEmptyFunction(functions);
                        continue;
                    }
                    action = new LightPortAction(LightPortStatus.valueOf((String)lightPortPoint.getLightPortActionType().name()), (LightPort)port, lightPortPoint.getDelay().intValue());
                    functions.add(action);
                    continue;
                }
                if (lcMacroPoint instanceof ServoPortPoint) {
                    ServoPortPoint servoPortPoint = (ServoPortPoint)lcMacroPoint;
                    port = (ServoPort)NodeUtils.getPort((List)portsProvider.getServoPorts(), (int)servoPortPoint.getOutputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                    if (port == null) {
                        LOGGER.warn("No ServoPort available with output number: {}", (Object)servoPortPoint.getOutputNumber());
                        this.addEmptyFunction(functions);
                        continue;
                    }
                    action = new ServoPortAction(ServoPortStatus.valueOf((String)servoPortPoint.getServoPortActionType().getAction().name()), port, servoPortPoint.getDelay().intValue(), servoPortPoint.getServoPortActionType().getDestination());
                    functions.add(action);
                    continue;
                }
                if (lcMacroPoint instanceof AnalogPortPoint) {
                    AnalogPortPoint analogPortPoint = (AnalogPortPoint)lcMacroPoint;
                    port = (AnalogPort)NodeUtils.getPort((List)portsProvider.getAnalogPorts(), (int)analogPortPoint.getOutputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                    if (port == null) {
                        LOGGER.warn("No AnalogPort available with output number: {}", (Object)analogPortPoint.getOutputNumber());
                        this.addEmptyFunction(functions);
                        continue;
                    }
                    action = new AnalogPortAction(AnalogPortStatus.valueOf((String)analogPortPoint.getAnalogPortActionType().getAction().name()), (AnalogPort)port, analogPortPoint.getDelay().intValue(), analogPortPoint.getAnalogPortActionType().getValue());
                    functions.add(action);
                    continue;
                }
                if (lcMacroPoint instanceof SwitchPortPoint) {
                    SwitchPortPoint switchPortPoint = (SwitchPortPoint)lcMacroPoint;
                    port = (SwitchPort)NodeUtils.getPort((List)portsProvider.getEnabledSwitchPorts(), (int)switchPortPoint.getOutputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                    if (port == null) {
                        LOGGER.warn("No SwitchPort available with output number: {}", (Object)switchPortPoint.getOutputNumber());
                        port = SwitchPort.NONE;
                    }
                    action = new SwitchPortAction(SwitchPortStatus.valueOf((String)switchPortPoint.getSwitchPortActionType().name()), (SwitchPort)port, switchPortPoint.getDelay().intValue());
                    functions.add(action);
                    continue;
                }
                if (lcMacroPoint instanceof SwitchPairPortPoint) {
                    SwitchPairPortPoint switchPairPortPoint = (SwitchPairPortPoint)lcMacroPoint;
                    port = (SwitchPairPort)NodeUtils.getPort((List)portsProvider.getEnabledSwitchPairPorts(), (int)switchPairPortPoint.getOutputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                    if (port == null) {
                        LOGGER.warn("No SwitchPairPort available with output number: {}", (Object)switchPairPortPoint.getOutputNumber());
                        port = SwitchPairPort.NONE;
                    }
                    action = new SwitchPairPortAction(SwitchPortStatus.valueOf((String)switchPairPortPoint.getSwitchPortActionType().name()), (SwitchPairPort)port, switchPairPortPoint.getDelay().intValue());
                    functions.add(action);
                    continue;
                }
                if (lcMacroPoint instanceof SoundPortPoint) {
                    SoundPortPoint soundPortPoint = (SoundPortPoint)lcMacroPoint;
                    port = (SoundPort)NodeUtils.getPort((List)portsProvider.getSoundPorts(), (int)soundPortPoint.getOutputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                    if (port == null) {
                        LOGGER.warn("No SwitchPort available with output number: {}", (Object)soundPortPoint.getOutputNumber());
                        this.addEmptyFunction(functions);
                        continue;
                    }
                    action = new SoundPortAction(SoundPortStatus.valueOf((String)soundPortPoint.getSoundPortActionType().getAction().name()), (SoundPort)port, soundPortPoint.getDelay().intValue(), soundPortPoint.getSoundPortActionType().getValue());
                    functions.add(action);
                    continue;
                }
                if (lcMacroPoint instanceof MotorPortPoint) {
                    MotorPortPoint motorPortPoint = (MotorPortPoint)lcMacroPoint;
                    port = (MotorPort)NodeUtils.getPort((List)portsProvider.getMotorPorts(), (int)motorPortPoint.getOutputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                    if (port == null) {
                        LOGGER.warn("No MotorPort available with output number: {}", (Object)motorPortPoint.getOutputNumber());
                        this.addEmptyFunction(functions);
                        continue;
                    }
                    action = new MotorPortAction(MotorPortStatus.valueOf((String)motorPortPoint.getMotorPortActionType().getAction().name()), (MotorPort)port, motorPortPoint.getDelay().intValue(), motorPortPoint.getMotorPortActionType().getValue());
                    functions.add(action);
                    continue;
                }
                if (lcMacroPoint instanceof DelayPoint) {
                    DelayPoint delayPoint = (DelayPoint)lcMacroPoint;
                    function = new DelayFunction();
                    function.setDelay(delayPoint.getDelayActionType());
                    functions.add(function);
                    continue;
                }
                if (lcMacroPoint instanceof RandomDelayPoint) {
                    RandomDelayPoint randomDelayPoint = (RandomDelayPoint)lcMacroPoint;
                    function = new RandomDelayFunction();
                    function.setMaximumValue(randomDelayPoint.getRandomDelayActionType());
                    functions.add(function);
                    continue;
                }
                if (lcMacroPoint instanceof CriticalSectionPoint) {
                    CriticalSectionPoint criticalSectionPoint = (CriticalSectionPoint)lcMacroPoint;
                    function = new CriticalFunction(CriticalFunctionStatus.valueOf((String)criticalSectionPoint.getCriticalSectionActionType().name()));
                    functions.add(function);
                    continue;
                }
                if (lcMacroPoint instanceof MacroActionPoint) {
                    MacroActionPoint macroActionPoint = (MacroActionPoint)lcMacroPoint;
                    function = new MacroFunction(MacroStatus.valueOf((String)macroActionPoint.getMacroActionType().getOperation().name()), macroActionPoint.getMacroActionType().getMacroNumber());
                    functions.add(function);
                    continue;
                }
                if (lcMacroPoint instanceof FlagPoint) {
                    FlagPoint flagPoint = (FlagPoint)lcMacroPoint;
                    function = new FlagFunction(FlagStatus.valueOf((String)flagPoint.getFlagActionType().getOperation().name()), new Flag(flagPoint.getFlagActionType().getFlagNumber()));
                    functions.add(function);
                    continue;
                }
                if (!(lcMacroPoint instanceof InputPortPoint)) continue;
                InputPortPoint inputPortPoint = (InputPortPoint)lcMacroPoint;
                port = (InputPort)NodeUtils.getPort((List)portsProvider.getEnabledInputPorts(), (int)inputPortPoint.getInputNumber(), (boolean)macro.isFlatPortModel(), (boolean)nodeIsFlatPortModel);
                if (port == null) {
                    LOGGER.warn("No InputPort available with port number: {}", (Object)inputPortPoint.getInputNumber());
                    port = InputPort.NONE;
                }
                InputStatus inputStatus = null;
                switch (1.$SwitchMap$org$bidib$jbidibc$exchange$lcmacro$InputPortActionType[inputPortPoint.getInputPortActionType().ordinal()]) {
                    case 1: {
                        inputStatus = InputStatus.QUERY1;
                        break;
                    }
                    default: {
                        inputStatus = InputStatus.QUERY0;
                    }
                }
                function2 = new InputFunction(inputStatus, (InputPort)port);
                functions.add(function2);
            }
            macro.setFunctions(functions);
            TimeStartCondition timeStartCondition = new TimeStartCondition();
            StartClkType startClk = lcMacro.getStartClk();
            if (startClk != null) {
                LOGGER.info("Apply start condition: {}", (Object)startClk);
                if (startClk.getRepeatPeriod() != null) {
                    switch (1.$SwitchMap$org$bidib$jbidibc$exchange$lcmacro$RepeatPeriodType[startClk.getRepeatPeriod().ordinal()]) {
                        case 1: {
                            timeStartCondition.setRepeatTime(MacroRepeatTime.MINUTELY);
                            timeStartCondition.setMinutely(true);
                            break;
                        }
                        case 2: {
                            timeStartCondition.setRepeatTime(MacroRepeatTime.QUARTER_HOURLY);
                            break;
                        }
                        case 3: {
                            timeStartCondition.setRepeatTime(MacroRepeatTime.HALF_HOURLY);
                            break;
                        }
                        case 4: {
                            timeStartCondition.setRepeatTime(MacroRepeatTime.HOURLY);
                            timeStartCondition.setHourly(true);
                            break;
                        }
                        default: {
                            LOGGER.warn("Unsupported repeat period: {}", (Object)startClk.getRepeatPeriod());
                        }
                    }
                }
                if (startClk.getWeekday() != null) {
                    timeStartCondition.setRepeatDay(MacroRepeatDay.valueOf((String)startClk.getWeekday().name()));
                }
                Calendar cal = GregorianCalendar.getInstance();
                cal.set(11, startClk.getHour());
                cal.set(12, startClk.getMinute());
                timeStartCondition.setTime(cal);
                LinkedList<TimeStartCondition> startConditions = new LinkedList<TimeStartCondition>();
                startConditions.add(timeStartCondition);
                macro.setStartConditions(startConditions);
            } else {
                LOGGER.info("No start condition available.");
            }
        }
        return macro;
    }

    @Deprecated
    public static void replacePortReferences(Macro macro, PortsProvider portsProvider, Map<String, Object> params) {
        new MacroFactory().replaceReferences(macro, portsProvider, params);
    }

    private void replaceReferences(Macro macro, PortsProvider portsProvider, Map<String, Object> params) {
        LOGGER.debug("Replace references in macro: {}", (Object)macro);
        if (macro != null) {
            List macroFunctions = macro.getFunctions();
            boolean nodeIsFlatPortModel = portsProvider.isFlatPortModel();
            boolean macroIsFlatPortModel = macro.isFlatPortModel();
            LOGGER.info("replaceReferences, nodeIsFlatPortModel: {}, macroIsFlatPortModel: {}", (Object)nodeIsFlatPortModel, (Object)macroIsFlatPortModel);
            if (macroFunctions != null) {
                ArrayList<Function> newMacroFunctions = new ArrayList<Function>();
                for (Function function : macroFunctions) {
                    SwitchPort port;
                    int id;
                    LOGGER.info("Process current macro step: {}", (Object)function);
                    if (function instanceof AnalogPortAction) {
                        AnalogPort port2 = (AnalogPort)((AnalogPortAction)function).getPort();
                        if (port2 != null) {
                            id = port2.getId();
                            port2 = (AnalogPort)NodeUtils.getPort((List)portsProvider.getAnalogPorts(), (int)port2.getId(), (boolean)macroIsFlatPortModel, (boolean)nodeIsFlatPortModel);
                            if (port2 != null) {
                                ((AnalogPortAction)function).setPort((Port)port2);
                            } else {
                                LOGGER.warn("No analogport found with id: {}", (Object)id);
                                this.addImportError(params, "No analogport found with port number: " + id);
                                function = new EmptyFunction();
                            }
                        }
                    } else if (function instanceof BacklightPortAction) {
                        BacklightPort port3 = (BacklightPort)((BacklightPortAction)function).getPort();
                        if (port3 != null) {
                            id = port3.getId();
                            port3 = (BacklightPort)NodeUtils.getPort((List)portsProvider.getBacklightPorts(), (int)port3.getId(), (boolean)macroIsFlatPortModel, (boolean)nodeIsFlatPortModel);
                            if (port3 != null) {
                                ((BacklightPortAction)function).setPort((Port)port3);
                            } else {
                                LOGGER.warn("No backlight port found with id: {}", (Object)id);
                                this.addImportError(params, "No backlightport found with port number: " + id);
                                function = new EmptyFunction();
                            }
                        }
                    } else if (function instanceof FlagFunction) {
                        Flag flag = ((FlagFunction)function).getFlag();
                        if (flag != null) {
                            id = flag.getId();
                            List flags = portsProvider.getFlags();
                            if (id == -1) {
                                id = 0;
                            }
                            if (id >= 0 && id < flags.size()) {
                                ((FlagFunction)function).setFlag((Flag)flags.get(id));
                            }
                        }
                    } else if (function instanceof AccessoryOkayFunction) {
                        InputPort port4 = ((AccessoryOkayFunction)function).getInput();
                        if (port4 != null) {
                            id = port4.getId();
                            port4 = (InputPort)NodeUtils.getPort((List)portsProvider.getInputPorts(), (int)id, (boolean)macroIsFlatPortModel, (boolean)nodeIsFlatPortModel);
                            if (port4 != null) {
                                ((AccessoryOkayFunction)function).setInput(port4);
                            } else {
                                LOGGER.warn("No inputport found with id: {}", (Object)id);
                                this.addImportError(params, "No inputport found with port number: " + id);
                                ((AccessoryOkayFunction)function).setInput(InputPort.NONE);
                            }
                        }
                    } else if (function instanceof InputFunction) {
                        InputPort port5 = ((InputFunction)function).getInput();
                        if (port5 != null) {
                            id = port5.getId();
                            port5 = (InputPort)NodeUtils.getPort((List)portsProvider.getInputPorts(), (int)port5.getId(), (boolean)macroIsFlatPortModel, (boolean)nodeIsFlatPortModel);
                            if (port5 != null) {
                                ((InputFunction)function).setInput(port5);
                            } else {
                                LOGGER.warn("No inputport found with id: {}", (Object)id);
                                this.addImportError(params, "No inputport found with port number: " + id);
                                ((InputFunction)function).setInput(InputPort.NONE);
                            }
                        }
                    } else if (function instanceof LightPortAction) {
                        LightPort port6 = (LightPort)((LightPortAction)function).getPort();
                        if (port6 != null) {
                            id = port6.getId();
                            port6 = (LightPort)NodeUtils.getPort((List)portsProvider.getLightPorts(), (int)port6.getId(), (boolean)macroIsFlatPortModel, (boolean)nodeIsFlatPortModel);
                            if (port6 != null) {
                                ((LightPortAction)function).setPort((Port)port6);
                            } else {
                                LOGGER.warn("No lightport found with id: {}", (Object)id);
                                this.addImportError(params, "No lightport found with port number: " + id);
                                function = new EmptyFunction();
                            }
                        }
                    } else if (function instanceof MacroFunction) {
                        int macroId = ((MacroFunction)function).getMacroId();
                        LOGGER.info("Set the macro id: {}", (Object)macroId);
                        ((MacroFunction)function).setMacroId(macroId);
                    } else if (function instanceof MotorPortAction) {
                        MotorPort port7 = (MotorPort)((MotorPortAction)function).getPort();
                        if (port7 != null) {
                            id = port7.getId();
                            port7 = (MotorPort)NodeUtils.getPort((List)portsProvider.getMotorPorts(), (int)port7.getId(), (boolean)macroIsFlatPortModel, (boolean)nodeIsFlatPortModel);
                            if (port7 != null) {
                                ((MotorPortAction)function).setPort((Port)port7);
                            } else {
                                LOGGER.warn("No motorport found with id: {}", (Object)id);
                                this.addImportError(params, "No motorport found with port number: " + id);
                                function = new EmptyFunction();
                            }
                        }
                    } else if (function instanceof ServoPortAction) {
                        ServoPort port8 = (ServoPort)((ServoPortAction)function).getPort();
                        if (port8 != null) {
                            id = port8.getId();
                            LOGGER.info("Found servo port to replace: {}", (Object)port8);
                            port8 = (ServoPort)NodeUtils.getPort((List)portsProvider.getServoPorts(), (int)port8.getId(), (boolean)macroIsFlatPortModel, (boolean)nodeIsFlatPortModel);
                            LOGGER.info("Replaced port: {}", (Object)port8);
                            if (port8 != null) {
                                ((ServoPortAction)function).setPort((Port)port8);
                            } else {
                                LOGGER.warn("No servoport found with id: {}", (Object)id);
                                this.addImportError(params, "No servoport found with port number: " + id);
                                function = new EmptyFunction();
                            }
                        }
                    } else if (function instanceof SoundPortAction) {
                        SoundPort port9 = (SoundPort)((SoundPortAction)function).getPort();
                        if (port9 != null) {
                            id = port9.getId();
                            port9 = (SoundPort)NodeUtils.getPort((List)portsProvider.getSoundPorts(), (int)port9.getId(), (boolean)macroIsFlatPortModel, (boolean)nodeIsFlatPortModel);
                            if (port9 != null) {
                                ((SoundPortAction)function).setPort((Port)port9);
                            } else {
                                LOGGER.warn("No soundport found with id: {}", (Object)id);
                                this.addImportError(params, "No soundport found with port number: " + id);
                                function = new EmptyFunction();
                            }
                        }
                    } else if (function instanceof SwitchPortAction && (port = (SwitchPort)((SwitchPortAction)function).getPort()) != null) {
                        id = port.getId();
                        LOGGER.info(" Found switch port to replace: {}", (Object)port);
                        port = (SwitchPort)NodeUtils.getPort((List)portsProvider.getSwitchPorts(), (int)port.getId(), (boolean)macroIsFlatPortModel, (boolean)nodeIsFlatPortModel);
                        LOGGER.info("Replaced port: {}", (Object)port);
                        if (port != null) {
                            ((SwitchPortAction)function).setPort((Port)port);
                        } else {
                            LOGGER.warn("No switchport found with id: {}", (Object)id);
                            this.addImportError(params, "No switchport found with port number: " + id);
                            ((SwitchPortAction)function).setPort((Port)SwitchPort.NONE);
                        }
                    }
                    newMacroFunctions.add(function);
                }
                macro.setFunctions(newMacroFunctions);
            }
        }
    }

    private void addImportError(Map<String, Object> params, String message) {
        LinkedList<String> saveErrors = (LinkedList<String>)params.get("importErrors");
        if (saveErrors == null) {
            saveErrors = new LinkedList<String>();
            params.put("importErrors", saveErrors);
        }
        saveErrors.add(message);
    }
}

