/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.position.view;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.PositionFeedbackPort;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.client.common.table.PortTable;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.mvc.main.view.panel.SimplePortListPanel;
import org.bidib.wizard.mvc.position.controller.FeedbackPositionController;
import org.bidib.wizard.mvc.position.model.FeedbackPositionModel;
import org.bidib.wizard.mvc.position.model.FeedbackPositionTableModel;
import org.bidib.wizard.mvc.position.view.FeedbackPositionTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPositionListPanel
extends SimplePortListPanel<FeedbackPortStatus, PositionFeedbackPort, PortListener<PositionFeedbackPort>, PortModelListener<PositionFeedbackPort>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionListPanel.class);
    private final FeedbackPositionController controller;
    private final FeedbackPositionModel feedbackPositionModel;
    private final FeedbackPositionTableModel feedbackPositionTableModel;
    protected final ScheduledExecutorService outdatedPositionWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("outdatedPositionsWorkers-thread-%d").build());
    private final int outdatedTimeout = 2000;

    public FeedbackPositionListPanel(FeedbackPositionController controller, FeedbackPositionModel feedbackPositionModel, FeedbackPositionTableModel tableModel) {
        super((SimplePortTableModel)tableModel, Resources.getString(FeedbackPositionListPanel.class, (String)"empty_table"));
        this.controller = controller;
        this.feedbackPositionModel = feedbackPositionModel;
        LOGGER.debug("Create new FeedbackPositionListPanel.");
        FeedbackPositionTableCellRenderer renderer = new FeedbackPositionTableCellRenderer();
        renderer.setTimeout(2000);
        this.table.setDefaultCellRenderer((TableCellRenderer)renderer);
        this.table.setDefaultEditor(PositionFeedbackPort.class, (TableCellEditor)new /* Unavailable Anonymous Inner Class!! */);
        this.table.setRowHeight(60);
        this.table.setTableHeader(null);
        this.feedbackPositionTableModel = tableModel;
        this.feedbackPositionModel.addPortListListener((PortListListener)this);
        int interval = 2000;
        this.outdatedPositionWorker.scheduleAtFixedRate(() -> {
            LOGGER.debug("Trigger check outdated positions.");
            try {
                this.triggerValidatePositions();
            }
            catch (Exception ex) {
                LOGGER.warn("Trigger the position failed.", (Throwable)ex);
            }
            LOGGER.debug("Trigger position has finished.");
        }, 500L, interval, TimeUnit.MILLISECONDS);
    }

    protected PortTable createPortTable(SimplePortTableModel<FeedbackPortStatus, PositionFeedbackPort, PortModelListener<PositionFeedbackPort>> tableModel, String emptyTableText) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void listChanged() {
        LOGGER.debug("List has changed, remove all rows and add rows again.");
        this.tableModel.setRowCount(0);
        List ports = this.getPorts();
        ((FeedbackPositionTableModel)this.tableModel).addRows(ports);
    }

    protected List<PositionFeedbackPort> getPorts() {
        if (this.feedbackPositionModel != null) {
            return this.feedbackPositionModel.getPortList();
        }
        return Collections.emptyList();
    }

    public Class<?> getPortClass() {
        return PositionFeedbackPort.class;
    }

    private void triggerValidatePositions() {
        if (this.feedbackPositionModel != null) {
            ArrayList outdatedPorts = new ArrayList();
            this.feedbackPositionModel.validatePositions(outdatedPorts, 2000L);
            if (CollectionUtils.isNotEmpty(outdatedPorts)) {
                LOGGER.debug("Update outdated ports.");
                try {
                    SwingUtilities.invokeAndWait(() -> this.feedbackPositionTableModel.validatePositions(outdatedPorts));
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    LOGGER.warn("Validate outdated positions failed.", (Throwable)ex);
                }
            }
        }
    }

    public void cleanup() {
        this.outdatedPositionWorker.shutdown();
    }
}

