package org.bidib.wizard.config;

import javax.swing.JFrame;

import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.mvc.locolist.controller.LocoTableController;
import org.springframework.context.ApplicationContext;

import com.vlsolutions.swing.docking.DockingDesktop;

public interface LocoTableControllerFactory {

    /**
     * Create the LocoTableController instance.
     * 
     * @param node
     *            the node
     * @param desktop
     *            the desktop instance
     * @param parent
     *            the parent frame
     * @return the LocoTableController instance
     */
    LocoTableController createLocoTableController(
        final NodeInterface node, final DockingDesktop desktop, JFrame parent,
        final ApplicationContext applicationContext);

}
