package org.bidib.wizard.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.JHyperlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;

public class AboutDialog {

    private static final Logger LOGGER = LoggerFactory.getLogger(AboutDialog.class);

    private final Properties version = new Properties();

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, fill:150dlu:grow";

    private static final String ENCODED_DIALOG_ROWS_SPECS =
        "p, 10dlu, top:p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, fill:pref:grow";

    /**
     * Create new instance of AboutDialog.
     * 
     * @param parentComponent
     *            the parent component
     */
    public AboutDialog(Component parentComponent) {

        try {
            version.load(getClass().getResourceAsStream("/META-INF/build-info.properties"));
        }
        catch (Exception ex) {
            LOGGER.warn("Load build info failed.", ex);
        }

        JOptionPane pane = new JOptionPane(getPanel(), JOptionPane.INFORMATION_MESSAGE);
        JDialog dialog =
            pane
                .createDialog(parentComponent,
                    Resources.getString(getClass(), "title") + " " + version.getProperty("build.name"));

        dialog.setVisible(true);
    }

    private JPanel getPanel() {

        // create form builder
        boolean debugDialog = false;
        FormBuilder dialogBuilder =
            FormBuilder
                .create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROWS_SPECS)
                .panel(debugDialog ? new FormDebugPanel() : new JPanel(new BorderLayout()));

        dialogBuilder.border(Paddings.TABBED_DIALOG);

        int row = 1;

        dialogBuilder.add(version.getProperty("build.name")).xyw(1, row, 3);

        row += 2;

        String authorsText =
            "<html>"
                + Stream.of(version.getProperty("build.projectauthor").split(";")).collect(Collectors.joining("<br/>"))
                + "</html>";

        dialogBuilder.add(Resources.getString(getClass(), "authors")).xy(1, row);
        dialogBuilder.add(authorsText).xy(3, row);

        row += 2;

        dialogBuilder.add(Resources.getString(getClass(), "version")).xy(1, row);
        dialogBuilder.add(version.getProperty("build.version")).xy(3, row);

        row += 2;

        dialogBuilder.add(Resources.getString(getClass(), "build")).xy(1, row);
        dialogBuilder.add(version.getProperty("build.buildnumber-and-branch-info")).xy(3, row);

        row += 2;

        final LocalDateTime parsed =
            LocalDateTime.parse(version.getProperty("build.time"), DateTimeFormatter.ISO_DATE_TIME);
        dialogBuilder.add(Resources.getString(getClass(), "date")).xy(1, row);
        dialogBuilder.add(parsed.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).xy(3, row);

        row += 2;

        dialogBuilder.add(Resources.getString(getClass(), "java")).xy(1, row);
        dialogBuilder.add(System.getProperty("java.version")).xy(3, row);

        row += 2;

        JHyperlink famfamfamHyperLink = new JHyperlink();
        famfamfamHyperLink.setURL("http://www.famfamfam.com/lab/icons/silk/");
        famfamfamHyperLink.setText("Icons provided by http://www.famfamfam.com/lab/icons/silk/");
        dialogBuilder.add(famfamfamHyperLink).xyw(1, row, 3);

        row += 2;

        JHyperlink jideHyperLink = new JHyperlink();
        jideHyperLink.setURL("http://www.jidesoft.com");
        jideHyperLink.setText("Free JIDE license for open source project by http://www.jidesoft.com");
        dialogBuilder.add(jideHyperLink).xyw(1, row, 3);

        row += 2;

        dialogBuilder
            .add("<html>Images provided by:<br/>OpenDCC, Martin Welzel, Andreas Tillner</html>").xyw(1, row, 3);

        row += 2;

        dialogBuilder
            .add("<html>NL translation: Bert van der Lugt Melsert<br/>FR translation: Yann Monbaron</html>")
            .xyw(1, row, 3);

        return dialogBuilder.build();
    }
}
