package org.bidib.wizard.mvc.accessory.controller;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

import javax.swing.JFrame;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AccessoryAcknowledge;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.connection.AbstractMessageEvent;
import org.bidib.wizard.api.model.connection.event.CommandStationAccessoryAckMessageEvent;
import org.bidib.wizard.core.model.connection.MessageAdapter;
import org.bidib.wizard.core.model.connection.MessageEventConsumer;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.mvc.accessory.controller.listener.AccessoryControllerListener;
import org.bidib.wizard.mvc.accessory.model.AccessoryModel;
import org.bidib.wizard.mvc.accessory.view.AccessoryView;
import org.bidib.wizard.mvc.accessory.view.listener.AccessoryViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessoryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryController.class);

    private final Collection<AccessoryControllerListener> listeners = new LinkedList<AccessoryControllerListener>();

    private final NodeInterface node;

    private final JFrame parent;

    private final int x;

    private final int y;

    private final AccessoryModel model = new AccessoryModel();

    @Autowired
    private ConnectionService connectionService;

    private MessageAdapter messageAdapter;

    public AccessoryController(final NodeInterface node, JFrame parent, int x, int y) {
        this.node = node;
        this.parent = parent;
        this.x = x;
        this.y = y;
    }

    public void addAccessoryControllerListener(AccessoryControllerListener listener) {
        listeners.add(listener);
    }

    public void start() {

        this.messageAdapter = new MessageAdapter(connectionService) {

            @Override
            protected void prepareMessageMap(
                Map<Class<? extends AbstractMessageEvent>, MessageEventConsumer<AbstractMessageEvent, NodeInterface>> messageActionMap) {
                LOGGER.info("Prepare the message map.");

                messageActionMap.put(CommandStationAccessoryAckMessageEvent.class, (evt, node) -> {
                    CommandStationAccessoryAckMessageEvent event = (CommandStationAccessoryAckMessageEvent) evt;

                    int decoderAddress = event.getDecoderAddress();
                    AccessoryAcknowledge acknowledge = event.getAccessoryAcknowledge();

                    LOGGER
                        .info("csAccessoryAcknowledge, decoderAddress: {}, acknowledge: {}", decoderAddress,
                            acknowledge);
                    if (decoderAddress == model.getDccAddress()) {
                        model.setAcknowledge(acknowledge);
                        // reset the address
                        // model.setDccAddress(null);
                    }
                });
            }

            @Override
            protected void onDisconnect() {

                super.onDisconnect();
            }
        };
        this.messageAdapter.setNode(node);
        this.messageAdapter.start();

        // create the view
        final AccessoryView accessoryView = new AccessoryView(parent, model, x, y);
        accessoryView.addAccessoryViewListener(new AccessoryViewListener() {

            @Override
            public void close() {

                LOGGER.info("Close the dialog.");

                messageAdapter.dispose();

                // fireClose();
            }

            @Override
            public void sendAccessoryRequest(
                AddressData dccAddress, int aspect, Integer switchTime, TimeBaseUnitEnum timeBaseUnit,
                TimingControlEnum timingControl) {
                LOGGER.info("Send the DCC accessory request, address: {}, aspect: {}", dccAddress, aspect);
                // reset the acknowledge to ha the new acknowledge signaled
                model.setAcknowledge(null);
                // set the DCC address because we evaluate it in the acknowledge
                model.setDccAddress(dccAddress.getAddress());

                for (AccessoryControllerListener listener : listeners) {
                    AccessoryAcknowledge accessoryAcknowledge =
                        listener
                            .sendAccessoryRequest(node, dccAddress, aspect, switchTime, timeBaseUnit, timingControl);

                    LOGGER.info("Returned acknowledge: {}", accessoryAcknowledge);

                    model.setAcknowledge(accessoryAcknowledge);
                }
            }

            @Override
            public void sendAccessoryRequest(AddressData dccAddress, int aspect, int coilState) {
                LOGGER
                    .info("Send the DCC accessory request, address: {}, aspect: {}, coilState: {}", dccAddress, aspect,
                        coilState);
                // reset the acknowledge to ha the new acknowledge signaled
                model.setAcknowledge(null);
                // set the DCC address because we evaluate it in the acknowledge
                model.setDccAddress(dccAddress.getAddress());

                for (AccessoryControllerListener listener : listeners) {
                    AccessoryAcknowledge accessoryAcknowledge =
                        listener.sendAccessoryRequest(node, dccAddress, aspect, coilState);

                    LOGGER.info("Returned acknowledge: {}", accessoryAcknowledge);

                    model.setAcknowledge(accessoryAcknowledge);
                }
            }

            @Override
            public void sendExtendedAccessoryRequest(AddressData dccAddress, int aspect) {
                LOGGER.info("Send the DCC extended accessory request, address: {}, aspect: {}", dccAddress, aspect);
                // reset the acknowledge to ha the new acknowledge signaled
                model.setAcknowledge(null);
                // set the DCC address because we evaluate it in the acknowledge
                model.setDccAddress(dccAddress.getAddress());

                for (AccessoryControllerListener listener : listeners) {
                    AccessoryAcknowledge accessoryAcknowledge =
                        listener.sendExtendedAccessoryRequest(node, dccAddress, aspect);

                    LOGGER.info("Returned acknowledge: {}", accessoryAcknowledge);

                    model.setAcknowledge(accessoryAcknowledge);
                }
            }
        });
    }
}
