package org.bidib.wizard.mvc.main.view.panel.renderer;

import org.bidib.jbidibc.messages.enums.IoBehaviourSwitchEnum;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.mvc.main.model.SwitchPortTableModel;
import org.bidib.wizard.mvc.main.view.table.ConfigurablePortComboBoxRenderer;

public final class IoBehaviourSwitchComboBoxRenderer extends ConfigurablePortComboBoxRenderer<IoBehaviourSwitchEnum> {
    private static final long serialVersionUID = 1L;

    public IoBehaviourSwitchComboBoxRenderer(IoBehaviourSwitchEnum[] items, byte... pcfgType) {
        super(SwitchPortTableModel.COLUMN_PORT_INSTANCE, items, pcfgType);

        setRenderer(new IoBehaviourSwitchCellRenderer());
    }

    @Override
    protected Object getCurrentValue(ConfigurablePort<?> port) {
        IoBehaviourSwitchEnum value = ((SwitchPort) port).getOutputBehaviour();
        // filter out UNKNOWN value
        if (IoBehaviourSwitchEnum.UNKNOWN == value) {
            value = null;
        }
        return value;
    }
}