package org.bidib.wizard.mvc.ping.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonPropertyOrder({ "uid", "pingInterval", "additionalFillBytesCount", "additionalTotalBytesCount",
    "additionalPayloadStartValue", "identityProcessingWaitDuration" })
public class PingTableNodePreferenceEntry {

    private String uid;

    private int pingInterval = 200;

    private int additionalFillBytesCount;

    private int additionalTotalBytesCount;

    private int additionalPayloadStartValue = 0xB0;

    private int identityProcessingWaitDuration;

    public PingTableNodePreferenceEntry() {
    }

    public PingTableNodePreferenceEntry(String uid) {
        this.uid = uid;
    }

    /**
     * @return the uid
     */
    public String getUid() {
        return uid;
    }

    /**
     * @param uid
     *            the uid to set
     */
    public void setUid(String uid) {
        this.uid = uid;
    }

    /**
     * @return the pingInterval
     */
    public int getPingInterval() {
        return pingInterval;
    }

    /**
     * @param pingInterval
     *            the pingInterval to set
     */
    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
    }

    /**
     * @return the additionalFillBytesCount
     */
    public int getAdditionalFillBytesCount() {
        return additionalFillBytesCount;
    }

    /**
     * @param additionalFillBytesCount
     *            the additionalFillBytesCount to set
     */
    public void setAdditionalFillBytesCount(int additionalFillBytesCount) {
        this.additionalFillBytesCount = additionalFillBytesCount;
    }

    /**
     * @return the additionalTotalBytesCount
     */
    public int getAdditionalTotalBytesCount() {
        return additionalTotalBytesCount;
    }

    /**
     * @param additionalTotalBytesCount
     *            the additionalTotalBytesCount to set
     */
    public void setAdditionalTotalBytesCount(int additionalTotalBytesCount) {
        this.additionalTotalBytesCount = additionalTotalBytesCount;
    }

    /**
     * @return the additionalPayloadStartValue
     */
    public int getAdditionalPayloadStartValue() {
        return additionalPayloadStartValue;
    }

    /**
     * @param additionalPayloadStartValue
     *            the additionalPayloadStartValue to set
     */
    public void setAdditionalPayloadStartValue(int additionalPayloadStartValue) {
        this.additionalPayloadStartValue = additionalPayloadStartValue;
    }

    /**
     * @return the identityProcessingWaitDuration
     */
    public int getIdentityProcessingWaitDuration() {
        return identityProcessingWaitDuration;
    }

    /**
     * @param identityProcessingWaitDuration
     *            the identityProcessingWaitDuration to set
     */
    public void setIdentityProcessingWaitDuration(int identityProcessingWaitDuration) {
        this.identityProcessingWaitDuration = identityProcessingWaitDuration;
    }

}
