/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.booster.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.utils.MessageUtils;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.BoosterStatusListener;
import org.bidib.wizard.api.model.listener.CommandStationStatusListener;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.statusbar.StatusBarPublisher;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.booster.model.BoosterModel;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterTableModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterTableModel.class);
    public static final String PROPERTY_BOOSTERS = "boosters";
    private ArrayListModel<BoosterModel> boosterList = new ArrayListModel();
    private final PropertyChangeListener boosterListener;
    private final CommandStationStatusListener commandStationStatusListener;
    private final BoosterStatusListener boosterStatusListener;
    private final ConsoleService consoleService;

    public BoosterTableModel(final StatusBarPublisher<String, Integer> publisher, final ConsoleService consoleService) {
        this.consoleService = consoleService;
        final Consumer<Integer> overcurrent = new Consumer<Integer>(){

            @Override
            public void accept(Integer current) {
                LOGGER.debug("OverCurrent detected: {}", (Object)current);
                StringBuilder sb = new StringBuilder("Received high current with value: ");
                sb.append(current);
                sb.append("mA");
                LOGGER.warn(sb.toString());
                publisher.publish((Object)sb.toString(), (Object)30);
            }
        };
        this.boosterListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                switch (evt.getPropertyName()) {
                    case "nodeLabel": {
                        LOGGER.debug("The booster label has been changed.");
                        BoosterModel booster = (BoosterModel)((Object)evt.getSource());
                        int index = BoosterTableModel.this.boosterList.indexOf((Object)booster);
                        if (index <= -1) break;
                        SwingUtilities.invokeLater(() -> BoosterTableModel.this.boosterList.fireContentsChanged(index));
                        break;
                    }
                }
            }
        };
        this.commandStationStatusListener = new CommandStationStatusListener(){

            public void statusChanged(NodeInterface node, CommandStationStatus commandStationStatus) {
                LOGGER.debug("Set the command station status: {}", (Object)commandStationStatus);
                SwingUtils.executeInEDT(() -> BoosterTableModel.this.setCommandStationStatus(node, commandStationStatus));
            }
        };
        this.boosterStatusListener = new BoosterStatusListener(){

            public void voltageChanged(NodeInterface node, Integer voltage) {
                SwingUtils.executeInEDT(() -> BoosterTableModel.this.setBoosterVoltage(node, voltage));
            }

            public void temperatureChanged(NodeInterface node, Integer temperature) {
                SwingUtils.executeInEDT(() -> BoosterTableModel.this.setBoosterTemperature(node, temperature));
            }

            public void stateChanged(NodeInterface node, BoosterStatus status) {
                LOGGER.debug("Set the booster state: {}, node: {}", (Object)status, (Object)node);
                SwingUtils.executeInEDT(() -> this.changeBoosterState(node, status));
            }

            private void changeBoosterState(NodeInterface node, BoosterStatus status) {
                BoosterTableModel.this.setBoosterState(node, status);
                try {
                    if (BoosterStatus.OFF_SHORT == status || BoosterStatus.OFF_HOT == status) {
                        ConsoleController.ensureConsoleVisible();
                        String nodeIdentifier = MessageUtils.formatNodeAddressAndName((Node)node.getNode());
                        consoleService.addConsoleLine(ConsoleColor.red, String.format("The booster node %s has signalled an booster state error: %s", nodeIdentifier, status));
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Show booster state error in console failed.", (Throwable)ex);
                }
            }

            public void maximumCurrentChanged(NodeInterface node, Integer maximumCurrent) {
            }

            public void currentChanged(NodeInterface node, Integer current, long timestamp) {
                SwingUtilities.invokeLater(() -> BoosterTableModel.this.setBoosterCurrent(node, current, overcurrent));
            }

            public void controlChanged(NodeInterface node, BoosterControl control) {
                LOGGER.info("The booster control has changed: {}", (Object)control);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBooster(NodeInterface node, WizardLabelWrapper wizardLabelWrapper) {
        ArrayListModel<BoosterModel> arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            BoosterModel booster = new BoosterModel(node, wizardLabelWrapper, this.boosterListener);
            if (!this.boosterList.contains((Object)booster)) {
                LOGGER.info("Add booster to booster list: {}", (Object)node);
                booster.registerNode();
                String nodeLabel = booster.prepareNodeLabel();
                booster.setNodeLabel(nodeLabel);
                LinkedList<BoosterModel> oldValue = new LinkedList<BoosterModel>((Collection<BoosterModel>)this.boosterList);
                this.boosterList.add((Object)booster);
                this.firePropertyChange(PROPERTY_BOOSTERS, oldValue, this.boosterList);
                if (node.getBoosterNode() != null) {
                    BoosterNodeInterface boosterNode = node.getBoosterNode();
                    boosterNode.addBoosterStatusListener(this.boosterStatusListener);
                    if (boosterNode.getBoosterStatus() != null) {
                        booster.setState(boosterNode.getBoosterStatus().getBoosterState());
                    }
                    booster.setVoltage(boosterNode.getBoosterVoltage());
                    booster.setTemperature(boosterNode.getBoosterTemperature());
                }
                if (node.getCommandStationNode() != null) {
                    CommandStationNodeInterface commandStationNode = node.getCommandStationNode();
                    commandStationNode.addCommandStationStatusListener(this.commandStationStatusListener);
                    if (commandStationNode.getCommandStationStatus() != null) {
                        booster.setCommandStationState(commandStationNode.getCommandStationStatus().getCommandStationState());
                    }
                }
            } else {
                LOGGER.warn("Node is already in booster list: {}", (Object)node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBooster(NodeInterface node) {
        ArrayListModel<BoosterModel> arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            LOGGER.info("Remove booster from booster list: {}", (Object)node);
            LinkedList<BoosterModel> oldValue = new LinkedList<BoosterModel>((Collection<BoosterModel>)this.boosterList);
            int index = this.boosterList.indexOf((Object)new BoosterModel(node, null, null));
            if (index > -1) {
                BoosterModel removed = (BoosterModel)((Object)this.boosterList.remove(index));
                if (removed != null) {
                    try {
                        if (removed.getBooster().getBoosterNode() != null) {
                            removed.getBooster().getBoosterNode().removeBoosterStatusListener(this.boosterStatusListener);
                        }
                        if (node.getCommandStationNode() != null) {
                            node.getCommandStationNode().removeCommandStationStatusListener(this.commandStationStatusListener);
                        }
                        removed.freeNode();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Free booster node failed.", (Throwable)ex);
                    }
                }
                this.firePropertyChange(PROPERTY_BOOSTERS, oldValue, this.boosterList);
            }
        }
    }

    public ArrayListModel<BoosterModel> getBoosterListModel() {
        return this.boosterList;
    }

    public List<BoosterModel> getBoosters() {
        return Collections.unmodifiableList(this.boosterList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoosterState(NodeInterface node, BoosterStatus state) {
        int fireChangeIndex = -1;
        ArrayListModel<BoosterModel> arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                int index;
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.trace("Found booster to update: {}", (Object)booster);
                booster.setState(state != null ? state.getBoosterState() : null);
                fireChangeIndex = index = this.boosterList.indexOf((Object)booster);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.boosterList.fireContentsChanged(fireChangeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandStationStatus(NodeInterface node, CommandStationStatus status) {
        int fireChangeIndex = -1;
        ArrayListModel<BoosterModel> arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                int index;
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.trace("Found command station to update: {}", (Object)booster);
                if (status == null) {
                    LOGGER.warn("The command station status is not available. Use OFF as state.");
                    status = CommandStationStatus.OFF;
                }
                booster.setCommandStationState(status.getCommandStationState());
                fireChangeIndex = index = this.boosterList.indexOf((Object)booster);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.boosterList.fireContentsChanged(fireChangeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoosterCurrent(NodeInterface node, Integer current, Consumer<Integer> overcurrent) {
        int fireChangeIndex = -1;
        ArrayListModel<BoosterModel> arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                int index;
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.trace("Found booster to update: {}", (Object)booster);
                booster.setCurrent(current);
                if (current != null && booster.getMaxCurrent() != null && overcurrent != null && current > booster.getMaxCurrent()) {
                    overcurrent.accept(current);
                }
                fireChangeIndex = index = this.boosterList.indexOf((Object)booster);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.boosterList.fireContentsChanged(fireChangeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerFetchBoosterMaxCurrent(NodeInterface node) {
        BoosterModel boosterToFetch = null;
        ArrayListModel<BoosterModel> arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.info("Fetch the max current value for booster: {}", (Object)booster);
                boosterToFetch = booster;
                break;
            }
        }
        if (boosterToFetch != null) {
            boosterToFetch.fetchMaxBoosterCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoosterVoltage(NodeInterface node, Integer voltage) {
        int fireChangeIndex = -1;
        ArrayListModel<BoosterModel> arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                int index;
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.trace("Found booster to update: {}", (Object)booster);
                booster.setVoltage(voltage);
                fireChangeIndex = index = this.boosterList.indexOf((Object)booster);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.boosterList.fireContentsChanged(fireChangeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoosterTemperature(NodeInterface node, int temperature) {
        int fireChangeIndex = -1;
        ArrayListModel<BoosterModel> arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                int index;
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.trace("Found booster to update: {}", (Object)booster);
                booster.setTemperature(temperature);
                fireChangeIndex = index = this.boosterList.indexOf((Object)booster);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.boosterList.fireContentsChanged(fireChangeIndex);
        }
    }
}

