/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.function.Consumer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.mvc.common.view.RegisteredDialog;
import org.bidib.wizard.mvc.common.view.ViewCloseListener;
import org.bidib.wizard.mvc.loco.controller.LocoControlListener;
import org.bidib.wizard.mvc.loco.model.LocoConfigModel;
import org.bidib.wizard.mvc.loco.view.LocoView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoDialog
extends JDialog
implements RegisteredDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoDialog.class);
    private static final long serialVersionUID = 1L;
    private LocoView locoView;
    private final LocoModel locoModel;
    private final Consumer<LocoModel> locoModelConsumer;
    private final Consumer<Integer> locoAddressChangeListener;
    private final LocoConfigModel locoConfigModel;

    public LocoDialog(JFrame parent, LocoModel locoModel, LocoConfigModel locoConfigModel, SettingsService settingsService, LocoControlListener locoControlListener, Consumer<LocoModel> locoModelConsumer, Consumer<Integer> locoAddressChangeListener) {
        super(parent);
        this.locoModel = locoModel;
        this.locoConfigModel = locoConfigModel;
        this.locoModelConsumer = locoModelConsumer;
        this.locoAddressChangeListener = locoAddressChangeListener;
        this.setDefaultCloseOperation(2);
        LOGGER.info("Create the locoDialog for locoModel: {}", (Object)locoModel);
        if (this.locoModel != null) {
            this.locoModelConsumer.accept(this.locoModel);
        }
        this.updateDialogTitle(locoModel.getAddress());
        this.addContentPanel(locoModel, locoConfigModel, settingsService, locoControlListener);
        this.setLocationRelativeTo(parent);
    }

    public void updateDialogTitle(Integer locoAddress) {
        if (this.locoConfigModel.isCarControlEnabled()) {
            if (locoAddress != null) {
                this.setTitle(Resources.getString(LocoView.class, (String)"title.car") + " - " + locoAddress);
            } else {
                this.setTitle(Resources.getString(LocoView.class, (String)"title.car"));
            }
        } else if (locoAddress != null) {
            this.setTitle(Resources.getString(LocoView.class, (String)"title.loco") + " - " + locoAddress);
        } else {
            this.setTitle(Resources.getString(LocoView.class, (String)"title.loco"));
        }
    }

    public static String prepareKey(Integer address) {
        if (address != null) {
            return LocoDialog.class.getSimpleName() + "-" + address;
        }
        return LocoDialog.class.getSimpleName() + "-";
    }

    @Override
    public String getKey() {
        LOGGER.info("Prepare the key: {}", (Object)this.locoModel);
        Integer address = this.locoModel != null ? this.locoModel.getAddress() : null;
        return LocoDialog.prepareKey(address);
    }

    @Override
    public Window getWindow() {
        return this;
    }

    private void addContentPanel(LocoModel locoModel, LocoConfigModel locoConfigModel, final SettingsService settingsService, LocoControlListener locoControlListener) {
        this.locoView = new LocoView(locoModel, locoConfigModel, settingsService, locoControlListener, this.locoAddressChangeListener, () -> this.resizeCallback());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LOGGER.info("The window is closing: {}", (Object)e.getWindow());
                LocoDialog.this.cleanup(settingsService);
                super.windowClosing(e);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                LOGGER.info("The window is closed: {}", (Object)e.getWindow());
                super.windowClosed(e);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.locoView.getComponent(), "Center");
        this.pack();
        this.setMinimumSize(new Dimension(this.locoView.getComponent().getPreferredSize().width, this.locoView.getComponent().getPreferredSize().height));
        this.setVisible(true);
    }

    private void resizeCallback() {
        this.pack();
    }

    public void addViewCloseListener(ViewCloseListener listener) {
        this.locoView.addViewCloseListener(listener);
    }

    public void close(SettingsService settingsService) {
        LOGGER.info("The LocoView should be closed.");
        this.cleanup(settingsService);
        LOGGER.info("Cleanup has passed, set visible false.");
        this.setVisible(false);
    }

    private void cleanup(SettingsService settingsService) {
        LOGGER.info("The LocoDialog is disposed.");
        if (this.locoView != null) {
            this.locoView.cleanup(settingsService);
        }
    }
}

