/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.view.speedo;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.mvc.loco.view.speedo.SpeedScaleBeanModel;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApproveSpeedRangeDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApproveSpeedRangeDialog.class);
    private final SpeedScaleBeanModel speedScaleBeanModel;
    private int result = 2;
    private final Integer scale;

    public ApproveSpeedRangeDialog(Frame frame, SpeedScaleBeanModel speedScaleBeanModel) {
        this.scale = speedScaleBeanModel.getCv37Scale();
        this.speedScaleBeanModel = speedScaleBeanModel;
        FormBuilder formBuilder = null;
        boolean debugDialog = false;
        formBuilder = debugDialog ? FormBuilder.create().columns("pref, 3dlu, pref, 2dlu, pref:grow", new Object[0]).rows("pref, 3dlu, pref", new Object[0]).panel((JPanel)new FormDebugPanel()) : FormBuilder.create().columns("pref, 3dlu, 30dlu, 2dlu, pref:grow", new Object[0]).rows("pref, 3dlu, pref", new Object[0]);
        PropertyAdapter vTargetMinValueModel = new PropertyAdapter((Object)this.speedScaleBeanModel, "targetMinSpeed", true);
        ConverterValueModel vTargetMinConverterModel = new ConverterValueModel((ValueModel)vTargetMinValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField vTargetMin = WizardComponentFactory.createTextField((ValueModel)vTargetMinConverterModel, (boolean)false);
        vTargetMin.setHorizontalAlignment(4);
        formBuilder.add(Resources.getString(this.getClass(), (String)"vMin"), new Object[0]).xy(1, 1);
        formBuilder.add((Component)vTargetMin).xy(3, 1);
        formBuilder.add(Resources.getString(this.getClass(), (String)"kmh"), new Object[0]).xy(5, 1);
        PropertyAdapter vTargetMaxValueModel = new PropertyAdapter((Object)this.speedScaleBeanModel, "targetMaxSpeed", true);
        ConverterValueModel vTargetMaxConverterModel = new ConverterValueModel((ValueModel)vTargetMaxValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField vTargetMax = WizardComponentFactory.createTextField((ValueModel)vTargetMaxConverterModel, (boolean)false);
        vTargetMax.setHorizontalAlignment(4);
        formBuilder.add(Resources.getString(this.getClass(), (String)"vTargetMax"), new Object[0]).xy(1, 3);
        formBuilder.add((Component)vTargetMax).xy(3, 3);
        formBuilder.add(Resources.getString(this.getClass(), (String)"kmh"), new Object[0]).xy(5, 3);
        Function<Integer, Integer> speedConverterToKmH = val -> {
            int speedVal = 0;
            if (this.scale != null && this.scale > 1) {
                speedVal = (int)((double)val.intValue() * (double)this.scale.intValue() / 277.778);
                LOGGER.info("Converted speed: {} to speedVal: {}, scale: {}", new Object[]{val, speedVal, this.scale});
            } else {
                speedVal = val;
            }
            return speedVal;
        };
        Integer vMin = Optional.of(speedScaleBeanModel.getMeasuredMinSpeed()).map(speedConverterToKmH).orElse(0);
        Integer vMax = Optional.of(speedScaleBeanModel.getMeasuredMaxSpeed()).map(speedConverterToKmH).orElse(0);
        TaskDialog dlg = ApproveSpeedRangeDialog.questionDialog(frame, Resources.getString(this.getClass(), (String)"title"), (Icon)TaskDialog.StandardIcon.QUESTION, Resources.getString(this.getClass(), (String)"instruction", (Object[])new Object[]{vMin, vMax}), Resources.getString(this.getClass(), (String)"message"));
        dlg.setFixedComponent((JComponent)formBuilder.build());
        TaskDialog.Command result = dlg.show();
        LOGGER.info("Result of validate scale dialog: {}", (Object)result.equals((Object)TaskDialog.StandardCommand.OK));
        if (result.equals((Object)TaskDialog.StandardCommand.OK)) {
            this.fireContinue();
        } else {
            this.fireCancel();
        }
    }

    private void fireContinue() {
        LOGGER.info("Continue operation.");
        this.result = 0;
    }

    private void fireCancel() {
    }

    public int getResult() {
        return this.result;
    }

    public SpeedScaleBeanModel getSpeedScaleBeanModel() {
        return this.speedScaleBeanModel;
    }

    private static TaskDialog questionDialog(Window parent, String title, Icon icon, String instruction, String text) {
        TaskDialog dlg = new TaskDialog(parent, title);
        dlg.setInstruction(instruction);
        dlg.setText(text);
        dlg.setIcon(icon);
        dlg.setCommands(new TaskDialog.Command[]{TaskDialog.StandardCommand.OK.derive(Resources.getString(ApproveSpeedRangeDialog.class, (String)"update")), TaskDialog.StandardCommand.CANCEL.derive(Resources.getString(ApproveSpeedRangeDialog.class, (String)"cancel"))});
        return dlg;
    }
}

