/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.view.wizard;

import com.jidesoft.dialog.PageEvent;
import com.jidesoft.dialog.PageListener;
import com.jidesoft.wizard.CompletionWizardPage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.locolist.model.LocoLibraryModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletionPage
extends CompletionWizardPage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletionPage.class);
    private final LocoLibraryModel locoLibrary;
    private String executionStatus;

    public CompletionPage(final LocoLibraryModel locoLibrary) {
        super(Resources.getString(CompletionPage.class, (String)"title"), Resources.getString(CompletionPage.class, (String)"description.waiting"));
        this.locoLibrary = locoLibrary;
        this.executionStatus = Resources.getString(CompletionPage.class, (String)"result.pending");
        locoLibrary.addPropertyChangeListener("executionStatus", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("The execution status has changed: {}", evt.getNewValue());
                SwingUtilities.invokeLater(() -> {
                    CompletionPage.this.executionStatus = evt.getNewValue().toString();
                    CompletionPage.this.reset();
                    CompletionPage.this.repaint();
                });
            }
        });
        locoLibrary.addPropertyChangeListener("pushToMouse", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean isPushToMouse = locoLibrary.isPushToMouse();
                if (!isPushToMouse) {
                    SwingUtilities.invokeLater(() -> {
                        LOGGER.info("Enable the finish button");
                        CompletionPage.this.fireButtonEvent(3301, "FINISH");
                        LOGGER.info("Enable the back button");
                        CompletionPage.this.fireButtonEvent(3301, "BACK");
                    });
                }
            }
        });
        this.addPageListener(new PageListener(){

            public void pageEventFired(PageEvent e) {
                switch (e.getID()) {
                    case 3199: {
                        LOGGER.info("Page was opened.");
                        CompletionPage.this.executionStatus = Resources.getString(CompletionPage.class, (String)"result.pending");
                        CompletionPage.this.reset();
                        break;
                    }
                    case 3200: {
                        JButton button;
                        if (!(e.getSource() instanceof JButton) || !"BACK".equals((button = (JButton)e.getSource()).getName())) break;
                        LOGGER.info("The back button was pressed, reset the execution status.");
                        CompletionPage.this.executionStatus = Resources.getString(CompletionPage.class, (String)"result.pending");
                        locoLibrary.setExecutionResult(LocoLibraryModel.ExecutionResult.PENDING);
                        break;
                    }
                }
            }
        });
    }

    protected void initContentPane() {
        LOGGER.info("Init the content pane was called.");
        super.initContentPane();
        this.updatePageLabels();
    }

    private void updatePageLabels() {
        LOGGER.info("Update the page labels.");
        switch (this.locoLibrary.getExecutionResult()) {
            case FAILED: {
                this.addWarning(Resources.getString(CompletionPage.class, (String)"result.failed"));
                break;
            }
            case PASSED: {
                this.addInfo(Resources.getString(CompletionPage.class, (String)"result.passed"));
                break;
            }
            default: {
                this.addInfo(this.executionStatus);
            }
        }
    }

    public void setupWizardButtons() {
        LOGGER.info("Setup the wizard buttons.");
        super.setupWizardButtons();
        LOGGER.info("Disable the finish button");
        this.fireButtonEvent(3302, "FINISH");
        LOGGER.info("Disable the back button");
        this.fireButtonEvent(3302, "BACK");
    }
}

