/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.awt.Component;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.AccessorySwitchTimeModel;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.view.DefaultBusyFrame;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.labels.AccessoryLabelUtils;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.stringdata.StoredStrings;
import org.bidib.wizard.mvc.main.model.AccessoryStartupAspectModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.AccessoryRequestListener;
import org.bidib.wizard.mvc.main.view.panel.AccessoryListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class AccessoryPanelController
implements AccessoryRequestListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryPanelController.class);
    private final MainModel mainModel;
    private final AccessoryStartupAspectModel accessoryStartupAspectModel;
    private final AccessorySwitchTimeModel accessorySwitchTimeModel;
    private AccessoryListPanel accessoryListPanel;
    private NodeInterface controlledNode;
    private final PropertyChangeListener storedStringsChangeListener;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private StatusBar statusBar;
    @Autowired
    private ConsoleService consoleService;

    public AccessoryPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.accessoryStartupAspectModel = new AccessoryStartupAspectModel();
        this.accessorySwitchTimeModel = new AccessorySwitchTimeModel();
        AnnotationProcessor.process((Object)this);
        this.storedStringsChangeListener = evt -> {
            LOGGER.info("The stored string has changed.");
            if (evt instanceof IndexedPropertyChangeEvent) {
                IndexedPropertyChangeEvent ipce = (IndexedPropertyChangeEvent)evt;
                this.handleStringChanged(ipce.getIndex(), (String)ipce.getNewValue());
            }
        };
    }

    public AccessoryListPanel createAccessoryListPanel(TabVisibilityListener tabVisibilityListener) {
        this.accessoryListPanel = new AccessoryListPanel(this, this.mainModel, this.accessoryStartupAspectModel, this.accessorySwitchTimeModel, tabVisibilityListener, this.settingsService, this.wizardLabelWrapper, this.statusBar, this.consoleService);
        this.accessoryListPanel.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    try {
                        DefaultBusyFrame.setWaitCursor((Component)AccessoryPanelController.this.accessoryListPanel.getComponent());
                        DefaultTableModel accessoryListModel = (DefaultTableModel)e.getSource();
                        int selectedRow = e.getFirstIndex();
                        if (selectedRow > -1) {
                            Object value = accessoryListModel.getValueAt(selectedRow, 0);
                            LOGGER.info("The selected accessory has changed: {}, selectedRow: {}", value, (Object)selectedRow);
                            if (!(value instanceof Accessory)) {
                                LOGGER.info("Discard change of label.");
                                return;
                            }
                            Accessory accessory = (Accessory)value;
                            if (accessory != null) {
                                AccessoryPanelController.this.mainModel.setSelectedAccessory(accessory);
                            }
                        }
                    }
                    finally {
                        DefaultBusyFrame.setDefaultCursor((Component)AccessoryPanelController.this.accessoryListPanel.getComponent());
                    }
                }
            }
        });
        this.mainModel.addNodeListListener((NodeListListener)new DefaultNodeListListener(){

            public void nodeChanged(NodeInterface node) {
                StoredStrings storedStringsNs2;
                NodeInterface selectedNode = AccessoryPanelController.this.mainModel.getSelectedNode();
                if (selectedNode != null && selectedNode.equals((Object)AccessoryPanelController.this.controlledNode)) {
                    LOGGER.warn("The selected node is the controlled node. Skip update of node data.");
                    return;
                }
                LOGGER.info("The selected node has changed, current controlledNode: {}", (Object)AccessoryPanelController.this.controlledNode);
                if (AccessoryPanelController.this.controlledNode != null && (storedStringsNs2 = AccessoryPanelController.this.controlledNode.getStoredStringsNs2()) != null) {
                    LOGGER.info("Remove the property change listener for stored strings.");
                    storedStringsNs2.removePropertyChangeListener("storedStrings", AccessoryPanelController.this.storedStringsChangeListener);
                }
                AccessoryPanelController.this.controlledNode = selectedNode;
                if (AccessoryPanelController.this.controlledNode != null && (storedStringsNs2 = AccessoryPanelController.this.controlledNode.getStoredStringsNs2()) != null) {
                    LOGGER.info("Register the property change listener for stored strings.");
                    storedStringsNs2.addPropertyChangeListener("storedStrings", AccessoryPanelController.this.storedStringsChangeListener);
                }
            }
        });
        return this.accessoryListPanel;
    }

    public List<Macro> getMacros() {
        return this.mainModel.getMacros();
    }

    public NodeInterface getControlledNode() {
        return this.controlledNode;
    }

    public NodeInterface getSelectedNode() {
        return this.mainModel.getSelectedNode();
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    public AccessoryLabel getAccessoryAspectsLabels(int accessoryId) {
        NodeLabels nodeLabels = this.getNodeLabels();
        if (nodeLabels == null) {
            LOGGER.warn("No node labels avaialble.");
            return null;
        }
        return AccessoryLabelUtils.getAccessoryLabel((NodeLabels)nodeLabels, (int)accessoryId);
    }

    public void setAccessoryAspectLabel(int accessoryId, int aspectId, String label, boolean isUsesStrings) {
        if (isUsesStrings) {
            LOGGER.info("The accessory supports strings. Set the string on the node instead of save to local labels. Current aspectId: {}, label: {}", (Object)aspectId, (Object)label);
            String returnValue = this.nodeService.setString("main", this.getSelectedNode(), 2, aspectId, label);
            LOGGER.info("String set returnValue: {}", (Object)returnValue);
        } else {
            NodeLabels nodeLabels = this.getNodeLabels();
            if (nodeLabels == null) {
                LOGGER.info("No node labels avaialble.");
                return;
            }
            AccessoryLabelUtils.replaceAspectLabel((NodeLabels)nodeLabels, (int)accessoryId, (int)aspectId, (String)label);
            this.saveLabels();
        }
    }

    private void saveLabels() {
        try {
            long uniqueId = this.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void activateAspect(Accessory accessory, int aspectNumber) {
        LOGGER.info("Start accessory with aspect: {}, accessory: {}", (Object)aspectNumber, (Object)accessory);
        try {
            DefaultBusyFrame.setWaitCursor((Component)this.accessoryListPanel.getComponent());
            this.switchingNodeService.setAccessoryAspect("main", this.getSelectedNode().getSwitchingNode(), accessory, aspectNumber);
        }
        finally {
            DefaultBusyFrame.setDefaultCursor((Component)this.accessoryListPanel.getComponent());
        }
    }

    @Override
    public void storeAccessory(Accessory accessory) {
        LOGGER.info("Store the accessory: {}", (Object)accessory);
        try {
            DefaultBusyFrame.setWaitCursor((Component)this.accessoryListPanel.getComponent());
            Accessory accessoryClone = Accessory.cloneAccessoryData((Accessory)accessory);
            this.switchingNodeService.saveAccessory("main", this.getSelectedNode().getSwitchingNode(), accessoryClone);
        }
        finally {
            DefaultBusyFrame.setDefaultCursor((Component)this.accessoryListPanel.getComponent());
        }
    }

    public void reloadAccessory(Accessory accessory) {
        LOGGER.info("Reload the accessory: {}", (Object)accessory);
        try {
            DefaultBusyFrame.setWaitCursor((Component)this.accessoryListPanel.getComponent());
            Accessory accessoryClone = Accessory.cloneAccessoryData((Accessory)accessory);
            this.switchingNodeService.reloadAccessory("main", this.getSelectedNode().getSwitchingNode(), accessoryClone);
        }
        finally {
            DefaultBusyFrame.setDefaultCursor((Component)this.accessoryListPanel.getComponent());
        }
    }

    public void saveAccessoryLabel(Accessory accessory, String label) {
        LOGGER.info("Save the accessory label, accessory: {}, label: {}", (Object)accessory, (Object)label);
        accessory.setLabel(label);
        NodeLabels nodeLabels = this.getNodeLabels();
        AccessoryLabelUtils.replaceAccessoryLabel((NodeLabels)nodeLabels, (int)accessory.getId(), (String)label);
        this.saveLabels();
    }

    private void handleStringChanged(int index, String value) {
        LOGGER.debug("Set the new accessory string, index: {}, value: {}", (Object)index, (Object)value);
        if (this.accessoryListPanel != null) {
            this.accessoryListPanel.handleStringChanged(index, value);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.accessoryListPanel != null) {
            SwingUtilities.invokeLater(() -> this.accessoryListPanel.refreshView());
        }
    }
}

