/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import org.bidib.jbidibc.pi.BidibPiConnector;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.mvc.main.controller.BidibPiController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBidibPiController
implements BidibPiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBidibPiController.class);
    private BidibPiConnector connector;

    public void start(ApplicationContext applicationContext) {
        LOGGER.info("Start the DefaultBidibPiController.");
        try {
            BidibPiConnector.checkPlatform((String)"file:/proc/cpuinfo");
            this.connector = new BidibPiConnector();
            this.connector.connect();
        }
        catch (Exception ex) {
            LOGGER.warn("Create and initialize the connector to the Pi failed.", (Throwable)ex);
            if (this.connector != null) {
                LOGGER.info("Disconnect and free the pi connector.");
                this.connector.disconnect();
                this.connector = null;
            }
            throw new IllegalArgumentException("Init the pi connector failed.");
        }
        catch (Error ex) {
            LOGGER.warn("Create and initialize the connector to the Pi failed.", (Throwable)ex);
            if (this.connector != null) {
                LOGGER.info("Disconnect and free the pi connector.");
                this.connector.disconnect();
                this.connector = null;
            }
            throw new IllegalArgumentException("Init the pi connector failed.");
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.connector != null) {
                this.connector.disconnect();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Disconnect the connector to the Pi failed.", (Throwable)ex);
        }
    }

    @Override
    public void reset() {
        try {
            if (this.connector != null) {
                this.connector.resetBidibPi();
            } else {
                LOGGER.warn("No BiDiB-Pi to reset connected.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Reset the BiDiB-Pi failed.", (Throwable)ex);
        }
    }
}

