/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import javax.swing.SwingUtilities;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.main.model.FeedbackPositionModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.FeedbackPositionListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPositionPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionPanelController.class);
    private final MainModel mainModel;
    private final WizardSettingsInterface wizardSettings;
    private final NodeListListener nodeListListener;
    private final FeedbackPositionModel feedbackPositionModel;
    private FeedbackPositionListPanel feedbackPositionListPanel;

    public FeedbackPositionPanelController(final MainModel mainModel, WizardSettingsInterface wizardSettings) {
        this.mainModel = mainModel;
        this.wizardSettings = wizardSettings;
        this.feedbackPositionModel = new FeedbackPositionModel(this.wizardSettings);
        this.nodeListListener = new DefaultNodeListListener(){

            public void nodeChanged(NodeInterface node) {
                NodeInterface selectedNode = mainModel.getSelectedNode();
                LOGGER.info("The node has changed, selectedNode: {}", (Object)selectedNode);
                FeedbackPositionPanelController.this.feedbackPositionModel.setSelectedNode(selectedNode);
                SwingUtilities.invokeLater(() -> {
                    LOGGER.info("Notify that the selected node was changed.");
                    if (FeedbackPositionPanelController.this.feedbackPositionListPanel != null) {
                        FeedbackPositionPanelController.this.feedbackPositionListPanel.listChanged();
                    } else {
                        LOGGER.warn("The feedbackPortListPanel is not available.");
                    }
                });
            }
        };
        this.mainModel.addNodeListListener(this.nodeListListener);
    }

    public NodeInterface getSelectedNode() {
        return this.feedbackPositionModel.getSelectedNode();
    }

    public FeedbackPositionListPanel createFeedbackPositionListPanel(TabVisibilityListener tabVisibilityListener) {
        LOGGER.info("Create new feedbackPositionListPanel.");
        this.feedbackPositionListPanel = new FeedbackPositionListPanel(this, this.feedbackPositionModel, this.mainModel, tabVisibilityListener);
        return this.feedbackPositionListPanel;
    }
}

