/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.component;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterOnConfirmDialog
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterOnConfirmDialog.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, min(300dlu;pref)";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 10dlu, top:35dlu, 5dlu, pref, 5dlu, pref, 30dlu, pref";
    public static final int RESULT_CONTINUE_BOOSTER_AND_COMMANDSTATION = 3;
    private int result = 2;
    private ValueModel checkDoNotAskInFutureValueModel;
    private final CommandStationStartModel commandStationStartModel;
    private JComponent[] modeButtons;
    private final SettingsService settingsService;

    public BoosterOnConfirmDialog(JFrame frame, SettingsService settingsService) {
        super((Frame)frame, Resources.getString(BoosterOnConfirmDialog.class, (String)"title"), true);
        this.settingsService = settingsService;
        this.commandStationStartModel = new CommandStationStartModel();
        this.getContentPane().setLayout(new BorderLayout());
        FormBuilder builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel(new JPanel());
        builder.border((Border)Paddings.DIALOG);
        JLabel iconLabel = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
        int row = 1;
        builder.add((Component)iconLabel).xywh(1, row, 1, 2);
        JLabel messageLabel = new JLabel(Resources.getString(((Object)((Object)this)).getClass(), (String)"message-warn"));
        Font font = messageLabel.getFont();
        font = font.deriveFont(16.0f);
        messageLabel.setFont(font);
        messageLabel.setForeground(Color.RED);
        builder.add((Component)messageLabel).xy(3, row);
        JLabel messageInfoLabel = new JLabel(Resources.getString(((Object)((Object)this)).getClass(), (String)"message"));
        builder.add((Component)messageInfoLabel).xy(3, row += 2);
        row += 2;
        this.checkDoNotAskInFutureValueModel = new ValueHolder(settingsService.getWizardSettings().isAllBoosterOnDoNotConfirmSwitch());
        if (!((Boolean)this.checkDoNotAskInFutureValueModel.getValue()).booleanValue()) {
            JCheckBox checkDoNotAskInFuture = WizardComponentFactory.createCheckBox((ValueModel)this.checkDoNotAskInFutureValueModel, (String)Resources.getString(((Object)((Object)this)).getClass(), (String)"do-not-ask"));
            builder.add((Component)checkDoNotAskInFuture).xy(3, row);
            row += 2;
        } else {
            this.checkDoNotAskInFutureValueModel = null;
        }
        ButtonBarBuilder startModeButtons = new ButtonBarBuilder();
        startModeButtons.addFixed((JComponent)new JLabel("CS state"));
        startModeButtons.addRelatedGap();
        PropertyAdapter modeModel = new PropertyAdapter((Object)this.commandStationStartModel, "startMode", true);
        this.modeButtons = new JComponent[CommandStationStartMode.values().length];
        int index = 0;
        for (CommandStationStartMode mode : CommandStationStartMode.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)modeModel, (Object)((Object)mode), (String)Resources.getString(CommandStationStartMode.class, (String)mode.getKey()));
            this.modeButtons[index++] = radio;
            startModeButtons.addButton((JComponent)radio);
        }
        builder.add((Component)startModeButtons.build()).xy(3, row);
        ++row;
        JButton continueButton = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"continue"));
        continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoosterOnConfirmDialog.this.setVisible(false);
                BoosterOnConfirmDialog.this.fireContinue();
            }
        });
        JButton continueBoosterAndCommandStationButton = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"continueBoosterAndCommandStation"));
        continueBoosterAndCommandStationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoosterOnConfirmDialog.this.setVisible(false);
                BoosterOnConfirmDialog.this.fireContinueBoosterAndCommandStation();
            }
        });
        JButton cancel = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoosterOnConfirmDialog.this.setVisible(false);
                BoosterOnConfirmDialog.this.fireCancel();
            }
        });
        JPanel buttons = new ButtonBarBuilder().addButton(new JComponent[]{continueButton, continueBoosterAndCommandStationButton, cancel}).build();
        builder.add((Component)buttons).xy(3, row);
        this.getContentPane().add(builder.build());
        this.commandStationStartModel.setStartMode(CommandStationStartMode.valueOf(settingsService.getWizardSettings().getAllBoosterOnRequestedCommandStationState()));
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setMinimumSize(this.getSize());
        this.setVisible(true);
    }

    private void fireContinue() {
        LOGGER.info("Continue operation.");
        this.result = 0;
        if (this.checkDoNotAskInFutureValueModel != null && ((Boolean)this.checkDoNotAskInFutureValueModel.getValue()).booleanValue()) {
            LOGGER.info("Do not show confirm dialog in the future.");
            this.settingsService.getWizardSettings().setAllBoosterOnDoNotConfirmSwitch(true, this.result);
        }
        this.settingsService.getWizardSettings().setAllBoosterOnRequestedCommandStationState(this.getCommandStationStatus());
        this.settingsService.storeSettings();
    }

    private void fireContinueBoosterAndCommandStation() {
        LOGGER.info("Continue operation with booster and command station.");
        this.result = 3;
        if (this.checkDoNotAskInFutureValueModel != null && ((Boolean)this.checkDoNotAskInFutureValueModel.getValue()).booleanValue()) {
            LOGGER.info("Do not show confirm dialog in the future.");
            this.settingsService.getWizardSettings().setAllBoosterOnDoNotConfirmSwitch(true, this.result);
        }
        this.settingsService.getWizardSettings().setAllBoosterOnRequestedCommandStationState(this.getCommandStationStatus());
        this.settingsService.storeSettings();
    }

    private void fireCancel() {
    }

    public int getResult() {
        return this.result;
    }

    public CommandStationStatus getCommandStationStatus() {
        return this.commandStationStartModel.getStartMode().getValue();
    }

    public static final class CommandStationStartModel
    extends Model {
        private static final long serialVersionUID = 1L;
        public static final String PROPERTYNAME_START_MODE = "startMode";
        private CommandStationStartMode startMode = CommandStationStartMode.WATCHDOG;

        public CommandStationStartMode getStartMode() {
            return this.startMode;
        }

        public void setStartMode(CommandStationStartMode startMode) {
            CommandStationStartMode oldMode = this.startMode;
            this.startMode = startMode;
            this.firePropertyChange(PROPERTYNAME_START_MODE, (Object)oldMode, (Object)startMode);
        }
    }

    public static enum CommandStationStartMode {
        WATCHDOG("watchdog", CommandStationStatus.GO),
        IGN_WATCHDOG("ign-watchdog", CommandStationStatus.GO_IGN_WD);

        private final String key;
        private final CommandStationStatus value;

        private CommandStationStartMode(String key, CommandStationStatus value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public CommandStationStatus getValue() {
            return this.value;
        }

        public static CommandStationStartMode valueOf(CommandStationStatus value) {
            CommandStationStartMode result = null;
            for (CommandStationStartMode e : CommandStationStartMode.values()) {
                if (e.value != value) continue;
                result = e;
                break;
            }
            if (result == null) {
                throw new IllegalArgumentException("cannot map " + String.valueOf(value) + " to a command station state");
            }
            return result;
        }
    }
}

