/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.component;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SaveNodeConfigurationDialog
extends EscapeDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveNodeConfigurationDialog.class);
    private static final long serialVersionUID = 1L;
    public static final String SAVE_MACROS = "saveMacros";
    public static final String SAVE_ACCESSORIES = "saveAccessories";
    public static final String SAVE_BACKLIGHTPORTS = "saveBacklightPorts";
    public static final String SAVE_LIGHTPORTS = "saveLightPorts";
    public static final String SAVE_SWITCHPORTS = "saveSwitchPorts";
    public static final String SAVE_SERVOPORTS = "saveServoPorts";
    public static final String SAVE_FEATURES = "saveFeatures";
    public static final String SAVE_CVS = "saveConfigurationVariables";
    public static final String SAVE_ERRORS = "saveErrors";
    public static final String FEATURES_RESTORED = "featuresRestored";
    public static final String CV_VALUES_RESTORED = "cvValuesRestored";
    public static final String MACRO_AND_ACCESSORIES_RESTORED = "macroAndAccessoriesRestored";
    public static final String DEFAULT_IMPORT_CV_ONLY = "defaultImportCVOnly";
    private JCheckBox checkSaveMacros;
    private JCheckBox checkSaveAccessories;
    private JCheckBox checkSaveLightportConfiguration;
    private JCheckBox checkSaveBacklightportConfiguration;
    private JCheckBox checkSaveSwitchportConfiguration;
    private JCheckBox checkSaveServoportConfiguration;
    private JCheckBox checkSaveFeatures;
    private JCheckBox checkSaveConfigurationVariables;

    public SaveNodeConfigurationDialog(Frame frame, String title, String description, final NodeInterface node, Map<String, Object> importParams, boolean modal) {
        super(frame, StringUtils.isNotBlank((CharSequence)title) ? title : Resources.getString(SaveNodeConfigurationDialog.class, (String)"title"), modal);
        FormBuilder formBuilder = FormBuilder.create().columns("pref", new Object[0]).rows("pref", new Object[0]).panel(new JPanel());
        formBuilder.border((Border)Paddings.DIALOG);
        JLabel descriptionLabel = new JLabel((StringUtils.isNotBlank((CharSequence)description) ? "<html>" + description + "</html>" : "<html>" + Resources.getString(SaveNodeConfigurationDialog.class, (String)"description")) + "</html>");
        descriptionLabel.setBorder(new EmptyBorder(5, 5, 10, 5));
        formBuilder.add((Component)descriptionLabel).xy(1, 1);
        boolean defaultImportCVOnly = false;
        Boolean paramDefaultImportCVOnly = (Boolean)importParams.get(DEFAULT_IMPORT_CV_ONLY);
        if (paramDefaultImportCVOnly != null) {
            defaultImportCVOnly = paramDefaultImportCVOnly;
        }
        int row = 3;
        if (NodeUtils.hasAccessoryFunctions((long)node.getUniqueId())) {
            formBuilder.appendRows("3dlu, pref, 3dlu, pref", new Object[0]);
            this.checkSaveMacros = new JCheckBox(Resources.getString(SaveNodeConfigurationDialog.class, (String)"checkSaveMacros"), true);
            formBuilder.add((Component)this.checkSaveMacros).xy(1, row);
            this.checkSaveAccessories = new JCheckBox(Resources.getString(SaveNodeConfigurationDialog.class, (String)"checkSaveAccessories"), true);
            formBuilder.add((Component)this.checkSaveAccessories).xy(1, row += 2);
            row += 2;
            if (!this.isParamEnabled(importParams, MACRO_AND_ACCESSORIES_RESTORED)) {
                this.checkSaveMacros.setSelected(false);
                this.checkSaveMacros.setEnabled(false);
                this.checkSaveAccessories.setSelected(false);
                this.checkSaveAccessories.setEnabled(false);
            }
        }
        if (NodeUtils.hasSwitchFunctions((long)node.getUniqueId())) {
            formBuilder.appendRows("3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", new Object[0]);
            this.checkSaveLightportConfiguration = new JCheckBox(Resources.getString(SaveNodeConfigurationDialog.class, (String)"checkSaveLightportConfiguration"), true);
            formBuilder.add((Component)this.checkSaveLightportConfiguration).xy(1, row);
            this.checkSaveBacklightportConfiguration = new JCheckBox(Resources.getString(SaveNodeConfigurationDialog.class, (String)"checkSaveBacklightportConfiguration"), true);
            formBuilder.add((Component)this.checkSaveBacklightportConfiguration).xy(1, row += 2);
            this.checkSaveServoportConfiguration = new JCheckBox(Resources.getString(SaveNodeConfigurationDialog.class, (String)"checkSaveServoportConfiguration"), true);
            formBuilder.add((Component)this.checkSaveServoportConfiguration).xy(1, row += 2);
            this.checkSaveSwitchportConfiguration = new JCheckBox(Resources.getString(SaveNodeConfigurationDialog.class, (String)"checkSaveSwitchportConfiguration"), true);
            formBuilder.add((Component)this.checkSaveSwitchportConfiguration).xy(1, row += 2);
            row += 2;
            if (defaultImportCVOnly) {
                this.checkSaveLightportConfiguration.setSelected(false);
                this.checkSaveLightportConfiguration.setEnabled(false);
                this.checkSaveBacklightportConfiguration.setSelected(false);
                this.checkSaveBacklightportConfiguration.setEnabled(false);
                this.checkSaveServoportConfiguration.setSelected(false);
                this.checkSaveServoportConfiguration.setEnabled(false);
                this.checkSaveSwitchportConfiguration.setSelected(false);
                this.checkSaveSwitchportConfiguration.setEnabled(false);
            }
        }
        this.checkSaveFeatures = new JCheckBox(Resources.getString(SaveNodeConfigurationDialog.class, (String)"checkSaveFeatures"), true);
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        formBuilder.add((Component)this.checkSaveFeatures).xy(1, row);
        row += 2;
        if (!this.isParamEnabled(importParams, FEATURES_RESTORED)) {
            this.checkSaveFeatures.setSelected(false);
        }
        this.checkSaveConfigurationVariables = new JCheckBox(Resources.getString(SaveNodeConfigurationDialog.class, (String)"checkSaveConfigurationVariables"), true);
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        formBuilder.add((Component)this.checkSaveConfigurationVariables).xy(1, row);
        row += 2;
        if (!this.isParamEnabled(importParams, CV_VALUES_RESTORED)) {
            this.checkSaveConfigurationVariables.setSelected(false);
        }
        JLabel transferDescriptionLabel = new JLabel((StringUtils.isNotBlank((CharSequence)description) ? "<html>" + description + "</html>" : "<html>" + Resources.getString(SaveNodeConfigurationDialog.class, (String)"transfer-description")) + "</html>");
        transferDescriptionLabel.setBorder(new EmptyBorder(10, 5, 10, 5));
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        formBuilder.add((Component)transferDescriptionLabel).xy(1, row);
        row += 2;
        JButton yesButton = new JButton(Resources.getString(SaveNodeConfigurationDialog.class, (String)"ok"));
        yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveNodeConfigurationDialog.this.setVisible(false);
                SaveNodeConfigurationDialog.this.fireContinue(node);
            }
        });
        JButton noButton = new JButton(Resources.getString(SaveNodeConfigurationDialog.class, (String)"cancel"));
        noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveNodeConfigurationDialog.this.setVisible(false);
                SaveNodeConfigurationDialog.this.fireCancel(node);
            }
        });
        JPanel buttonBar = new ButtonBarBuilder().addButton(new JComponent[]{yesButton, noButton}).build();
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)buttonBar, "East");
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        formBuilder.add((Component)southPanel).xy(1, row);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)formBuilder.build(), "Center");
    }

    public void showDialog() {
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private boolean isParamEnabled(Map<String, Object> params, String key) {
        if (params != null && params.containsKey(key)) {
            try {
                Boolean value = (Boolean)params.get(key);
                return value;
            }
            catch (Exception ex) {
                LOGGER.warn("Get value for key failed: {}", (Object)key, (Object)ex);
            }
        }
        return false;
    }

    public void setSaveFeaturesEnabled(boolean enabled) {
        this.checkSaveFeatures.setEnabled(enabled);
        if (!enabled) {
            this.checkSaveFeatures.setSelected(false);
        }
    }

    public void setSaveCVsEnabled(boolean enabled) {
        this.checkSaveConfigurationVariables.setEnabled(enabled);
        if (!enabled) {
            this.checkSaveConfigurationVariables.setSelected(false);
        }
    }

    protected Boolean isSaveMacros() {
        if (this.checkSaveMacros != null) {
            return this.checkSaveMacros.isSelected();
        }
        return Boolean.FALSE;
    }

    protected Boolean isSaveAccessories() {
        if (this.checkSaveAccessories != null) {
            return this.checkSaveAccessories.isSelected();
        }
        return Boolean.FALSE;
    }

    protected Boolean isSaveBacklightPorts() {
        if (this.checkSaveBacklightportConfiguration != null) {
            return this.checkSaveBacklightportConfiguration.isSelected();
        }
        return Boolean.FALSE;
    }

    protected Boolean isSaveLightPorts() {
        if (this.checkSaveLightportConfiguration != null) {
            return this.checkSaveLightportConfiguration.isSelected();
        }
        return Boolean.FALSE;
    }

    protected Boolean isSaveServoPorts() {
        if (this.checkSaveServoportConfiguration != null) {
            return this.checkSaveServoportConfiguration.isSelected();
        }
        return Boolean.FALSE;
    }

    protected Boolean isSaveSwitchPorts() {
        if (this.checkSaveSwitchportConfiguration != null) {
            return this.checkSaveSwitchportConfiguration.isSelected();
        }
        return Boolean.FALSE;
    }

    protected Boolean isSaveFeatures() {
        if (this.checkSaveFeatures != null) {
            return this.checkSaveFeatures.isSelected();
        }
        return Boolean.FALSE;
    }

    protected Boolean isSaveConfigurationVariables() {
        if (this.checkSaveConfigurationVariables != null) {
            return this.checkSaveConfigurationVariables.isSelected();
        }
        return Boolean.FALSE;
    }

    protected abstract void fireContinue(NodeInterface var1);

    protected abstract void fireCancel(NodeInterface var1);
}

