/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.client.common.event.MenuEvent;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.ifnet.view.IFnetConfigurationDialog;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class BasicOperationsPanel
implements TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicOperationsPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "fill:pref:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private final MainModel mainModel;
    private final JPanel contentPanel;
    private final JButton btnFirmwareUpdate;
    private final JButton btnNodeDocumentation;
    private final JButton btnNodeConfigurator;
    private final JButton btnIFnetConfigurator;
    private ImageIcon firmwareUpdateIcon;
    private ImageIcon nodeConfiguratorIcon;
    private ImageIcon nodeDocumentationIcon;
    private ImageIcon iFnetConfiguratorIcon;
    private final ApplicationContext context;

    public BasicOperationsPanel(MainModel model, ApplicationContext context) {
        Object panel;
        this.mainModel = model;
        this.context = context;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel(){
                private static final long serialVersionUID = 1L;

                public String getName() {
                    return Resources.getString(BasicOperationsPanel.class, (String)"name");
                }
            };
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout()){
                private static final long serialVersionUID = 1L;

                @Override
                public String getName() {
                    return Resources.getString(BasicOperationsPanel.class, (String)"name");
                }
            };
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        DefaultComponentFactory componentFactory = DefaultComponentFactory.getInstance();
        this.firmwareUpdateIcon = ImageUtils.createImageIcon(BasicOperationsPanel.class, (String)"/icons/64x64/firmware-update.png");
        this.btnFirmwareUpdate = componentFactory.createButton((Action)new AbstractAction(Resources.getString((String)"org.bidib.wizard.client.common.mvc.firmware.view.FirmwareView", (String)"title"), this.firmwareUpdateIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicOperationsPanel.this.fireFirmwareUpdate();
            }

            @Override
            public boolean isEnabled() {
                return true;
            }
        });
        this.btnFirmwareUpdate.setIconTextGap(8);
        dialogBuilder.add((Component)this.btnFirmwareUpdate).xy(1, 1);
        this.nodeConfiguratorIcon = ImageUtils.createImageIcon(BasicOperationsPanel.class, (String)"/icons/64x64/nodescript-wizard.png");
        this.btnNodeConfigurator = componentFactory.createButton((Action)new AbstractAction(Resources.getString((String)"org.bidib.wizard.nodescript.client.view.wizard.NodeScriptWizard", (String)"title"), this.nodeConfiguratorIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicOperationsPanel.this.fireNodeScriptWizard();
            }

            @Override
            public boolean isEnabled() {
                return true;
            }
        });
        this.btnNodeConfigurator.setIconTextGap(8);
        dialogBuilder.add((Component)this.btnNodeConfigurator).xy(1, 3);
        this.nodeDocumentationIcon = ImageUtils.createImageIcon(BasicOperationsPanel.class, (String)"/icons/64x64/node-documentation.png");
        this.btnNodeDocumentation = componentFactory.createButton((Action)new AbstractAction(Resources.getString((String)"org.bidib.wizard.mvc.main.view.menu.NodeListMenu", (String)"documentation"), this.nodeDocumentationIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicOperationsPanel.this.fireNodeDocumentation();
            }

            @Override
            public boolean isEnabled() {
                return true;
            }
        });
        this.btnNodeDocumentation.setIconTextGap(8);
        dialogBuilder.add((Component)this.btnNodeDocumentation).xy(1, 5);
        this.iFnetConfiguratorIcon = ImageUtils.createImageIcon(BasicOperationsPanel.class, (String)"/icons/64x64/ifnet-configurator.png");
        this.btnIFnetConfigurator = componentFactory.createButton((Action)new AbstractAction(Resources.getString((String)"org.bidib.wizard.mvc.main.view.menu.NodeListMenu", (String)"ifnet-configurator"), this.iFnetConfiguratorIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicOperationsPanel.this.fireIFnetConfigurator();
            }

            @Override
            public boolean isEnabled() {
                return true;
            }
        });
        this.btnIFnetConfigurator.setIconTextGap(8);
        dialogBuilder.add((Component)this.btnIFnetConfigurator).xy(1, 7);
        this.contentPanel = dialogBuilder.build();
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    public void nodeChanged() {
        LOGGER.info("The selected node has changed.");
        this.updateComponentState();
    }

    private void updateComponentState() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            this.updateNodeInfo(node);
        }
    }

    private void updateNodeInfo(NodeInterface node) {
        if (node == null) {
            return;
        }
        LOGGER.info("Update the basic operations panel for node: {}", (Object)node);
        this.btnFirmwareUpdate.setEnabled(node.isUpdatable());
        if (NodeUtils.hasAccessoryFunctions((long)node.getUniqueId()) || NodeUtils.hasSwitchFunctions((long)node.getUniqueId())) {
            this.btnNodeConfigurator.setEnabled(true);
        } else {
            this.btnNodeConfigurator.setEnabled(false);
        }
        boolean isIFnet = ProductUtils.isIFnet((long)node.getUniqueId());
        this.btnIFnetConfigurator.setEnabled(isIFnet);
        this.btnIFnetConfigurator.setVisible(isIFnet);
    }

    private void fireFirmwareUpdate() {
        LOGGER.info("Trigger the firmware update.");
        NodeListActionListener nodeListActionListener = (NodeListActionListener)DefaultApplicationContext.getInstance().get("mainNodeListActionListener", NodeListActionListener.class);
        if (nodeListActionListener != null) {
            nodeListActionListener.firmwareUpdate(this.mainModel.getSelectedNode());
        } else {
            LOGGER.warn("No nodeListAction listener available.");
        }
    }

    private void fireNodeScriptWizard() {
        LOGGER.info("Trigger the node script wizard.");
        this.context.publishEvent((Object)new MenuEvent(MenuEvent.Action.nodeScriptWizard));
    }

    private void fireNodeDocumentation() {
        LOGGER.info("Trigger the node documentation.");
        NodeListActionListener nodeListActionListener = (NodeListActionListener)DefaultApplicationContext.getInstance().get("mainNodeListActionListener", NodeListActionListener.class);
        if (nodeListActionListener != null) {
            nodeListActionListener.generateDocumentation(this.mainModel.getSelectedNode());
        } else {
            LOGGER.warn("No nodeListAction listener available.");
        }
    }

    private void fireIFnetConfigurator() {
        LOGGER.info("Trigger the IFnet configuration.");
        NodeService nodeService = (NodeService)this.context.getBean(NodeService.class);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        IFnetConfigurationDialog dialog = new IFnetConfigurationDialog(JOptionPane.getFrameForComponent(this.contentPanel), Resources.getString(IFnetConfigurationDialog.class, (String)"title"), nodeService, selectedNode);
        dialog.showDialog();
    }
}

