/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.bidib.api.json.types.ConnectionPhase;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.bidib.wizard.common.model.settings.ConnectionConfiguration;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.model.settings.GlobalSettings;
import org.bidib.wizard.core.utils.AopUtils;
import org.bidib.wizard.mvc.main.model.ConnectionPhaseModel;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmptyPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, 20dlu:grow:fill";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 9dlu, pref";
    private JPanel content;
    private JLabel infoLabel;
    private JButton configureButton;
    private final SettingsService settingsService;
    private final MainMenuListener mainMenuListener;
    private final Font welcomeFont;

    public EmptyPanel(ConnectionPhaseModel connectionPhaseModel, final SettingsService settingsService, MainMenuListener mainMenuListener) {
        Object panel;
        LOGGER.debug("Create new EmptyPanel.");
        this.settingsService = settingsService;
        this.mainMenuListener = mainMenuListener;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.DIALOG);
        JLabel welcomeLabel = DefaultComponentFactory.getInstance().createLabel("<html><b>" + Resources.getString(this.getClass(), (String)"welcome") + "</b></html>");
        Font labelFont = welcomeLabel.getFont();
        this.welcomeFont = labelFont.deriveFont(1, (float)labelFont.getSize() * 2.0f);
        welcomeLabel.setFont(this.welcomeFont);
        welcomeLabel.setHorizontalAlignment(2);
        dialogBuilder.add((Component)welcomeLabel).xyw(1, 1, 5);
        this.configureButton = DefaultComponentFactory.getInstance().createButton((Action)new AbstractAction(Resources.getString((String)"org.bidib.wizard.mvc.main.view.menu.MainMenuBar", (String)"preferences")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EmptyPanel.this.firePreferences();
            }
        });
        this.infoLabel = DefaultComponentFactory.getInstance().createLabel("");
        this.infoLabel.setHorizontalAlignment(2);
        dialogBuilder.add((Component)this.infoLabel).xy(1, 3);
        dialogBuilder.add((Component)this.configureButton).xy(3, 3);
        this.content = dialogBuilder.build();
        this.updatePanelText(settingsService);
        if (this.configureButton != null) {
            try {
                GlobalSettings gs = (GlobalSettings)AopUtils.getTargetObject((Object)settingsService.getGlobalSettings());
                gs.addPropertyChangeListener("selectedPortType", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("selectedPortType".equals(evt.getPropertyName())) {
                            LOGGER.info("The selected port type has changed.");
                            EmptyPanel.this.updatePanelText(settingsService);
                        }
                    }
                });
            }
            catch (Exception ex) {
                LOGGER.warn("Register for changes of selected port type failed.", (Throwable)ex);
            }
        }
        connectionPhaseModel.addPropertyChangeListener("connectionPhase", evt -> {
            ConnectionPhase phase = connectionPhaseModel.getConnectionPhase();
            String connectionId = connectionPhaseModel.getConnectionId();
            switch (phase) {
                case CONNECTED: {
                    this.showMessageText(connectionId, true);
                    break;
                }
                case DISCONNECTED: {
                    this.showMessageText(connectionId, false);
                    break;
                }
            }
        });
    }

    public JPanel getContent() {
        return this.content;
    }

    private void updatePanelText(SettingsService settingsService) {
        PreferencesPortType preferencesPortType = ConnectionConfiguration.toPreferencesPortType((List)settingsService.getGlobalSettings().getConnectionConfigurations(), (String)"main");
        if (PreferencesPortType.isSimulation((PreferencesPortType)preferencesPortType)) {
            String color = String.format("#%06x", UIManager.getColor("EmptyPanel.warn").getRGB() & 0xFFFFFF);
            this.infoLabel.setText("<html><font color=" + color + ">" + Resources.getString(EmptyPanel.class, (String)"simulation-connection-configured") + "</font></html>");
            this.infoLabel.setForeground(Color.RED);
            this.configureButton.setVisible(true);
        } else if (preferencesPortType != null && PreferencesPortType.isValidConnectionConfiguration((PreferencesPortType)preferencesPortType)) {
            this.infoLabel.setText("<html><b>" + Resources.getString(EmptyPanel.class, (String)"connect-to-system") + "</b></html>");
            this.infoLabel.setForeground(UIManager.getColor("Text.foreground"));
            this.configureButton.setVisible(false);
        } else {
            this.infoLabel.setText("<html><b>" + Resources.getString(EmptyPanel.class, (String)"no-connection-to-system-configured") + "</b></html>");
            this.infoLabel.setForeground(Color.RED);
            this.configureButton.setVisible(true);
        }
    }

    private void setLabelText(String labelText) {
        LOGGER.info("Set the label text: {}", (Object)labelText);
        this.infoLabel.setText(labelText);
        this.infoLabel.setForeground(UIManager.getColor("Text.foreground"));
    }

    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    private void firePreferences() {
        this.mainMenuListener.preferences();
    }

    private void showMessageText(String connectionId, boolean connected) {
        LOGGER.info("Show message text for connection status, connected: {}", (Object)connected);
        if (connected) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EmptyPanel.this.setLabelText("<html><b>" + Resources.getString(EmptyPanel.class, (String)"selectNodeFromList") + "</b></html>");
                        EmptyPanel.this.configureButton.setVisible(false);
                    }
                });
            } else {
                this.setLabelText("<html><b>" + Resources.getString(EmptyPanel.class, (String)"selectNodeFromList") + "</b></html>");
                this.configureButton.setVisible(false);
            }
        } else if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EmptyPanel.this.updatePanelText(EmptyPanel.this.settingsService);
                }
            });
        } else {
            this.updatePanelText(this.settingsService);
        }
    }
}

