/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.common.base.Objects;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.SearchableUtils;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.LabelFactory;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.DetachedState;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.LabelAware;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.event.MainControllerEvent;
import org.bidib.wizard.client.common.nodetree.JideNodeTree;
import org.bidib.wizard.client.common.nodetree.JideNodeTreeTableModel;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.BusyFrame;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.menu.listener.NodeListMenuListener;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.dialog.NodeLabelView;
import org.bidib.wizard.mvc.common.exception.NodeSelectionChangeException;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.menu.NodeListMenu;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelAction;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelActionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelChangedListener;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.mvc.worklist.controller.WorkListItemProvider;
import org.bidib.wizard.mvc.worklist.model.WorkItemModel;
import org.bidib.wizard.nodescript.client.view.listener.NodeTreeScriptingListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class NodeListPanel
implements NodeListMenuListener,
Dockable,
NodeTreeScriptingListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeListPanel.class);
    private final List<NodeListActionListener> nodeListListeners = new LinkedList<NodeListActionListener>();
    private final List<LabelChangedListener<NodeInterface>> labelChangedListeners = new LinkedList<LabelChangedListener<NodeInterface>>();
    private final JideNodeTree nodeTree;
    private LabelAction<NodeInterface> labelAction;
    private final NodeListMenu nodeListMenu;
    private final JPopupMenu popupMenu;
    private JPanel contentPanel;
    private final MainModel mainModel;
    private final SettingsService settingsService;
    private final WizardLabelWrapper wizardLabelWrapper;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final WorkListItemProvider workListItemProvider;
    private final StatusBar statusBar;
    private static final String BIDIB_DEFAULT_NAMES_EXTENSION = "xml";
    private static final String WORKING_DIR_DEFAULT_LABELS_KEY = "defaultLabels";

    public NodeListPanel(final MainModel mainModel, SettingsService settingsService, final WizardLabelWrapper wizardLabelWrapper, ApplicationEventPublisher applicationEventPublisher, WorkListItemProvider workListItemProvider, StatusBar statusBar) {
        this.mainModel = mainModel;
        this.settingsService = settingsService;
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.applicationEventPublisher = applicationEventPublisher;
        this.workListItemProvider = workListItemProvider;
        this.statusBar = statusBar;
        JideNodeTreeTableModel jideNodeTreeTableModel = new JideNodeTreeTableModel();
        this.nodeTree = new JideNodeTree(jideNodeTreeTableModel, settingsService, wizardLabelWrapper);
        this.labelAction = new LabelAction<NodeInterface>(){

            @Override
            public void editLabel(final NodeInterface node, Point location, final LabelActionListener<NodeInterface> actionListener) {
                Frame frame = JOptionPane.getFrameForComponent(null);
                NodeLabels nodeLabels = wizardLabelWrapper.loadLabels(Long.valueOf(node.getUniqueId()));
                NodeLabelView view = new NodeLabelView(frame, node, nodeLabels){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void labelChanged(String value) {
                        LOGGER.info("The label of the node was changed to value: '{}'", (Object)value);
                        if (node instanceof LabelAware) {
                            ((LabelAware)node).setLabel(value);
                        }
                        actionListener.fireLabelChanged(node, value);
                    }
                };
                if (location.x > -1 && location.y > -1) {
                    view.setLocation(location.x + 20, location.y + 20);
                } else {
                    view.setLocationRelativeTo(null);
                }
                view.setVisible(true);
            }
        };
        LOGGER.info("Register the nodeTree in applicationContext.");
        DefaultApplicationContext.getInstance().register("nodeTree", (Object)this.nodeTree);
        this.nodeListMenu = new NodeListMenu(mainModel, settingsService, wizardLabelWrapper);
        this.popupMenu = this.nodeListMenu.getPopupMenu();
        DockKeys.DOCKKEY_NODE_LIST_PANEL.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_NODE_LIST_PANEL.setCloseEnabled(false);
        DockKeys.DOCKKEY_NODE_LIST_PANEL.setAutoHideEnabled(false);
        this.nodeTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                block3: {
                    NodeInterface node;
                    block5: {
                        block4: {
                            node = NodeListPanel.this.nodeTree.selectElement(e.getPoint());
                            LOGGER.info("Node was selected: {}", (Object)node);
                            if (node == null) break block3;
                            if (e.getClickCount() != 1 || !e.isPopupTrigger()) break block4;
                            NodeListPanel.this.nodeListMenu.setAddressMessagesEnabled(node.isAddressMessagesEnabled());
                            NodeListPanel.this.nodeListMenu.setDccStartEnabled(node.isDccStartEnabled());
                            NodeListPanel.this.nodeListMenu.setExternalStartEnabled(node.isExternalStartEnabled());
                            NodeListPanel.this.nodeListMenu.setFeedbackMessagesEnabled(node.isFeedbackMessagesEnabled());
                            NodeListPanel.this.nodeListMenu.setKeyMessagesEnabled(node.isKeyMessagesEnabled());
                            NodeListPanel.this.nodeListMenu.setClearErrorEnabled(node.isNodeHasError());
                            NodeListPanel.this.handleMouseEvent(e, NodeListPanel.this.popupMenu);
                            break block3;
                        }
                        if (e.getClickCount() != 1 || !e.isControlDown()) break block5;
                        e.consume();
                        node.setIdentifyState(node.getIdentifyState() == IdentifyState.ON ? IdentifyState.OFF : IdentifyState.ON);
                        LOGGER.info("Clicked on node label and control is pressed. Set the identify state: {}", (Object)node.getIdentifyState());
                        for (NodeListActionListener l : NodeListPanel.this.nodeListListeners) {
                            l.identify(node);
                        }
                        break block3;
                    }
                    if (e.getClickCount() != 2) break block3;
                    LOGGER.info("Select the node: {}", (Object)node);
                    e.consume();
                    try {
                        NodeListPanel.this.setSelectedNode(node);
                    }
                    catch (NodeSelectionChangeException ex) {
                        LOGGER.warn("The change of node selection was denied.", (Throwable)ex);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                LOGGER.debug("Mouse released.");
                if (e.isPopupTrigger()) {
                    this.mousePressed(e);
                }
            }
        });
        this.nodeTree.setItems(new NodeInterface[0]);
        mainModel.addNodeListListener((NodeListListener)new DefaultNodeListListener(){

            public void listChanged() {
                LOGGER.debug("List changed, use the AWT-thread to set the nodes in the label list.");
                if (SwingUtilities.isEventDispatchThread()) {
                    NodeListPanel.this.internalListChanged(mainModel);
                } else {
                    SwingUtilities.invokeLater(() -> NodeListPanel.this.internalListChanged(mainModel));
                }
            }

            public void nodeStateChanged(NodeInterface node) {
            }

            public void listNodeRemoved(NodeInterface node) {
                if (Objects.equals((Object)NodeListPanel.this.getSelectedItem(), (Object)node)) {
                    LOGGER.warn("The selected node is removed. Set the selected node to null.");
                    SwingUtils.executeInEDT(() -> NodeListPanel.this.setSelectedNode(null));
                }
            }
        });
        this.nodeListMenu.addMenuListener(this);
        SearchableUtils.installSearchable((JTable)this.nodeTree);
        AnnotationProcessor.process((Object)this);
    }

    private JPanel createPanel() {
        LOGGER.info("Create the content panel.");
        JPanel contentPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane((Component)this.nodeTree);
        contentPanel.add(scrollPane);
        return contentPanel;
    }

    public Component getComponent() {
        if (this.contentPanel == null) {
            this.contentPanel = this.createPanel();
        }
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_NODE_LIST_PANEL;
    }

    @EventSubscriber(eventClass=LabelsChangedEvent.class)
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
    }

    private void internalListChanged(MainModel model) {
        NodeInterface selectedValue = this.nodeTree.getSelectedItem();
        LOGGER.info("The list has changed, current selected value: {}", (Object)selectedValue);
        NodeInterface[] nodes = new NodeInterface[]{};
        if (model.getNodeProvider() != null) {
            nodes = model.getNodeProvider().getNodes().toArray(new NodeInterface[0]);
        }
        this.nodeTree.setItems(nodes);
        LOGGER.debug("The list has changed, set the new nodes has finished.");
    }

    public void addressMessagesEnabled(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setAddressMessagesEnabled(Boolean.valueOf(isSelected));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableAddressMessages(node);
            }
        }
    }

    public void displayNodeDetails() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            try {
                this.setSelectedNode(node);
            }
            catch (NodeSelectionChangeException ex) {
                LOGGER.warn("The change of node selection was denied.", (Throwable)ex);
            }
        }
    }

    public void editLabel(MouseEvent popupEvent) {
        NodeInterface selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            this.labelAction.editLabel(selectedItem, this.selectedIndexToLocation(), (object, label) -> this.fireLabelChanged((NodeInterface)object, label));
        }
    }

    protected void handleMouseEvent(MouseEvent e, JPopupMenu popupMenu) {
        if (e.isPopupTrigger() && this.nodeTree.getItemSize() > 0) {
            this.nodeTree.selectElement(e.getPoint());
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected Point selectedIndexToLocation() {
        int selectedIndex = this.nodeTree.getSelectedIndex();
        return this.selectedIndexToLocation(selectedIndex);
    }

    private Point selectedIndexToLocation(int selectedIndex) {
        Point result = new Point();
        if (selectedIndex >= 0) {
            Point listPosition = this.nodeTree.getLocationOnScreen();
            Point itemPosition = this.nodeTree.indexToLocation(selectedIndex);
            result.setLocation(listPosition.x + itemPosition.x, listPosition.y + itemPosition.y);
        }
        return result;
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.nodeTree.addListSelectionListener(l);
    }

    public void addNodeListListener(NodeListActionListener l) {
        this.addLabelChangedListener(l);
        this.nodeListListeners.add(l);
    }

    public void addLabelChangedListener(LabelChangedListener<NodeInterface> l) {
        this.labelChangedListeners.add(l);
    }

    public void dccStartEnabled(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setDccStartEnabled(Boolean.valueOf(isSelected));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableDccStart(node);
            }
        }
    }

    public void importNode() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.importNode(node);
            }
        }
    }

    public void exportNode() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.exportNode(node);
            }
        }
    }

    public void externalStartEnabled(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setExternalStartEnabled(Boolean.valueOf(isSelected));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableExternalStart(node);
            }
        }
    }

    public void feedbackMessagesEnabled(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setFeedbackMessagesEnabled(Boolean.valueOf(isSelected));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableFeedbackMessages(node);
            }
        }
    }

    public void feedbackMirrorDisabled(boolean disable) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setFeedbackMirrorDisabled(Boolean.valueOf(disable));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.disableFeedbackMirror(node, disable);
            }
        }
    }

    public void firmwareUpdate() {
        for (NodeListActionListener l : this.nodeListListeners) {
            l.firmwareUpdate(this.nodeTree.getSelectedItem());
        }
    }

    public void identify(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setIdentifyState(isSelected ? IdentifyState.ON : IdentifyState.OFF);
            for (NodeListActionListener l : this.nodeListListeners) {
                l.identify(node);
            }
        }
    }

    public void dccAdvView() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.dccAdvView(node);
            }
        }
    }

    public void keyMessagesEnabled(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setInputMessagesEnabled(Boolean.valueOf(isSelected));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableKeyMessages(node);
            }
        }
    }

    public void features() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Open the features dialog on node: {}", (Object)node);
        if (node != null) {
            Point itemPosition = this.selectedIndexToLocation();
            for (NodeListActionListener l : this.nodeListListeners) {
                l.features(node);
            }
        }
    }

    public void reset() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Open the reset dialog on node: {}", (Object)node);
        if (node != null) {
            Frame parent = JOptionPane.getFrameForComponent((Component)this.nodeTree);
            new ResetDialog(parent, node, true);
        }
    }

    public void reloadNode() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Open the reload dialog on node: {}", (Object)node);
        if (node != null) {
            Frame parent = JOptionPane.getFrameForComponent((Component)this.nodeTree);
            new ReloadNodeDialog(parent, node, true);
        }
    }

    public void ping() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.info("Send ping to node: {}", (Object)node);
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.ping(node, new byte[]{1});
            }
        }
    }

    public void enable() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.info("Send enable to node: {}", (Object)node);
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableNode(node);
            }
        }
    }

    public void disable() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.info("Send disable to node: {}", (Object)node);
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.disableNode(node);
            }
        }
    }

    public void readUniqueId() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.info("Read the uniqueId from the node: {}", (Object)node);
        long uniqueId = 0L;
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                uniqueId = l.readUniqueId(node);
            }
        }
        StringBuilder message = new StringBuilder(Resources.getString(this.getClass(), (String)"current-uniqueId"));
        message.append(ByteUtils.getUniqueIdAsString((long)uniqueId));
        Frame parent = JOptionPane.getFrameForComponent((Component)this.nodeTree);
        JOptionPane.showMessageDialog(parent, message);
    }

    public void detachAttachNode() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.info("Logoff from the node: {}", (Object)node);
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                boolean detached = node.getDetachedState() == DetachedState.DETACHED;
                LOGGER.info("Current detached state: {}", (Object)detached);
                l.detachAttachNode(node, !detached);
            }
        }
    }

    public void dmxModeler() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Open the dmxModeler on node: {}", (Object)node);
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.dmxModeler(node);
            }
        }
    }

    protected void fireLabelChanged(NodeInterface node, String label) {
        for (LabelChangedListener<NodeInterface> l : this.labelChangedListeners) {
            l.labelChanged(node, label);
        }
    }

    public void loco() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null && NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) {
            LOGGER.info("Open the loco dialog.");
            for (NodeListActionListener l : this.nodeListListeners) {
                l.loco(node);
            }
        }
    }

    public void locoList() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null && NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) {
            LOGGER.info("Open the loco table.");
            for (NodeListActionListener l : this.nodeListListeners) {
                l.locoList(node);
            }
        }
    }

    public void dccAccessory() {
        Point itemPosition = this.selectedIndexToLocation();
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.dccAccessory(node, itemPosition.x, itemPosition.y);
            }
        }
    }

    public void locoCv() {
        Point itemPosition = this.selectedIndexToLocation();
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.locoCv(node, itemPosition.x, itemPosition.y);
            }
        }
    }

    public void locoCvPt() {
        Point itemPosition = this.selectedIndexToLocation();
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.locoCvPt(node, itemPosition.x, itemPosition.y);
            }
        }
    }

    public void showDetails() {
        Point itemPosition = this.selectedIndexToLocation();
        for (NodeListActionListener l : this.nodeListListeners) {
            l.nodeDetails(this.nodeTree.getSelectedItem(), itemPosition.x, itemPosition.y);
        }
    }

    public void bulkSwitchNode() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Open the bulk switch node dialog on node: {}", (Object)node);
        if (node != null) {
            Point itemPosition = this.selectedIndexToLocation();
            for (NodeListActionListener l : this.nodeListListeners) {
                l.bulkSwitchDialog(node, itemPosition.x, itemPosition.y);
            }
        }
    }

    public void clearErrors() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Clear errors on node: {}", (Object)node);
        if (node != null) {
            node.setNodeHasError(false);
        }
    }

    public void savePendingChanges() {
        LOGGER.info("Save the pending changes.");
        this.applicationEventPublisher.publishEvent((Object)new MainControllerEvent(MainControllerEvent.Action.savePendingChanges));
    }

    public void setSelectedNode(NodeInterface node) {
        LOGGER.info("Set the selected node: {}", (Object)node);
        this.nodeTree.setSelectedItem(node);
    }

    public NodeInterface getSelectedItem() {
        return this.nodeTree.getSelectedItem();
    }

    public void generateDocumentation() {
        LOGGER.info("Generate documentation.");
        NodeInterface node = this.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.generateDocumentation(node);
            }
        }
    }

    public void generateDefaultLabels() {
        LOGGER.info("Generate default labels.");
        try {
            NodeInterface node = this.getSelectedItem();
            if (node != null) {
                long uniqueId = node.getUniqueId();
                final NodeLabels nodeLabels = this.wizardLabelWrapper.prepareDefaultLabels(Long.valueOf(uniqueId));
                if (nodeLabels != null) {
                    String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
                    String shortLang = StringUtils.substringBefore((String)lang, (String)"-");
                    StringBuilder sb = new StringBuilder("bidib-default-names-");
                    sb.append(NodeUtils.getVendorId((long)uniqueId)).append("-");
                    sb.append(NodeUtils.getPid((long)uniqueId, (int)node.getNode().getRelevantPidBits())).append("-").append(shortLang).append(".xml");
                    String defaultFileName = sb.toString();
                    LOGGER.info("Prepared default filename: {}", (Object)defaultFileName);
                    final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
                    String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_DEFAULT_LABELS_KEY);
                    String bidibNodeFilesDescription = Resources.getString(NodeListPanel.class, (String)"bidibDefaultLabelFilesDescription");
                    FileNameExtensionFilter bidibNodesFilter = new FileNameExtensionFilter(bidibNodeFilesDescription, BIDIB_DEFAULT_NAMES_EXTENSION);
                    FileDialog dialog = new FileDialog((Component)this.nodeTree, 1, storedWorkingDirectory, defaultFileName, new FileFilter[]{bidibNodesFilter}){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void approve(String selectedFile) {
                            File file = new File(selectedFile);
                            String fileName = file.getPath();
                            fileName = this.makeSureFileNameHasExtension(fileName, NodeListPanel.BIDIB_DEFAULT_NAMES_EXTENSION);
                            LOGGER.info("Save default labels to file: {}", (Object)fileName);
                            BusyFrame busyFrame = (BusyFrame)DefaultApplicationContext.getInstance().get("mainFrame", BusyFrame.class);
                            try {
                                busyFrame.setBusy(true);
                                LabelFactory labelFactory = new LabelFactory();
                                labelFactory.saveNodeLabel(nodeLabels, file, false);
                                NodeListPanel.this.statusBar.setStatusText(Resources.getString(NodeListPanel.class, (String)"generate-default-labels-passed", (Object[])new Object[]{fileName}), -1);
                                String workingDir = Paths.get(selectedFile, new String[0]).getParent().toString();
                                LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                                wizardSettings.setWorkingDirectory(NodeListPanel.WORKING_DIR_DEFAULT_LABELS_KEY, workingDir);
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Generate default labels failed.", (Throwable)ex);
                                TaskDialogs.build((Window)JOptionPane.getFrameForComponent((Component)NodeListPanel.this.nodeTree), (String)Resources.getString(NodeListPanel.class, (String)"generate-default-labels-failed.instruction"), (String)Resources.getString(NodeListPanel.class, (String)"generate-default-labels-failed")).title(Resources.getString(NodeListPanel.class, (String)"generate-default-labels.title")).exception((Throwable)ex);
                            }
                            finally {
                                busyFrame.setBusy(false);
                            }
                        }
                    };
                    dialog.showDialog();
                } else {
                    JOptionPane.showMessageDialog(this.getComponent(), "No labels available for selected node.", "Default Labels", 0);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Generate default labels failed.", (Throwable)ex);
        }
    }

    public void applyDefaultLabels() {
        WorkItemModel workItemModel;
        LOGGER.info("Apply the default labels of the node.");
        NodeInterface node = this.getSelectedItem();
        if (node != null && (workItemModel = this.workListItemProvider.getDefaultLabelsWorkItemModel(this.mainModel.getConnectionId(), node)) != null) {
            this.workListItemProvider.applyAction(workItemModel);
        }
    }

    public void performShutdown() {
    }

    public void deleteNodeLabels() {
        LOGGER.info("Delete the node labels.");
        NodeInterface node = this.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.deleteNodeLabels(node);
            }
            LabelsChangedEvent labelsChangedEvent = new LabelsChangedEvent(node.getUniqueId());
            LOGGER.info("Publish the labelsChangedEvent: {}", (Object)labelsChangedEvent);
            EventBus.publish((Object)labelsChangedEvent);
            this.applicationEventPublisher.publishEvent((Object)labelsChangedEvent);
        }
    }

    private final class ResetDialog
    extends EscapeDialog {
        private static final long serialVersionUID = 1L;

        public ResetDialog(Frame parent, final NodeInterface node, boolean modal) {
            super(parent, Resources.getString(ResetDialog.class, (String)"title"), modal);
            this.getContentPane().setLayout(new BorderLayout());
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)new JLabel(Resources.getString(((Object)((Object)this)).getClass(), (String)"message"), UIManager.getIcon("OptionPane.warningIcon"), 10), "Center");
            mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JButton reset = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"reset"));
            reset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResetDialog.this.setVisible(false);
                    ResetDialog.this.fireReset(node);
                }
            });
            JButton cancel = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"cancel"));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResetDialog.this.setVisible(false);
                    ResetDialog.this.fireCancel();
                }
            });
            JPanel buttons = ((ButtonBarBuilder)new ButtonBarBuilder().addGlue().addButton(new JComponent[]{reset, cancel}).border((Border)Paddings.BUTTON_BAR_PAD)).build();
            mainPanel.add((Component)buttons, "South");
            this.getContentPane().add(mainPanel);
            this.pack();
            this.setLocationRelativeTo(parent);
            this.setMinimumSize(this.getSize());
            this.setVisible(true);
        }

        private void fireReset(NodeInterface node) {
            LOGGER.info("Reset the current node: {}", (Object)node);
            for (NodeListActionListener l : NodeListPanel.this.nodeListListeners) {
                l.reset(node);
            }
        }

        private void fireCancel() {
        }
    }

    private final class ReloadNodeDialog
    extends EscapeDialog {
        private static final long serialVersionUID = 1L;

        public ReloadNodeDialog(Frame parent, final NodeInterface node, boolean modal) {
            super(parent, Resources.getString(ReloadNodeDialog.class, (String)"title"), modal);
            this.getContentPane().setLayout(new BorderLayout());
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)new JLabel(Resources.getString(ReloadNodeDialog.class, (String)"message"), UIManager.getIcon("OptionPane.warningIcon"), 10), "Center");
            mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JButton reloadNode = new JButton(Resources.getString(ReloadNodeDialog.class, (String)"reload"));
            reloadNode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReloadNodeDialog.this.setVisible(false);
                    ReloadNodeDialog.this.fireReload(node);
                }
            });
            JButton cancel = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"cancel"));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReloadNodeDialog.this.setVisible(false);
                    ReloadNodeDialog.this.fireCancel();
                }
            });
            JPanel buttons = ((ButtonBarBuilder)new ButtonBarBuilder().addGlue().addButton(new JComponent[]{reloadNode, cancel}).border((Border)Paddings.BUTTON_BAR_PAD)).build();
            mainPanel.add((Component)buttons, "South");
            this.getContentPane().add(mainPanel);
            this.pack();
            this.setLocationRelativeTo(parent);
            this.setMinimumSize(this.getSize());
            this.setVisible(true);
        }

        private void fireReload(NodeInterface node) {
            LOGGER.info("Reload the current node: {}", (Object)node);
            for (NodeListActionListener l : NodeListPanel.this.nodeListListeners) {
                l.reloadNode(node);
            }
        }

        private void fireCancel() {
        }
    }
}

