/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.statusbar;

import com.jidesoft.status.MemoryStatusBarItem;
import com.jidesoft.status.ProgressStatusBarItem;
import com.jidesoft.status.ResizeStatusBarItem;
import com.jidesoft.status.StatusBarItem;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.utils.PortingUtils;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.bidib.wizard.api.model.event.StatusBarEvent;
import org.bidib.wizard.api.model.listener.DefaultStatusListener;
import org.bidib.wizard.api.model.listener.StatusListener;
import org.bidib.wizard.api.notification.ConnectionAction;
import org.bidib.wizard.api.notification.TimeEvent;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.model.settings.ConnectionConfiguration;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.NetBidibSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.model.ports.event.LineStatusEvent;
import org.bidib.wizard.model.ports.event.StatusEvent;
import org.bidib.wizard.mvc.main.model.StatusModel;
import org.bidib.wizard.mvc.main.view.panel.listener.AbstractStatusListener;
import org.bidib.wizard.mvc.main.view.statusbar.ConnectionProviderStatusBarItem;
import org.bidib.wizard.mvc.main.view.statusbar.ConnectionStatusBarItem;
import org.bidib.wizard.mvc.main.view.statusbar.DigitalClockStatusBarItem;
import org.bidib.wizard.mvc.main.view.statusbar.StatusButtonStatusBarItem;
import org.bidib.wizard.mvc.main.view.statusbar.WizardStatusBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

public class DefaultJideStatusBar
implements StatusBar {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJideStatusBar.class);
    private JLabel statusLabel;
    private DigitalClockStatusBarItem modelClock;
    private DefaultOverlayable overlayLedPanel;
    private ConnectionStatusBarItem ledPanel;
    private StatusButtonStatusBarItem statusButtonPanel;
    private Timer cleanTimer;
    private ConnectionProviderStatusBarItem connectionProviderLabel;
    private WizardStatusBar statusBar;
    private ProgressStatusBarItem progress;
    private final StatusModel statusModel;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private ApplicationContext applicationContext;
    private CompositeDisposable compDisposable = new CompositeDisposable();

    public DefaultJideStatusBar(StatusModel statusModel) {
        this.statusModel = statusModel;
    }

    public void initialize() {
        this.statusBar = new WizardStatusBar();
        this.progress = new ProgressStatusBarItem(){
            private static final long serialVersionUID = 1L;

            protected JLabel createProgressLabel() {
                JLabel progressLabel;
                DefaultJideStatusBar.this.statusLabel = progressLabel = super.createProgressLabel();
                return progressLabel;
            }
        };
        this.progress.setCancelCallback(new ProgressStatusBarItem.CancelCallback(){

            public void cancelPerformed() {
                DefaultJideStatusBar.this.progress.setStatus(Resources.getString(StatusBar.class, (String)"cancelled"));
                DefaultJideStatusBar.this.progress.showStatus();
            }
        });
        this.statusBar.add((Component)this.progress, "vary");
        Map statusBarItems = this.applicationContext.getBeansOfType(StatusBarItem.class);
        for (StatusBarItem statusBarItem : statusBarItems.values()) {
            LOGGER.info("Add statusBarItem: {}", (Object)statusBarItem);
            this.statusBar.add((Component)statusBarItem, "flexible");
        }
        Color color = UIManager.getColor("StatusBarSimulationLabel.textcolor");
        JLabel simulationLabel = new JLabel("Simulation", 0);
        Font oldFont = simulationLabel.getFont();
        simulationLabel.setFont(oldFont.deriveFont(1, oldFont.getSize2D() + 2.0f));
        simulationLabel.setForeground(color);
        PortingUtils.removeFocus((JComponent)simulationLabel);
        this.ledPanel = new ConnectionStatusBarItem(this.statusModel);
        this.ledPanel.setPreferredWidth(170);
        this.overlayLedPanel = new DefaultOverlayable((JComponent)((Object)this.ledPanel), (JComponent)simulationLabel);
        this.statusBar.add((Component)this.overlayLedPanel, "flexible");
        this.connectionProviderLabel = new ConnectionProviderStatusBarItem();
        this.connectionProviderLabel.setPreferredWidth(80);
        this.statusBar.add((Component)((Object)this.connectionProviderLabel), "flexible");
        this.statusButtonPanel = new StatusButtonStatusBarItem(this.statusModel);
        this.statusButtonPanel.setPreferredWidth(40);
        this.statusBar.add((Component)((Object)this.statusButtonPanel), "fix");
        this.updateSelectedPort(this.connectionProviderLabel);
        this.setTimeStatusButtonEnabled();
        LOGGER.info("Create the digital clock.");
        this.modelClock = new DigitalClockStatusBarItem(this.settingsService);
        this.modelClock.setPreferredWidth(100);
        this.statusBar.add((Component)((Object)this.modelClock), "flexible");
        this.modelClock.setToolTipText(Resources.getString(StatusBar.class, (String)"modeltime"));
        MemoryStatusBarItem memoryItem = new MemoryStatusBarItem();
        this.statusBar.add((Component)memoryItem, "flexible");
        this.statusBar.add((Component)new ResizeStatusBarItem(), "fix");
        this.modelClock.setEnabled(this.settingsService.getGlobalSettings().isModelTimeEnabled());
        this.statusModel.setRunning(this.settingsService.getGlobalSettings().isModelTimeEnabled());
        this.statusModel.addModelClockStatusListener(this.modelClock);
        this.statusModel.addStatusListener((StatusListener)new DefaultStatusListener(){

            public void runningChanged(boolean running) {
                if (running) {
                    DefaultJideStatusBar.this.modelClock.start();
                } else {
                    DefaultJideStatusBar.this.modelClock.stop();
                }
            }
        });
        this.statusButtonPanel.addStatusListener(new AbstractStatusListener(){

            @Override
            public void switchedOff() {
                DefaultJideStatusBar.this.settingsService.getGlobalSettings().setModelTimeEnabled(false);
                DefaultJideStatusBar.this.statusModel.setModelClockStartEnabled(false);
                DefaultJideStatusBar.this.statusModel.setRunning(false);
            }

            @Override
            public void switchedOn() {
                DefaultJideStatusBar.this.settingsService.getGlobalSettings().setModelTimeEnabled(true);
                DefaultJideStatusBar.this.statusModel.setModelClockStartEnabled(true);
                DefaultJideStatusBar.this.statusModel.setRunning(true);
            }
        });
        try {
            GlobalSettingsInterface gs = this.settingsService.getGlobalSettings();
            gs.addPropertyChangeListener("selectedPortType", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LOGGER.info("The selected port type has changed, update the selected port label.");
                    DefaultJideStatusBar.this.updateSelectedPort(DefaultJideStatusBar.this.connectionProviderLabel);
                }
            });
            gs.addPropertyChangeListener("modelTimeEnabled", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean isModelTimeEnabled = DefaultJideStatusBar.this.settingsService.getGlobalSettings().isModelTimeEnabled();
                    DefaultJideStatusBar.this.statusModel.setRunning(isModelTimeEnabled);
                    DefaultJideStatusBar.this.modelClock.setEnabled(isModelTimeEnabled);
                }
            });
            MiscSettingsInterface ms = this.settingsService.getMiscSettings();
            ms.addPropertyChangeListener("selectedSerialPortProvider", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DefaultJideStatusBar.this.updateSelectedPort(DefaultJideStatusBar.this.connectionProviderLabel);
                }
            });
            NetBidibSettingsInterface nbs = this.settingsService.getNetBidibSettings();
            nbs.addPropertyChangeListener("discoveryEnabled", evt -> {
                boolean discoveryEnabled = nbs.isDiscoveryEnabled();
                LOGGER.info("Discovery enabled flag has changed: {}", (Object)discoveryEnabled);
                this.connectionProviderLabel.setDiscoveryEnabled(discoveryEnabled);
            });
            this.connectionProviderLabel.setDiscoveryEnabled(nbs.isDiscoveryEnabled());
        }
        catch (Exception ex) {
            LOGGER.warn("Add property change listeners failed.", (Throwable)ex);
        }
        this.updateSelectedPort(this.connectionProviderLabel);
        Disposable dispTimeEvents = this.connectionService.subscribeTimeEvents(te -> {
            LOGGER.debug("Received a time event: {}", te);
            if ("main".equals(te.getConnectionId())) {
                this.setModelTime((TimeEvent)te);
            }
        }, error -> LOGGER.warn("The time event signalled a failure: {}", error));
        this.compDisposable.add(dispTimeEvents);
        Disposable dispStatusEvents = this.connectionService.subscribeStatusEvents(se -> {
            LOGGER.debug("Received a connection status event: {}", se);
            if ("main".equals(se.getConnectionId())) {
                this.setConnectionStatus((StatusEvent)se);
            }
        }, error -> LOGGER.warn("The status event signalled a failure: {}", error));
        this.compDisposable.add(dispStatusEvents);
        Disposable dispConnectionActions = this.connectionService.subscribeConnectionActions(ca -> {
            if ("main".equals(ca.getConnectionId())) {
                this.processConnectionAction((ConnectionAction)ca);
            }
        }, error -> LOGGER.warn("The connection actions signalled a failure: {}", error));
        this.compDisposable.add(dispConnectionActions);
        this.statusModel.addPropertyChangeListener("running", evt -> {
            boolean isRunning = this.statusModel.isRunning();
            LOGGER.info("The running property has changed, isRunning: {}", (Object)isRunning);
            boolean isConnected = this.statusModel.isCd();
            boolean isModelTimeEnabled = this.settingsService.getGlobalSettings().isModelTimeEnabled();
            if (isConnected && isModelTimeEnabled) {
                boolean running = this.statusModel.isRunning();
                LOGGER.info("Send the model clock, running: {}", (Object)running);
                this.connectionService.setModelTimeEnabled("main", running);
            } else {
                this.connectionService.setModelTimeEnabled("main", false);
            }
        });
    }

    private void setTimeStatusButtonEnabled() {
        PreferencesPortType selectedPortType = ConnectionConfiguration.toPreferencesPortType((List)this.settingsService.getGlobalSettings().getConnectionConfigurations(), (String)"main");
        boolean isTunneled = PreferencesPortType.checkSelectedPortTypeIsTunnel((PreferencesPortType)selectedPortType);
        this.statusButtonPanel.setEnabled(!isTunneled);
    }

    private void updateSelectedPort(ConnectionProviderStatusBarItem connectionProviderLabel) {
        this.updateSelectedPort(connectionProviderLabel, null);
    }

    private void updateSelectedPort(ConnectionProviderStatusBarItem connectionProviderLabel, Integer baudrate) {
        try {
            boolean simulationMode;
            String connectionName;
            PreferencesPortType selectedPortType = ConnectionConfiguration.toPreferencesPortType((List)this.settingsService.getGlobalSettings().getConnectionConfigurations(), (String)"main");
            LOGGER.info("The selectedPortType to use: {}, baudrate: {}", (Object)selectedPortType, (Object)baudrate);
            String connectionProvider = this.evaluateConnectionProviderLabel(selectedPortType);
            connectionProviderLabel.setText(connectionProvider);
            String string = connectionName = selectedPortType != null ? selectedPortType.getConnectionName() : null;
            if (StringUtils.isNotBlank((CharSequence)connectionProvider)) {
                if (baudrate != null) {
                    connectionProviderLabel.setToolTipText(connectionProvider + " - " + connectionName + " - baud: " + String.valueOf(baudrate == 1000000 ? "1M" : baudrate));
                } else {
                    connectionProviderLabel.setToolTipText(connectionProvider + " - " + connectionName);
                }
            }
            this.ledPanel.setEnabled(!(simulationMode = PreferencesPortType.isSimulation((PreferencesPortType)selectedPortType)));
            this.overlayLedPanel.setOverlayVisible(simulationMode);
            boolean isTunneled = PreferencesPortType.checkSelectedPortTypeIsTunnel((PreferencesPortType)selectedPortType);
            this.statusButtonPanel.setEnabled(!isTunneled);
        }
        catch (Exception ex) {
            LOGGER.warn("Change display connection provider failed.", (Throwable)ex);
        }
    }

    public JComponent getComponent() {
        if (this.statusBar == null) {
            this.initialize();
        }
        return this.statusBar;
    }

    private void setConnectionStatus(StatusEvent se) {
        if (se instanceof LineStatusEvent) {
            LineStatusEvent lse = (LineStatusEvent)se;
            this.statusModel.setCts(lse.isCTS());
        }
    }

    public void setStatusText(String message) {
        LOGGER.debug("Set status message: {}", (Object)message);
        this.setStatusText(message, -1);
    }

    private void processConnectionAction(ConnectionAction ca) {
        String messageKey;
        LOGGER.info("Process the connection action, connectionId: {}, messageKey: {}, context: {}", new Object[]{ca.getConnectionId(), ca.getMessageKey(), ca.getContext()});
        switch (messageKey = ca.getMessageKey()) {
            case "bidib-connect-with-baudrate": {
                Integer baudrate = (Integer)ca.getContext().get("baudrate", Integer.class, null);
                SwingUtilities.invokeLater(() -> {
                    String statusText = Resources.getString(StatusBar.class, (String)messageKey, (Object[])new Object[]{baudrate});
                    this.setStatusText(statusText, -1);
                    this.updateSelectedPort(this.connectionProviderLabel, baudrate);
                });
                break;
            }
            case "bidib-reconnect-with-next-baudrate": {
                Integer nextBaudrate = (Integer)ca.getContext().get("baudrate", Integer.class, null);
                SwingUtilities.invokeLater(() -> {
                    String statusText = Resources.getString(StatusBar.class, (String)messageKey, (Object[])new Object[]{nextBaudrate});
                    this.setStatusText(statusText, -1);
                });
                break;
            }
        }
    }

    public synchronized void setStatusText(String message, int seconds) {
        LOGGER.info("Set the status text: {}, seconds: {}", (Object)message, (Object)seconds);
        if (this.cleanTimer != null) {
            LOGGER.info("Stop the clean timer.");
            this.cleanTimer.stop();
            this.cleanTimer = null;
        }
        SwingUtils.executeInEDT(() -> this.updateStatusText(message, seconds));
    }

    private void updateStatusText(String message, int seconds) {
        switch (seconds) {
            case -2: {
                this.statusLabel.setForeground(Color.RED);
                break;
            }
            case -1: {
                this.statusLabel.setForeground(Color.BLACK);
                break;
            }
            default: {
                this.statusLabel.setForeground(Color.RED);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            this.progress.setStatus(message);
        } else {
            this.progress.setStatus(null);
        }
        if (seconds > 0) {
            this.cleanTimer = new Timer(seconds * 1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.info("Reset the statusbar.");
                    DefaultJideStatusBar.this.statusLabel.setForeground(Color.BLACK);
                    DefaultJideStatusBar.this.progress.setStatus(null);
                }
            });
            this.cleanTimer.setRepeats(false);
            this.cleanTimer.start();
        }
    }

    public void setModelTime(TimeEvent timeEvent) {
        this.modelClock.setModelTime(timeEvent);
    }

    private String evaluateConnectionProviderLabel(PreferencesPortType selectedPortType) {
        String serialProviderLabel = null;
        if (selectedPortType != null && selectedPortType.getConnectionPortType() != null) {
            switch (selectedPortType.getConnectionPortType()) {
                case SerialOverTcp: {
                    serialProviderLabel = "SerOverTcp";
                    break;
                }
                case SerialPort: 
                case SerialSymLink: {
                    serialProviderLabel = this.settingsService.getMiscSettings().getSelectedSerialPortProvider();
                    break;
                }
                case NetBidibClient: {
                    serialProviderLabel = "NetBidib";
                    break;
                }
                case Speedometer: {
                    serialProviderLabel = "Speedometer";
                    break;
                }
                default: {
                    serialProviderLabel = "Sim";
                }
            }
        }
        return serialProviderLabel;
    }

    public void setProgress(String message, boolean finished) {
        SwingUtils.executeInEDT(() -> {
            this.progress.setProgressStatus(message);
            if (!finished) {
                this.progress.setProgressStatus(message);
                this.progress.setProgress(10);
            } else {
                this.progress.setDefaultStatus(message);
                this.progress.setProgress(100);
                this.progress.showStatus();
            }
        });
    }

    public void addStatusBarItem(StatusBarItem statusBarItem, Object constraints, int index) {
        this.statusBar.add((Component)statusBarItem, constraints, index);
    }

    public void removeStatusBarItem(StatusBarItem statusBarItem) {
        this.statusBar.remove(statusBarItem.getName());
    }

    @EventListener(value={StatusBarEvent.class})
    public void handleStatusBarEvent(StatusBarEvent statusBarEvent) {
        LOGGER.info("New StatusBarEvent received: {}", (Object)statusBarEvent);
        this.setStatusText(Resources.getString(StatusBar.class, (String)statusBarEvent.getStatusMessageKey()), statusBarEvent.getDisplaySeconds());
    }
}

