/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jidesoft.grid.TableColumnChooser;
import io.reactivex.rxjava3.subjects.Subject;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.renderer.BidibStatusTableRenderer;
import org.bidib.wizard.client.common.view.renderer.PortConfigErrorAwareRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.mvc.main.model.MotorPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.MotorPortListPanel;
import org.bidib.wizard.mvc.main.view.table.MotorPortEditorPanel;
import org.bidib.wizard.mvc.main.view.table.PortComboBoxWithButtonEditorRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotorPortTable
extends AbstractPortHierarchicalTable<MotorPort> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MotorPortTable.class);
    private final MotorPortTableModel motorPortTableModel;

    public MotorPortTable(MotorPortTableModel motorPortTableModel, String emptyTableText) {
        super((SimpleHierarchicalPortTableModel)motorPortTableModel, emptyTableText);
        this.motorPortTableModel = motorPortTableModel;
    }

    public String getToolTipText(MouseEvent e) {
        MotorPort port;
        String tip = null;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        if (rowIndex == -1 || colIndex == -1) {
            return tip;
        }
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        tip = realColumnIndex == 1 ? ((port = (MotorPort)this.getModel().getValueAt(rowIndex, 4)).isEnabled() ? this.prepareTooltip(port, port.getValue()) : super.getToolTipText()) : super.getToolTipText();
        return tip;
    }

    private String prepareTooltip(MotorPort port, int value) {
        LOGGER.trace("Set the new value: {}", (Object)value);
        StringBuilder tip = new StringBuilder(Resources.getString(MotorPortListPanel.class, (String)"absolutevalue"));
        tip.append(value);
        return tip.toString();
    }

    public void clearTable() {
        LOGGER.debug("clearTable, remove all rows and remove all slider editors");
    }

    protected MotorPortEditorPanel createPortEditorPanel(MotorPort port, int row, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        MotorPortEditorPanel editorPanel = new MotorPortEditorPanel(port, motorPort -> this.motorPortTableModel.updatePortConfig((MotorPort)motorPort), motorPort -> this.motorPortTableModel.fireTestButtonPressed((MotorPort)motorPort), motorPort -> this.motorPortTableModel.refreshRow((MotorPort)motorPort, changedRow -> this.repaint(this.getCellRect(changedRow, 0, true))), portConfigChangeEventSubject, nodeSelectionProvider);
        editorPanel.createComponent();
        return editorPanel;
    }

    public void prepareTableColumns() {
        TableColumn tc = this.getColumnModel().getColumn(0);
        tc.setCellRenderer((TableCellRenderer)new PortConfigErrorAwareRenderer(0));
        tc.setIdentifier(0);
        tc = this.getColumnModel().getColumn(2);
        tc.setIdentifier(2);
        tc.setCellRenderer((TableCellRenderer)new BidibStatusTableRenderer(MotorPortStatus.class, "status.", 4){
            private static final long serialVersionUID = 1L;

            protected boolean isPortEnabled(ConfigurablePort<?> port) {
                return !(port instanceof Port) || Port.getConfiguredPortType((Port)((Port)port)) == LcOutputType.MOTORPORT;
            }
        });
        tc.setMinWidth(100);
        tc.setMaxWidth(120);
        TableColumn buttonColumn = this.getColumnModel().getColumn(3);
        buttonColumn.setIdentifier(3);
        buttonColumn.setMinWidth(180);
        buttonColumn.setMaxWidth(200);
        PortComboBoxWithButtonEditorRenderer<BidibStatus> editor = new PortComboBoxWithButtonEditorRenderer<BidibStatus>(this.getActions((BidibStatus)MotorPortStatus.FORWARD), ">", MotorPortStatus.class, Integer.valueOf(4)){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isPortEnabled(ConfigurablePort<?> port) {
                return !(port instanceof Port) || Port.getConfiguredPortType((Port)((Port)port)) == LcOutputType.MOTORPORT;
            }
        };
        buttonColumn.setCellEditor(editor);
        buttonColumn.setCellRenderer((TableCellRenderer)((Object)editor));
        TableColumnChooser.hideColumn((JTable)((Object)this), (int)4);
    }
}

