/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.enums.PtOperation;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.mvc.pt.model.PtMode;
import org.bidib.wizard.mvc.pt.model.PtProgrammerModel;
import org.bidib.wizard.mvc.pt.view.command.PtDirectAccessCommand;
import org.bidib.wizard.mvc.pt.view.command.PtOperationCommand;
import org.bidib.wizard.mvc.pt.view.panel.AbstractPtPanel;
import org.bidib.wizard.mvc.pt.view.panel.CvWritePanel;
import org.bidib.wizard.mvc.pt.view.panel.DirectAccessProgBeanModel;
import org.bidib.wizard.mvc.pt.view.panel.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pt.view.panel.PtValidationResultModel;

public class DirectAccessPanel
extends AbstractPtPanel<DirectAccessProgBeanModel> {
    private final DirectAccessProgBeanModel directAccessProgBeanModel = new DirectAccessProgBeanModel();
    private ValueModel cvNumberValueModel;
    private ValueModel cvValueValueModel;
    private JTextField cvNumber;
    private JTextField cvValue;
    private InputValidationDocument cvValueDocument;
    private ValidationResultModel cvValidationModel;
    private CvWritePanel cvWritePanel;
    private JComponent[] modeButtons;

    public DirectAccessPanel(PtProgrammerModel cvProgrammerModel) {
        super(cvProgrammerModel);
        this.setProgCommandAwareBeanModel(this.directAccessProgBeanModel);
    }

    @Override
    protected void createWorkerPanel(FormBuilder builder, int[] rowHolder) {
        int row = rowHolder[0];
        builder.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"direct-message"))).xyw(1, row, 7);
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"mode"), new Object[0]).xy(1, row += 2);
        PropertyAdapter modeModel = new PropertyAdapter((Object)this.directAccessProgBeanModel, "mode", true);
        this.modeButtons = new JComponent[PtMode.values().length];
        int index = 0;
        int column = 3;
        for (PtMode mode : PtMode.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)modeModel, (Object)((Object)mode), (String)Resources.getString(PtMode.class, (String)mode.getKey()));
            this.modeButtons[index++] = radio;
            builder.add((Component)radio).xy(column, row);
            column += 2;
        }
        modeModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DirectAccessPanel.this.LOGGER.debug("The mode has changed: {}", evt.getNewValue());
                DirectAccessPanel.this.directAccessProgBeanModel.setCvValue(null);
            }
        });
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"cv-number"), new Object[0]).xy(1, row += 2);
        this.cvNumberValueModel = new PropertyAdapter((Object)this.directAccessProgBeanModel, "cvNumber", true);
        ConverterValueModel cvNumberConverterModel = new ConverterValueModel(this.cvNumberValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.cvNumber = new JTextField();
        this.cvNumber.setDocument((Document)new InputValidationDocument(4, "0123456789"));
        this.cvNumber.setColumns(4);
        Bindings.bind((JTextField)this.cvNumber, (ValueModel)cvNumberConverterModel, (boolean)false);
        builder.add((Component)this.cvNumber).xy(3, row);
        ValidationComponentUtils.setMandatory((JComponent)this.cvNumber, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)this.cvNumber, (Object)"validation.cvnumber_key");
        this.cvValidationModel = new PtValidationResultModel();
        this.directAccessProgBeanModel.addPropertyChangeListener("cvNumber", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DirectAccessPanel.this.LOGGER.debug("CV number has changed: {}", (Object)DirectAccessPanel.this.directAccessProgBeanModel.getCvNumber());
                DirectAccessPanel.this.triggerValidation();
            }
        });
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"cv-value"), new Object[0]).xy(1, row += 2);
        this.cvValueValueModel = new PropertyAdapter((Object)this.directAccessProgBeanModel, "cvValue", true);
        ConverterValueModel cvValueConverterModel = new ConverterValueModel(this.cvValueValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.cvValue = new JTextField();
        this.cvValueDocument = new InputValidationDocument(3, "0123456789");
        this.cvValue.setDocument((Document)this.cvValueDocument);
        this.cvValue.setColumns(3);
        Bindings.bind((JTextField)this.cvValue, (ValueModel)cvValueConverterModel, (boolean)false);
        builder.add((Component)this.cvValue).xy(3, row);
        ValidationComponentUtils.setMessageKey((JComponent)this.cvValue, (Object)"validation.cvvalue_key");
        this.directAccessProgBeanModel.addPropertyChangeListener("mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DirectAccessPanel.this.LOGGER.debug("Operation has changed: {}", (Object)DirectAccessPanel.this.directAccessProgBeanModel.getMode());
                switch (DirectAccessPanel.this.directAccessProgBeanModel.getMode()) {
                    case BIT: {
                        DirectAccessPanel.this.cvValueDocument.setLimit(1);
                        DirectAccessPanel.this.cvValueDocument.setAcceptedChars("01");
                        DirectAccessPanel.this.readButton.setText(Resources.getString(DirectAccessPanel.class, (String)"verify"));
                        break;
                    }
                    default: {
                        DirectAccessPanel.this.cvValueDocument.setLimit(3);
                        DirectAccessPanel.this.cvValueDocument.setAcceptedChars("0123456789");
                        DirectAccessPanel.this.readButton.setText(Resources.getString(AbstractPtPanel.class, (String)"read"));
                    }
                }
            }
        });
        this.directAccessProgBeanModel.addPropertyChangeListener("cvValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DirectAccessPanel.this.LOGGER.debug("CV value has changed: {}", (Object)DirectAccessPanel.this.directAccessProgBeanModel.getCvValue());
                DirectAccessPanel.this.triggerValidation();
            }
        });
        this.cvWritePanel = new CvWritePanel(this.cvProgrammerModel, this.directAccessProgBeanModel);
        builder.add((Component)this.cvWritePanel.createPanel()).xyw(5, row, 3);
        row += 2;
        builder.appendRows("p, 3dlu", new Object[0]);
        this.cvNumberValueModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DirectAccessPanel.this.triggerValidation();
            }
        });
        this.readButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectAccessPanel.this.fireRead();
            }
        });
        this.writeButtonEnabled = new ValueHolder(false);
        this.cvValueValueModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DirectAccessPanel.this.LOGGER.info("The CV value has changed: {}", evt.getNewValue());
                DirectAccessPanel.this.cvWritePanel.updateByteValue(evt.getNewValue());
                DirectAccessPanel.this.triggerValidation();
            }
        });
        this.writeButton.setEnabled(false);
        this.writeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectAccessPanel.this.fireWrite();
            }
        });
        PropertyConnector.connect((Object)this.cvValidationModel, (String)"validState", (Object)this.writeButton, (String)"enabled");
        PropertyConnector.connect((Object)this.cvValidationModel, (String)"validStateNoWarnOrErrors", (Object)this.readButton, (String)"enabled");
        JPanel progActionButtons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.readButton, this.writeButton}).build();
        builder.add((Component)progActionButtons).xyw(1, row, 7);
        rowHolder[0] = row;
    }

    @Override
    protected void doBindButtons() {
    }

    @Override
    protected ValidationResultModel getValidationResultModel() {
        return this.cvValidationModel;
    }

    private ValidationResult validate() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.cvNumberValueModel, "validation");
        if (this.directAccessProgBeanModel.getCvNumber() == null) {
            support.addError("cvnumber_key", "not_empty");
        } else if (this.directAccessProgBeanModel.getCvNumber() < 1 || this.directAccessProgBeanModel.getCvNumber() > 1023) {
            support.addError("cvnumber_key", "invalid_value;min=1,max=1023");
        }
        if (this.directAccessProgBeanModel.getCvValue() == null) {
            if (PtMode.BYTE.equals((Object)this.directAccessProgBeanModel.getMode())) {
                support.add(Severity.INFO, "cvvalue_key", "not_empty_for_write");
            } else {
                support.addError("cvvalue_key", "not_empty_for_bit_verify");
            }
        } else if (this.directAccessProgBeanModel.getCvValue() < 0 || this.directAccessProgBeanModel.getCvValue() > 255) {
            support.addError("cvvalue_key", "invalid_value;min=0,max=255");
        }
        ValidationResult validationResult = support.getResult();
        this.LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    @Override
    protected void triggerValidation() {
        ValidationResult validationResult = this.validate();
        this.cvValidationModel.setResult(validationResult);
    }

    @Override
    protected void disableInputElements() {
        this.cvWritePanel.setEnabled(false);
        this.cvValue.setEnabled(false);
        this.cvNumber.setEnabled(false);
        for (JComponent comp : this.modeButtons) {
            comp.setEnabled(false);
        }
        super.disableInputElements();
    }

    @Override
    protected void enableInputElements() {
        this.cvWritePanel.setEnabled(true);
        this.cvValue.setEnabled(true);
        this.cvNumber.setEnabled(true);
        for (JComponent comp : this.modeButtons) {
            comp.setEnabled(true);
        }
        this.triggerValidation();
    }

    private int prepareBitCvValue(boolean write) {
        int intVal;
        int cvValue = this.cvWritePanel.getSelectedBit();
        int n = intVal = this.directAccessProgBeanModel.getCvValue() != null ? this.directAccessProgBeanModel.getCvValue() : 0;
        if (intVal != 0) {
            cvValue = (byte)(cvValue | 8);
        }
        if (write) {
            cvValue |= 0x10;
        }
        this.LOGGER.info("Prepared bit-based cvValue: {}", (Object)ByteUtils.byteToHex((int)(cvValue |= 0xE0)));
        return cvValue;
    }

    private int prepareByteCvValue() {
        int cvValue = this.directAccessProgBeanModel.getCvValue() != null ? this.directAccessProgBeanModel.getCvValue() : 0;
        this.LOGGER.info("Prepared byte-based cvValue: {}", (Object)ByteUtils.byteToHex((int)cvValue));
        return cvValue;
    }

    private void fireWrite() {
        this.disableInputElements();
        this.LOGGER.info("Prepare the write request for model: {}", (Object)this.directAccessProgBeanModel);
        this.directAccessProgBeanModel.getExecutedProgCommands().clear();
        List<PtOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = this.directAccessProgBeanModel.getProgCommands();
        progCommands.clear();
        int cvValue = 0;
        switch (this.directAccessProgBeanModel.getMode()) {
            case BIT: {
                cvValue = this.prepareBitCvValue(true);
                break;
            }
            default: {
                cvValue = this.prepareByteCvValue();
            }
        }
        int cvNumber = this.directAccessProgBeanModel.getCvNumber();
        PtOperation operation = PtMode.BIT.equals((Object)this.directAccessProgBeanModel.getMode()) ? PtOperation.WR_BIT : PtOperation.WR_BYTE;
        this.directAccessProgBeanModel.setCurrentOperation(operation);
        this.directAccessProgBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.WRITE);
        progCommands.add(new PtDirectAccessCommand(operation, cvNumber, cvValue));
        this.ptResultProxyModel.setCommandStationProgState(null);
        this.fireNextCommand();
    }

    private void fireRead() {
        this.disableInputElements();
        this.directAccessProgBeanModel.getExecutedProgCommands().clear();
        List<PtOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = this.directAccessProgBeanModel.getProgCommands();
        progCommands.clear();
        this.LOGGER.info("Prepare the read request for model: {}", (Object)this.directAccessProgBeanModel);
        int cvValue = 0;
        switch (this.directAccessProgBeanModel.getMode()) {
            case BIT: {
                cvValue = this.prepareBitCvValue(false);
                break;
            }
            default: {
                cvValue = this.prepareByteCvValue();
            }
        }
        int cvNumber = this.directAccessProgBeanModel.getCvNumber();
        PtOperation operation = PtMode.BIT.equals((Object)this.directAccessProgBeanModel.getMode()) ? PtOperation.RD_BIT : PtOperation.RD_BYTE;
        this.directAccessProgBeanModel.setCurrentOperation(operation);
        this.directAccessProgBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.READ);
        progCommands.add(new PtDirectAccessCommand(operation, cvNumber, cvValue));
        if (operation.equals((Object)PtOperation.RD_BYTE)) {
            this.cvValueValueModel.setValue(null);
        }
        this.ptResultProxyModel.setCommandStationProgState(null);
        this.fireNextCommand();
    }

    @Override
    protected Object getCurrentOperation() {
        return this.directAccessProgBeanModel.getCurrentOperation();
    }
}

