/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import java.text.DecimalFormat;
import javax.swing.table.DefaultTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AngleRenderer
extends DefaultTableCellRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AngleRenderer.class);
    private static final long serialVersionUID = 1L;
    private DecimalFormat df;
    private long totalSteps = 1L;

    public AngleRenderer(DecimalFormat df) {
        this.df = df;
        this.setHorizontalAlignment(4);
    }

    @Override
    protected void setValue(Object value) {
        this.setText(value == null ? "" : this.df.format(this.getPositionAsAngle(value)));
    }

    private float getPositionAsAngle(Object pos) {
        Long position = (Long)pos;
        return (float)position.longValue() * 360.0f / (float)this.totalSteps;
    }

    public long getTotalSteps() {
        return this.totalSteps;
    }

    public void setTotalSteps(long totalSteps) {
        if (totalSteps == 0L) {
            totalSteps = 1L;
        }
        LOGGER.info("Set the number of total steps: {}", (Object)totalSteps);
        this.totalSteps = totalSteps;
    }
}

