/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.script.ScriptCommand;
import org.bidib.wizard.api.script.ScriptEngineListener;
import org.bidib.wizard.api.script.ScriptStatus;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.switching.AccessoryScripting;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.nodescript.script.stepcontrol.StepControlScriptCommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptPanel
implements ScriptEngineListener<AccessoryScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptPanel.class);
    private static String scriptDescription;
    private static final String WORKING_DIR_STEP_CONTROL_KEY = "stepControl";
    private static final String SCRIPT_EXTENSION = "bidibt";
    private static FileFilter scriptFilter;
    private ValueModel selectedScriptModel = new ValueHolder();
    private ValueModel currentCommandModel = new ValueHolder();
    private JButton startScript;
    private JButton stopScript;
    private AccessoryScripting scripting;
    private ScriptEngine<AccessoryScripting> scriptEngine;
    private ValueModel checkRepeatingModel = new ValueHolder();
    private AtomicBoolean scriptRepeating = new AtomicBoolean(false);
    private JPanel contentPanel;
    private final SettingsService settingsService;

    public ScriptPanel(AccessoryScripting scripting, SettingsService settingsService) {
        this.scripting = scripting;
        this.settingsService = settingsService;
        scriptDescription = Resources.getString(ScriptPanel.class, (String)"scriptDescription");
        scriptFilter = new FileNameExtensionFilter(scriptDescription, SCRIPT_EXTENSION);
    }

    public JPanel createPanel() {
        this.scriptEngine = new ScriptEngine((Scripting)this.scripting, (ApplicationContext)new DefaultScriptContext());
        this.scriptEngine.addScriptEngineListener((ScriptEngineListener)this);
        this.checkRepeatingModel.setValue((Object)this.scriptRepeating.get());
        FormBuilder formBuilder = FormBuilder.create().columns("60dlu, 3dlu, 60dlu, 3dlu, 0dlu:grow", new Object[0]).rows("p, 3dlu, p, 3dlu, p", new Object[0]);
        JButton selectScript = new JButton(Resources.getString(ScriptPanel.class, (String)"selectScript"));
        selectScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final WizardSettingsInterface wizardSettings = ScriptPanel.this.settingsService.getWizardSettings();
                String storedWorkingDirectory = wizardSettings.getWorkingDirectory(ScriptPanel.WORKING_DIR_STEP_CONTROL_KEY);
                FileDialog dialog = new FileDialog(ScriptPanel.this.contentPanel, 0, storedWorkingDirectory, "*.bidibt", new FileFilter[]{scriptFilter}){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void approve(String fileName) {
                        block5: {
                            LOGGER.info("Load script: {}", (Object)fileName);
                            try {
                                File file = new File(fileName);
                                if (file.exists()) {
                                    LOGGER.info("The script file exists: {}", (Object)file);
                                    ScriptPanel.this.selectedScriptModel.setValue((Object)file.getName());
                                    ScriptPanel.this.prepareScript(fileName);
                                    ScriptPanel.this.startScript.setEnabled(true);
                                    String workingDir = Paths.get(fileName, new String[0]).getParent().toString();
                                    LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                                    wizardSettings.setWorkingDirectory(ScriptPanel.WORKING_DIR_STEP_CONTROL_KEY, workingDir);
                                    break block5;
                                }
                                ScriptPanel.this.selectedScriptModel.setValue((Object)"no script selected");
                                ScriptPanel.this.startScript.setEnabled(false);
                            }
                            catch (IOException ex) {
                                LOGGER.info("Load and process script file failed.", (Throwable)ex);
                                ScriptPanel.this.startScript.setEnabled(false);
                            }
                        }
                    }
                };
                dialog.showDialog();
            }
        });
        formBuilder.add((Component)selectScript).xy(1, 1);
        JLabel scriptLabel = WizardComponentFactory.createLabel((ValueModel)this.selectedScriptModel);
        formBuilder.add((Component)scriptLabel).xyw(3, 1, 3);
        JCheckBox repeatingCheck = WizardComponentFactory.createCheckBox((ValueModel)this.checkRepeatingModel, (String)Resources.getString(ScriptPanel.class, (String)"repeating"));
        formBuilder.add((Component)repeatingCheck).xyw(1, 3, 3);
        this.startScript = new JButton(Resources.getString(ScriptPanel.class, (String)"startScript"));
        this.startScript.setEnabled(false);
        this.startScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptPanel.this.scriptEngine.startScript();
            }
        });
        formBuilder.add((Component)this.startScript).xy(1, 5);
        this.stopScript = new JButton(Resources.getString(ScriptPanel.class, (String)"stopScript"));
        this.stopScript.setEnabled(false);
        this.stopScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptPanel.this.stopScript();
            }
        });
        formBuilder.add((Component)this.stopScript).xy(3, 5);
        JLabel currentCommandLabel = WizardComponentFactory.createLabel((ValueModel)this.currentCommandModel);
        formBuilder.add((Component)currentCommandLabel).xy(5, 5);
        this.checkRepeatingModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("Repeating has changed: {}", ScriptPanel.this.checkRepeatingModel.getValue());
                Boolean repeating = (Boolean)ScriptPanel.this.checkRepeatingModel.getValue();
                ScriptPanel.this.scriptRepeating.set(repeating);
                ScriptPanel.this.scriptEngine.setScriptRepeating(repeating.booleanValue());
            }
        });
        this.contentPanel = formBuilder.build();
        return this.contentPanel;
    }

    public void currentCommandChanged(final ScriptCommand<AccessoryScripting> command) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.currentCommandModel.setValue((Object)(command != null ? command.toString() : null));
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ScriptPanel.this.currentCommandModel.setValue(command != null ? command.toString() : null);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.warn("Update current command failed.", (Throwable)e);
            }
        }
    }

    private void stopScript() {
        LOGGER.info("Stop the script.");
        this.scriptEngine.stopScript();
    }

    public void scriptStatusChanged(final ScriptStatus scriptStatus) {
        LOGGER.info("The script status has changed: {}", (Object)scriptStatus);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (scriptStatus) {
                    case RUNNING: {
                        ScriptPanel.this.startScript.setEnabled(false);
                        ScriptPanel.this.stopScript.setEnabled(true);
                        break;
                    }
                    case ABORTED: 
                    case STOPPED: 
                    case FINISHED: 
                    case FINISHED_WITH_ERRORS: {
                        ScriptPanel.this.startScript.setEnabled(true);
                        ScriptPanel.this.stopScript.setEnabled(false);
                        break;
                    }
                }
                ScriptPanel.this.currentCommandChanged(null);
            }
        });
    }

    private void prepareScript(String fileName) throws IOException {
        Path fFilePath = Paths.get(fileName, new String[0]);
        StepControlScriptCommandFactory factory = new StepControlScriptCommandFactory();
        factory.registerCommands();
        LinkedList<ScriptCommand<AccessoryScripting>> scriptCommands = new LinkedList<ScriptCommand<AccessoryScripting>>();
        try (Scanner scanner = new Scanner(fFilePath, StandardCharsets.UTF_8);){
            while (scanner.hasNextLine()) {
                this.processLine(scanner.nextLine().trim(), factory, scriptCommands);
            }
        }
        LOGGER.info("Prepared list of commands: {}", scriptCommands);
        this.scriptEngine.setScriptCommands(scriptCommands);
    }

    private void processLine(String line, StepControlScriptCommandFactory factory, List<ScriptCommand<AccessoryScripting>> scriptCommands) {
        LOGGER.info("Process line: {}", (Object)line);
        if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) {
            LOGGER.info("Skip comment or empty line.");
        } else {
            LOGGER.info("Current line: {}", (Object)line);
            ScriptCommand command = factory.parse(line);
            if (command != null) {
                scriptCommands.add((ScriptCommand<AccessoryScripting>)command);
            }
        }
    }

    public void close() {
        if (this.scriptEngine != null) {
            LOGGER.info("Release the scriptEngine.");
            this.scriptEngine.removeScriptEngineListener((ScriptEngineListener)this);
            this.scriptEngine = null;
        }
    }
}

