/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view.excel;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.NodeUtils;
import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.stepcontrol.view.converter.AngleDegreesConverter;
import org.bidib.wizard.mvc.stepcontrol.view.excel.DataExchangeException;
import org.bidib.wizard.mvc.stepcontrol.view.excel.ImportAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelAspectReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelAspectReader.class);
    private static final Color EXCEL_COLOR_GREEN = new Color(0, 176, 80);
    private static final Color EXCEL_COLOR_RED = new Color(255, 0, 0);

    public List<ImportAspect> readAspects(InputStream excelFile) {
        LinkedList<ImportAspect> importAspects = new LinkedList<ImportAspect>();
        XSSFWorkbook wb = null;
        try {
            int rowNum;
            wb = new XSSFWorkbook(excelFile);
            Sheet firstSheet = wb.getSheetAt(0);
            LOGGER.info("First row num: {}", (Object)rowNum);
            for (rowNum = firstSheet.getFirstRowNum(); rowNum < 20; ++rowNum) {
                Row row = firstSheet.getRow(rowNum);
                if (row == null) {
                    LOGGER.info("Emtpy row: {}", (Object)rowNum);
                    continue;
                }
                short firstCellNum = row.getFirstCellNum();
                if (firstCellNum == -1) {
                    LOGGER.info("Emtpy row: {}", (Object)rowNum);
                    continue;
                }
                Cell firstCell = row.getCell((int)firstCellNum, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
                if (firstCell == null || !"Gleisanschluss".equals(firstCell.getStringCellValue())) continue;
                LOGGER.info("Found 'Gleisanschluss' in row: {}", (Object)rowNum);
                this.parseAspects(importAspects, firstSheet, ++rowNum, firstCellNum);
                break;
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Import aspects from Excel file failed.", (Throwable)ex);
            throw new DataExchangeException("Import aspects from Excel file failed.", ex);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (Exception ex) {
                    LOGGER.warn("Close Excel workbook failed.", (Throwable)ex);
                }
            }
        }
        return importAspects;
    }

    public void writeAspects(NodeInterface node, File excelFile, List<ImportAspect> aspects, MotorData motorData) {
        if (excelFile.exists()) {
            try {
                excelFile.renameTo(new File(excelFile.getPath() + ".bak"));
            }
            catch (Exception ex) {
                LOGGER.warn("Create backup of existing file failed.", (Throwable)ex);
                throw new DataExchangeException("Create backup of Excel file failed.", ex);
            }
        }
        LOGGER.info("Write workbook to: {}", (Object)excelFile);
        try (FileOutputStream fileOut = new FileOutputStream(excelFile);
             XSSFWorkbook wb = new XSSFWorkbook();){
            String sheetName = NodeUtils.getNodeName((NodeInterface)node);
            CellStyle h1Style = this.prepareBoldCellStyle((Workbook)wb);
            LOGGER.info("Create summary sheet: {}", (Object)sheetName);
            Sheet sheetSummary = wb.createSheet(sheetName);
            int rowNumber = 0;
            Row row = sheetSummary.createRow(rowNumber);
            Cell cell = row.createCell(0);
            cell.setCellValue(sheetName);
            cell.setCellStyle(h1Style);
            h1Style.setAlignment(HorizontalAlignment.CENTER);
            sheetSummary.addMergedRegion(new CellRangeAddress(rowNumber, rowNumber, 0, 3));
            rowNumber = (short)(rowNumber + 1);
            CellStyle defaultStyle = this.prepareDefaultCellStyle((Workbook)wb);
            defaultStyle.setAlignment(HorizontalAlignment.RIGHT);
            int n = rowNumber;
            rowNumber = (short)(rowNumber + 1);
            row = this.addMotorSpecRow(sheetSummary, n, defaultStyle, "Motorschritte", motorData.getMotorSteps());
            int n2 = rowNumber;
            rowNumber = (short)(rowNumber + 1);
            row = this.addMotorSpecRow(sheetSummary, n2, defaultStyle, "Mikroschritte", motorData.getMicroSteps());
            int n3 = rowNumber;
            rowNumber = (short)(rowNumber + 1);
            row = this.addMotorSpecRow(sheetSummary, n3, defaultStyle, "Gesamtschritte", motorData.getTotalSteps());
            rowNumber = (short)(rowNumber + 5);
            CellStyle boldStyle = this.prepareBoldCellStyle((Workbook)wb);
            TurnTableType turnTableType = motorData.getTurnTableType();
            if (turnTableType == TurnTableType.round) {
                int n4 = rowNumber;
                rowNumber = (short)(rowNumber + 1);
                this.addRow(sheetSummary, n4, new String[]{"Gleisanschluss", "Position", "Winkel"}, boldStyle);
            } else {
                int n5 = rowNumber;
                rowNumber = (short)(rowNumber + 1);
                this.addRow(sheetSummary, n5, new String[]{"Gleisanschluss", "Position"}, boldStyle);
            }
            for (ImportAspect aspect : aspects) {
                CellStyle defaultStyleAspects = this.prepareDefaultCellStyle((Workbook)wb);
                int n6 = rowNumber;
                rowNumber = (short)(rowNumber + 1);
                this.addRow((Workbook)wb, sheetSummary, n6, aspect, defaultStyleAspects, turnTableType, Long.valueOf(motorData.getTotalSteps()));
            }
            sheetSummary.setColumnWidth(0, 3584);
            sheetSummary.setColumnWidth(1, 3986);
            sheetSummary.setColumnWidth(2, 3840);
            wb.write((OutputStream)fileOut);
        }
        catch (IOException ex) {
            LOGGER.warn("Export aspects to Excel file failed.", (Throwable)ex);
            throw new DataExchangeException("Export aspects to Excel file failed.", ex);
        }
        catch (Exception ex) {
            LOGGER.warn("Export aspects to Excel file failed.", (Throwable)ex);
            throw new DataExchangeException("Export aspects to Excel file failed.", ex);
        }
    }

    private void parseAspects(List<ImportAspect> importAspects, Sheet firstSheet, int rowNumStart, int firstCellNum) {
        for (int rowNum = rowNumStart; rowNum < rowNumStart + 48; ++rowNum) {
            Row row = firstSheet.getRow(rowNum);
            if (row == null) continue;
            Cell indexCell = row.getCell(firstCellNum, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
            Cell positionCell = row.getCell(firstCellNum + 1, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
            LOGGER.debug("Current cell, index: {}, position: {}", (Object)indexCell, (Object)positionCell);
            double index = indexCell.getNumericCellValue();
            double position = positionCell.getNumericCellValue();
            int intIndex = (int)index;
            int roundedPos = (int)Math.round(position);
            LOGGER.info("Current cell values, index: {}, position: {}", (Object)intIndex, (Object)roundedPos);
            if (indexCell.getCellStyle() == null || indexCell.getCellStyle().getFillForegroundColorColor() == null) continue;
            XSSFCellStyle cellStyle = (XSSFCellStyle)indexCell.getCellStyle();
            XSSFColor bgColor = cellStyle.getFillForegroundXSSFColor();
            LOGGER.debug("Current bgColor: {}, val: {}", (Object)bgColor, (Object)ByteUtils.bytesToHex((byte[])bgColor.getRGB()));
            if ((EXCEL_COLOR_GREEN.getRGB() & 0xFFFFFF) == ByteUtils.getRGB((byte[])bgColor.getRGB())) {
                LOGGER.info("Current color is green.");
                importAspects.add(new ImportAspect(intIndex, roundedPos, false));
                continue;
            }
            if ((EXCEL_COLOR_RED.getRGB() & 0xFFFFFF) != ByteUtils.getRGB((byte[])bgColor.getRGB())) continue;
            LOGGER.info("Current color is red.");
            importAspects.add(new ImportAspect(intIndex, roundedPos, true));
        }
    }

    private CellStyle prepareH1CellStyle(Workbook wb) {
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)24);
        font.setItalic(true);
        font.setBold(true);
        font.setColor(IndexedColors.BLUE_GREY.getIndex());
        CellStyle style = wb.createCellStyle();
        style.setFont(font);
        return style;
    }

    private CellStyle prepareBoldCellStyle(Workbook wb) {
        Font font = wb.createFont();
        font.setBold(true);
        CellStyle style = wb.createCellStyle();
        style.setFont(font);
        return style;
    }

    private CellStyle prepareDefaultCellStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        return style;
    }

    private void addRow(Sheet sheet, int rowNumber, String[] cellValues, CellStyle cellStyle) {
        Row row = sheet.createRow(rowNumber);
        if (cellValues != null) {
            for (int column = 0; column < cellValues.length; ++column) {
                String cellValue = cellValues[column];
                Cell cell = row.createCell(column);
                cell.setCellValue(cellValue);
                if (cellStyle == null) continue;
                cell.setCellStyle(cellStyle);
            }
        }
    }

    private void addRow(Workbook wb, Sheet sheet, int rowNumber, ImportAspect aspect, CellStyle cellStyle, TurnTableType turnTableType, Long totalSteps) {
        double[] cellValues;
        Row row = sheet.createRow(rowNumber);
        if (TurnTableType.round == turnTableType) {
            double angleValue = AngleDegreesConverter.getPositionAsAngle(aspect.getPosition(), totalSteps);
            cellValues = new double[]{aspect.getIndex(), aspect.getPosition(), angleValue};
        } else {
            cellValues = new double[]{aspect.getIndex(), aspect.getPosition()};
        }
        CellStyle defaultStyleAspects = this.prepareDefaultCellStyle(wb);
        cellStyle.setFillForegroundColor((org.apache.poi.ss.usermodel.Color)(aspect.isInverse() ? new XSSFColor(EXCEL_COLOR_RED, null) : new XSSFColor(EXCEL_COLOR_GREEN, null)));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        if (cellValues != null) {
            DecimalFormat df = new DecimalFormat("#,###.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            for (int column = 0; column < cellValues.length; ++column) {
                double cellValue = cellValues[column];
                Cell cell = row.createCell(column);
                cell.setCellValue(cellValue);
                if (column == 0 && cellStyle != null) {
                    cell.setCellStyle(cellStyle);
                    continue;
                }
                if (column != 2) continue;
                DataFormat format = wb.createDataFormat();
                defaultStyleAspects.setDataFormat(format.getFormat("0.0"));
                cell.setCellStyle(defaultStyleAspects);
                cell.setCellValue(Double.valueOf(df.format(cellValue)).doubleValue());
            }
        }
    }

    private Row addMotorSpecRow(Sheet sheet, int rowNumber, CellStyle cellStyle, String title, int value) {
        Row row = sheet.createRow(rowNumber);
        Cell cell = row.createCell(0);
        cell.setCellValue(title);
        cell.setCellStyle(cellStyle);
        sheet.addMergedRegion(new CellRangeAddress(rowNumber, rowNumber, 0, 1));
        cell = row.createCell(2);
        cell.setCellValue((double)value);
        return row;
    }

    public static class MotorData {
        private final int motorSteps;
        private final int microSteps;
        private final int totalSteps;
        private TurnTableType turnTableType;

        public MotorData(int motorSteps, int microSteps, int totalSteps, TurnTableType turnTableType) {
            this.motorSteps = motorSteps;
            this.microSteps = microSteps;
            this.totalSteps = totalSteps;
            this.turnTableType = turnTableType;
        }

        public int getMotorSteps() {
            return this.motorSteps;
        }

        public int getMicroSteps() {
            return this.microSteps;
        }

        public int getTotalSteps() {
            return this.totalSteps;
        }

        public TurnTableType getTurnTableType() {
            return this.turnTableType;
        }
    }
}

