package org.bidib.wizard.mvc.accessory.view.panel;

import java.awt.event.ActionEvent;
import java.text.DecimalFormat;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AccessoryAddressingEnum;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.mvc.accessory.model.AccessoryBeanModel;
import org.bidib.wizard.mvc.accessory.model.AccessoryModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.util.PropertyValidationSupport;
import com.jgoodies.validation.view.ValidationComponentUtils;

public class DccAccessoryPanel extends AbstractAccessoryPanel<AccessoryBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DccAccessoryPanel.class);

    private static final String ENCODED_LOCAL_COLUMN_SPECS = "max(50dlu;pref), 3dlu, max(50dlu;pref), 3dlu, pref:grow";

    private static final String ENCODED_LOCAL_DIRECT_COLUMN_SPECS =
        "pref, 3dlu, max(50dlu;pref), 3dlu, max(50dlu;pref), 10dlu, pref, 3dlu, max(50dlu;pref), 3dlu, max(50dlu;pref), 3dlu, pref:grow";

    private static final String ENCODED_LOCAL_ROW_SPECS = "pref";

    private ValueModel timingControlModel;

    private final AccessoryBeanModel accessoryBeanModel;

    private JComponent[] timingControlButtons;

    private final JButton aspectButtonsAutomatic[] = new JButton[2];

    private final JButton coilButtonsDirect[] = new JButton[4];

    public DccAccessoryPanel(final AccessoryModel accessoryModel) {
        super(accessoryModel);
        accessoryBeanModel = new AccessoryBeanModel();
    }

    @Override
    protected AccessoryBeanModel getAccessoryBeanModel() {
        return accessoryBeanModel;
    }

    @Override
    protected void addSpecificComponents(final FormBuilder builder, final int[] rowHolder) {
        // goto next line
        int row = rowHolder[0];

        row += 2;
        builder.appendRows("3dlu, p");

        timingControlModel =
            new PropertyAdapter<AccessoryBeanModel>(accessoryBeanModel, AccessoryBeanModel.PROPERTYNAME_TIMING_CONTROL,
                true);
        timingControlButtons = new JComponent[TimingControlEnum.values().length];

        int index = 0;

        JRadioButton radioAutomatic =
            WizardComponentFactory
                .createRadioButton(timingControlModel, TimingControlEnum.OUTPUT_UNIT,
                    Resources.getString(TimingControlEnum.class, TimingControlEnum.OUTPUT_UNIT.getKey()));
        timingControlButtons[index++] = radioAutomatic;
        builder.add(radioAutomatic).xyw(1, row, 9);

        rowHolder[0] = row;

        addActivationAndTimeComponents(builder, rowHolder);

        row = rowHolder[0];

        row += 2;
        builder.appendRows("3dlu, p");

        final FormBuilder localBuilderAutomatic =
            FormBuilder.create().columns(ENCODED_LOCAL_COLUMN_SPECS).rows(ENCODED_LOCAL_ROW_SPECS);

        // add the aspects
        int column = 1;
        for (int aspect = 0; aspect < 2; aspect++) {

            JButton aspectButton =
                new JButton(new AbstractAction(Resources.getString(DccAccessoryPanel.class, "aspect-" + aspect)) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        // set aspect button was pressed
                        Integer aspect = (Integer) ((JButton) e.getSource()).getClientProperty("aspect");
                        LOGGER.info("Pressed button: {}, aspect: {}", e.getActionCommand(), aspect);

                        int directDccAddress =
                            accessoryBeanModel.getDccAddress()
                                + (accessoryBeanModel.getAccessoryAddressing() == AccessoryAddressingEnum.RCN_213 ? 3
                                    : 0);

                        addLogText(
                            "Send DCC accessory request, address: {}, aspect: {}, switch time: {}, time base: {}",
                            directDccAddress, aspect, accessoryBeanModel.getSwitchTime(),
                            Resources.getString(TimeBaseUnitEnum.class, accessoryBeanModel.getTimeBaseUnit().getKey()));

                        // set the aspect triggers the property change listener
                        accessoryBeanModel.setAcknowledge(null);
                        accessoryBeanModel.setAspect(aspect);
                        // send the request
                        AddressData addressData = new AddressData(directDccAddress, AddressTypeEnum.ACCESSORY);
                        sendRequest(addressData, accessoryBeanModel.getAspect(), accessoryBeanModel.getSwitchTime(),
                            accessoryBeanModel.getTimeBaseUnit(), accessoryBeanModel.getTimingControl());
                    }
                });
            aspectButton.putClientProperty("aspect", Integer.valueOf(aspect));
            aspectButton.setEnabled(false);
            aspectButtonsAutomatic[aspect] = aspectButton;
            localBuilderAutomatic.add(aspectButton).xy(column, 1);

            column += 2;
        }
        builder.add(localBuilderAutomatic.build()).xyw(1, row, 9);

        row += 2;
        builder.appendRows("3dlu, p");

        JRadioButton radioDirect =
            WizardComponentFactory
                .createRadioButton(timingControlModel, TimingControlEnum.COIL_ON_OFF,
                    Resources.getString(TimingControlEnum.class, TimingControlEnum.COIL_ON_OFF.getKey()));
        timingControlButtons[index] = radioDirect;
        builder.add(radioDirect).xyw(1, row, 9);

        // direct control buttons
        row += 2;
        builder.appendRows("3dlu, p");

        final FormBuilder localBuilderDirect =
            FormBuilder.create().columns(ENCODED_LOCAL_DIRECT_COLUMN_SPECS).rows(ENCODED_LOCAL_ROW_SPECS);

        column = 1;
        localBuilderDirect.add(Resources.getString(DccAccessoryPanel.class, "red-coil")).xy(column, 1);

        column += 2;

        // add the red coil buttons
        for (int coilState = 0; coilState < 2; coilState++) {

            JButton aspectButton =
                new JButton(new AbstractAction(
                    Resources.getString(DccAccessoryPanel.class, "coil-" + (coilState == 0 ? "on" : "off"))) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        // set aspect button was pressed
                        Integer aspect = Integer.valueOf(0);
                        Integer coilState = (Integer) ((JButton) e.getSource()).getClientProperty("coilState");
                        LOGGER
                            .info("Pressed button: {}, aspect: {}, coilState: {}", e.getActionCommand(), aspect,
                                coilState);

                        int directDccAddress =
                            accessoryBeanModel.getDccAddress()
                                + (accessoryBeanModel.getAccessoryAddressing() == AccessoryAddressingEnum.RCN_213 ? 3
                                    : 0);

                        addLogText("Send DCC accessory request for red coil, address: {}, aspect: {}, coilState: {}",
                            directDccAddress, aspect, coilState);

                        // set the aspect triggers the property change listener
                        accessoryBeanModel.setAcknowledge(null);
                        accessoryBeanModel.setAspect(aspect);
                        // send the request
                        AddressData addressData = new AddressData(directDccAddress, AddressTypeEnum.ACCESSORY);
                        sendRequest(addressData, accessoryBeanModel.getAspect(), coilState);
                    }
                });
            aspectButton.putClientProperty("coilState", Integer.valueOf(coilState));
            aspectButton.setEnabled(false);
            coilButtonsDirect[coilState] = aspectButton;
            localBuilderDirect.add(aspectButton).xy(column, 1);

            column += 2;
        }

        localBuilderDirect.add(Resources.getString(DccAccessoryPanel.class, "green-coil")).xy(column, 1);
        column += 2;

        for (int coilState = 0; coilState < 2; coilState++) {

            JButton aspectButton =
                new JButton(new AbstractAction(
                    Resources.getString(DccAccessoryPanel.class, "coil-" + (coilState == 0 ? "on" : "off"))) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        // set aspect button was pressed
                        Integer aspect = Integer.valueOf(1);
                        Integer coilState = (Integer) ((JButton) e.getSource()).getClientProperty("coilState");
                        LOGGER
                            .info("Pressed button: {}, aspect: {}, coilState: {}", e.getActionCommand(), aspect,
                                coilState);

                        int directDccAddress =
                            accessoryBeanModel.getDccAddress()
                                + (accessoryBeanModel.getAccessoryAddressing() == AccessoryAddressingEnum.RCN_213 ? 3
                                    : 0);

                        addLogText("Send DCC accessory request for green coil, address: {}, aspect: {}, coilState: {}",
                            directDccAddress, aspect, coilState);

                        // set the aspect triggers the property change listener
                        accessoryBeanModel.setAcknowledge(null);
                        accessoryBeanModel.setAspect(aspect);
                        // send the request
                        AddressData addressData = new AddressData(directDccAddress, AddressTypeEnum.ACCESSORY);
                        sendRequest(addressData, accessoryBeanModel.getAspect(), coilState);
                    }
                });
            aspectButton.putClientProperty("coilState", Integer.valueOf(coilState));
            aspectButton.setEnabled(false);
            coilButtonsDirect[coilState + 2] = aspectButton;
            localBuilderDirect.add(aspectButton).xy(column, 1);

            column += 2;
        }

        builder.add(localBuilderDirect.build()).xyw(1, row, 11);

        this.timingControlModel.addValueChangeListener(evt -> {
            DccAccessoryPanel.this.validStateConnector.setEnabled(accessoryValidationModel.getValidState());
        });

        // update the row holder
        rowHolder[0] = row;
    }

    private ValueModel switchTimeValueModel;

    private JComponent[] baseUnitButtons;

    private JTextField switchTimeText;

    protected void addActivationAndTimeComponents(final FormBuilder builder, final int[] rowHolder) {

        int currentRow = rowHolder[0];

        currentRow += 2;
        builder.appendRows("3dlu, p");

        switchTimeValueModel =
            new PropertyAdapter<AccessoryBeanModel>(getAccessoryBeanModel(), AccessoryModel.PROPERTYNAME_SWITCH_TIME,
                true);

        final ValueModel switchTimeConverterModel =
            new ConverterValueModel(switchTimeValueModel, new StringConverter(new DecimalFormat("#")));

        this.switchTimeText = new JTextField();
        InputValidationDocument switchTimeDocument = new InputValidationDocument(3, InputValidationDocument.NUMERIC);
        switchTimeText.setDocument(switchTimeDocument);
        switchTimeText.setColumns(3);

        // bind manually because we changed the document of the textfield
        Bindings.bind(switchTimeText, switchTimeConverterModel, false);

        switchTimeText.setEnabled(false);

        builder.add(Resources.getString(AbstractAccessoryPanel.class, "switchTime")).xy(1, currentRow);
        builder.add(switchTimeText).xy(3, currentRow);

        ValidationComponentUtils.setMandatory(switchTimeText, true);
        ValidationComponentUtils.setMessageKeys(switchTimeText, "validation.switchtime_key");

        JLabel timeBaseUnit = new JLabel(Resources.getString(AbstractAccessoryPanel.class, "timeBaseUnit"));
        builder.add(timeBaseUnit).xy(5, currentRow);
        timeBaseUnit.setHorizontalAlignment(SwingConstants.TRAILING);
        ValueModel modeModel =
            new PropertyAdapter<AccessoryBeanModel>(getAccessoryBeanModel(), AccessoryModel.PROPERTYNAME_TIME_BASE_UNIT,
                true);
        this.baseUnitButtons = new JComponent[TimeBaseUnitEnum.values().length];

        int index = 0;
        int column = 7;
        for (TimeBaseUnitEnum baseUnit : TimeBaseUnitEnum.values()) {

            JRadioButton radio =
                WizardComponentFactory
                    .createRadioButton(modeModel, baseUnit,
                        Resources.getString(TimeBaseUnitEnum.class, baseUnit.getKey()));
            this.baseUnitButtons[index++] = radio;
            radio.setEnabled(false);

            // add radio button
            builder.add(radio).xy(column, currentRow);

            column += 2;
        }

        rowHolder[0] = currentRow;
    }

    private final ValidStateConnector validStateConnector = new ValidStateConnector();

    @Override
    protected void addSpecificValidation() {
        PropertyConnector
            .connect(accessoryValidationModel, AccessoryValidationResultModel.PROPERTY_VALID_STATE, validStateConnector,
                ValidStateConnector.PROPERTY_ENABLED);
    }

    @Override
    protected void validateSpecificPanel(PropertyValidationSupport support) {

    }

    @Override
    protected void disableInputElements() {
        // TODO use a new different property here
        accessoryValidationModel.setValidState(false);
    }

    @Override
    protected void enableInputElements() {
        // TODO use a new different property here
        accessoryValidationModel.setValidState(true);
    }

    private static final int MAX_ADDRESS = 2047;

    @Override
    protected int getMaxAddress() {
        return MAX_ADDRESS;
    }

    public class ValidStateConnector extends Bean {

        private static final long serialVersionUID = 1L;

        private static final String PROPERTY_ENABLED = "enabled";

        private boolean enabled;

        /**
         * @return the enabled
         */
        public boolean isEnabled() {
            return enabled;
        }

        /**
         * @param enabled
         *            the enabled to set
         */
        public void setEnabled(boolean enabled) {
            LOGGER.info("Set the enabled flag: {}", enabled);
            this.enabled = enabled;

            if (accessoryBeanModel.getTimingControl() == TimingControlEnum.OUTPUT_UNIT) {
                for (int aspect = aspectButtonsAutomatic.length - 1; aspect > -1; aspect--) {
                    if (aspectButtonsAutomatic[aspect] != null) {
                        aspectButtonsAutomatic[aspect].setEnabled(enabled);
                    }
                }
                for (int baseUnit = baseUnitButtons.length - 1; baseUnit > -1; baseUnit--) {
                    if (baseUnitButtons[baseUnit] != null) {
                        baseUnitButtons[baseUnit].setEnabled(enabled);
                    }
                }
                if (switchTimeText != null) {
                    switchTimeText.setEnabled(enabled);
                }

                for (int coil = coilButtonsDirect.length - 1; coil > -1; coil--) {
                    if (coilButtonsDirect[coil] != null) {
                        coilButtonsDirect[coil].setEnabled(false);
                    }
                }
            }
            else {
                for (int aspect = aspectButtonsAutomatic.length - 1; aspect > -1; aspect--) {
                    if (aspectButtonsAutomatic[aspect] != null) {
                        aspectButtonsAutomatic[aspect].setEnabled(false);
                    }
                }
                for (int baseUnit = baseUnitButtons.length - 1; baseUnit > -1; baseUnit--) {
                    if (baseUnitButtons[baseUnit] != null) {
                        baseUnitButtons[baseUnit].setEnabled(false);
                    }
                }
                if (switchTimeText != null) {
                    switchTimeText.setEnabled(false);
                }

                for (int coil = coilButtonsDirect.length - 1; coil > -1; coil--) {
                    if (coilButtonsDirect[coil] != null) {
                        coilButtonsDirect[coil].setEnabled(enabled);
                    }
                }
            }

        }
    }
}
