package org.bidib.wizard.mvc.main.view.menu;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.DetachedState;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.component.LabeledDisplayItems;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.client.common.view.menu.listener.NodeListMenuListener;
import org.bidib.wizard.common.labels.DefaultWizardLabelFactory.VersionedDefaultNodeLabelsWrapper;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.pt.controller.PtProgrammerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeListMenu {

    private static final Logger LOGGER = LoggerFactory.getLogger(NodeListMenu.class);

    private static final Collection<NodeListMenuListener> menuListeners = new LinkedList<NodeListMenuListener>();

    private final MainModel model;

    private final JMenuItem displayNodeDetails = new JMenuItem(Resources.getString(getClass(), "nodeDetails"));

    private final JMenuItem clearError = new JMenuItem(Resources.getString(getClass(), "clearError") + " ...");

    private final JCheckBoxMenuItem identify = new JCheckBoxMenuItem(Resources.getString(getClass(), "identify"));

    private final JMenuItem firmwareUpdate = new JMenuItem(Resources.getString(getClass(), "firmwareUpdate") + " ...");

    private final JMenuItem features = new JMenuItem(Resources.getString(getClass(), "features") + " ...");

    private final JMenuItem reset = new JMenuItem(Resources.getString(getClass(), "reset") + " ...");

    private final JMenuItem reloadNode = new JMenuItem(Resources.getString(getClass(), "reloadNode") + " ...");

    private final JMenuItem loco = new JMenuItem(Resources.getString(getClass(), "loco") + " ...");

    private JSeparator locoListSeparator;

    private JSeparator dmxModelerSeparator;

    private final JMenuItem locoList = new JMenuItem(Resources.getString(getClass(), "locoList") + " ...");

    private final JMenuItem dccAccessory = new JMenuItem(Resources.getString(getClass(), "dccAccessory") + " ...");

    private final JMenuItem locoCv = new JMenuItem(Resources.getString(getClass(), "locoCv") + " ...");

    private final JMenuItem locoCvPt = new JMenuItem(Resources.getString(getClass(), "locoCvPt") + " ...");

    private final JMenuItem ping = new JMenuItem(Resources.getString(getClass(), "ping"));

    private final JMenuItem enable = new JMenuItem(Resources.getString(getClass(), "enable"));

    private final JMenuItem disable = new JMenuItem(Resources.getString(getClass(), "disable"));

    private final JMenuItem uniqueId = new JMenuItem(Resources.getString(getClass(), "uniqueId"));

    private final JCheckBoxMenuItem detachAttachNode =
        new JCheckBoxMenuItem(Resources.getString(getClass(), "detachAttachNode"));

    private final JMenuItem dmxModeler = new JMenuItem(Resources.getString(getClass(), "dmxModeler") + " ...");

    private final JCheckBoxMenuItem addressMessagesEnabled =
        new JCheckBoxMenuItem(Resources.getString(getClass(), "addressMessages"));

    private final JCheckBoxMenuItem feedbackMessagesEnabled =
        new JCheckBoxMenuItem(Resources.getString(getClass(), "feedbackMessages"));

    private final JCheckBoxMenuItem keyMessagesEnabled =
        new JCheckBoxMenuItem(Resources.getString(getClass(), "keyMessages"));

    private final JCheckBoxMenuItem externalStartEnabled =
        new JCheckBoxMenuItem(Resources.getString(getClass(), "externalStart"));

    private final JCheckBoxMenuItem dccStartEnabled =
        new JCheckBoxMenuItem(Resources.getString(getClass(), "dccStart"));

    private final JMenuItem dccAdvAvailable =
        new JMenuItem(Resources.getString(getClass(), "dccAdvAvailable") + " ...");

    private final JCheckBoxMenuItem feedbackMirrorDisabled =
        new JCheckBoxMenuItem(Resources.getString(getClass(), "feedbackMirrorDisabled"));

    private final JMenuItem importNode = new JMenuItem(Resources.getString(getClass(), "import") + " ...");

    private final JMenuItem exportNode = new JMenuItem(Resources.getString(getClass(), "export") + " ...");

    private final JMenuItem generateNodeDocumentation =
        new JMenuItem(Resources.getString(getClass(), "documentation") + " ...");

    private final JMenuItem generateNodeDefaultLabels =
        new JMenuItem(Resources.getString(getClass(), "defaultLabels") + " ...");

    private final JMenuItem applyNodeDefaultLabels =
        new JMenuItem(Resources.getString(getClass(), "applyDefaultLabels") + " ...");

    private final JMenuItem deleteNodeLabels =
        new JMenuItem(Resources.getString(getClass(), "deleteNodeLabels") + " ...");

    private final JMenuItem bulkSwitchNode = new JMenuItem(Resources.getString(getClass(), "bulkSwitch"));

    private final JMenuItem saveItem = new JMenuItem(Resources.getString(getClass(), "save"));

    private JSeparator bulkSwitchSeparator;

    private JSeparator keyMessagesExtMacroStartSeparator;

    private final SettingsService settingsService;

    private final WizardLabelWrapper wizardLabelWrapper;

    public NodeListMenu(final MainModel model, final SettingsService settingsService,
        final WizardLabelWrapper wizardLabelWrapper) {
        this.model = model;
        this.settingsService = settingsService;
        this.wizardLabelWrapper = wizardLabelWrapper;

        exportNode.setToolTipText(Resources.getString(getClass(), "export.tooltip"));
        clearError.setToolTipText(Resources.getString(getClass(), "clearError.tooltip"));

        enable.setToolTipText(Resources.getString(getClass(), "enable.tooltip"));
        disable.setToolTipText(Resources.getString(getClass(), "disable.tooltip"));

        saveItem.setToolTipText(Resources.getString(getClass(), "save.tooltip"));
    }

    private void addMenuItem(Object menu, JMenuItem menuItem) {
        if (menu instanceof JMenu) {
            ((JMenu) menu).add(menuItem);
        }
        else if (menu instanceof JPopupMenu) {
            ((JPopupMenu) menu).add(menuItem);
        }
    }

    private void addNodeListMenu(Object menu) {

        displayNodeDetails.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireDisplayNodeDetails();
            }
        });
        addMenuItem(menu, displayNodeDetails);

        JMenuItem editLabel = new JMenuItem(Resources.getString(getClass(), "editLabel") + " ...");

        editLabel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireEditLabel();
            }
        });
        addMenuItem(menu, editLabel);

        saveItem
            .setAccelerator(
                KeyStroke.getKeyStroke(KeyEvent.VK_S, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        saveItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireSave();
            }
        });
        addMenuItem(menu, saveItem);

        clearError.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireClearError();
            }
        });
        addMenuItem(menu, clearError);

        identify.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireIdentify(identify.isSelected());
            }
        });
        addMenuItem(menu, identify);

        JMenuItem details = new JMenuItem(Resources.getString(getClass(), "details") + " ...");

        details.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireDetails();
            }
        });
        addMenuItem(menu, details);

        firmwareUpdate.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireFirmwareUpdate();
            }
        });
        addMenuItem(menu, firmwareUpdate);

        features.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireFeatures();
            }
        });
        addMenuItem(menu, features);

        reset.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireReset();
            }
        });
        addMenuItem(menu, reset);

        reloadNode.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireReloadNode();
            }
        });
        addMenuItem(menu, reloadNode);

        loco.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireLoco();
            }
        });
        addMenuItem(menu, loco);

        dccAccessory.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireDccAccessory();
            }
        });
        addMenuItem(menu, dccAccessory);

        // programming on main track
        locoCv.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireLocoCv();
            }
        });
        addMenuItem(menu, locoCv);

        // programming on programming track
        locoCvPt.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireLocoCvPt();
            }
        });
        addMenuItem(menu, locoCvPt);

        boolean isPowerUser = settingsService.getWizardSettings().isPowerUser();

        ping.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                firePing();
            }
        });
        addMenuItem(menu, ping);
        ping.setVisible(isPowerUser);

        enable.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireEnable();
            }
        });
        addMenuItem(menu, enable);
        enable.setVisible(isPowerUser);

        disable.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireDisable();
            }
        });
        addMenuItem(menu, disable);
        disable.setVisible(isPowerUser);

        uniqueId.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireReadUniqueId();
            }
        });
        addMenuItem(menu, uniqueId);
        uniqueId.setVisible(isPowerUser);

        // add the detach or attach menu item
        detachAttachNode.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = detachAttachNode.isSelected();
                LOGGER.info("detachAttachNode.isSelected: {}", isSelected);

                fireDetachAttachNode();
            }
        });
        addMenuItem(menu, detachAttachNode);
        detachAttachNode.setVisible(isPowerUser);

        boolean isLocoListEnabled = false;
        locoListSeparator = addSeparator(menu);
        locoListSeparator.setVisible(isLocoListEnabled);

        locoList.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireLocoList();
            }
        });
        addMenuItem(menu, locoList);
        locoList.setVisible(isLocoListEnabled);

        dmxModelerSeparator = addSeparator(menu);
        dmxModelerSeparator.setVisible(false);

        dmxModeler.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                fireDmxModeler();
            }
        });
        addMenuItem(menu, dmxModeler);
        dmxModeler.setEnabled(false);
        dmxModeler.setVisible(false);

        addSeparator(menu);

        addressMessagesEnabled.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireAddressMessagesEnabled(addressMessagesEnabled.isSelected());
            }
        });
        addMenuItem(menu, addressMessagesEnabled);

        feedbackMessagesEnabled.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireFeedbackMessagesEnabled(feedbackMessagesEnabled.isSelected());
            }
        });
        addMenuItem(menu, feedbackMessagesEnabled);

        // power users can disable sending feedback mirror messages
        feedbackMirrorDisabled.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireFeedbackMirrorDisabled(feedbackMirrorDisabled.isSelected());
            }
        });
        addMenuItem(menu, feedbackMirrorDisabled);
        feedbackMirrorDisabled.setVisible(isPowerUser);

        keyMessagesEnabled.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireKeyMessagesEnabled(keyMessagesEnabled.isSelected());
            }
        });
        addMenuItem(menu, keyMessagesEnabled);

        dccStartEnabled.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireDccStartEnabled(dccStartEnabled.isSelected());
            }
        });
        addMenuItem(menu, dccStartEnabled);

        externalStartEnabled.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireExternalStartEnabled(externalStartEnabled.isSelected());
            }
        });
        addMenuItem(menu, externalStartEnabled);

        dccAdvAvailable.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                firedDccAdvView();
            }
        });
        addMenuItem(menu, dccAdvAvailable);
        this.dccAdvAvailable.setEnabled(false);
        this.dccAdvAvailable.setVisible(false);

        keyMessagesExtMacroStartSeparator = addSeparator(menu);

        importNode.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireImport();
            }
        });
        addMenuItem(menu, importNode);

        exportNode.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireExport();
            }
        });
        addMenuItem(menu, exportNode);

        generateNodeDocumentation.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireGenerateDocumentation();
            }
        });
        addMenuItem(menu, generateNodeDocumentation);

        applyNodeDefaultLabels.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireApplyDefaultLabels();
            }
        });
        addMenuItem(menu, applyNodeDefaultLabels);

        generateNodeDefaultLabels.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireGenerateDefaultLabels();
            }
        });
        addMenuItem(menu, generateNodeDefaultLabels);

        deleteNodeLabels.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireDeleteNodeLabels();
            }
        });
        deleteNodeLabels.setToolTipText(Resources.getString(getClass(), "deleteNodeLabels.tooltip"));
        addMenuItem(menu, deleteNodeLabels);

        bulkSwitchSeparator = addSeparator(menu);

        bulkSwitchNode.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireBulkSwitch();
            }
        });
        addMenuItem(menu, bulkSwitchNode);
    }

    public void addMenuListener(NodeListMenuListener l) {
        menuListeners.add(l);
    }

    private JSeparator addSeparator(Object menu) {

        JSeparator separator = new JPopupMenu.Separator();
        if (menu instanceof JMenu) {
            ((JMenu) menu).add(separator);
        }
        else if (menu instanceof JPopupMenu) {
            ((JPopupMenu) menu).add(separator);
        }
        return separator;
    }

    private void fireAddressMessagesEnabled(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.addressMessagesEnabled(isSelected);
        }
    }

    private void fireDccStartEnabled(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.dccStartEnabled(isSelected);
        }
    }

    private void fireDetails() {
        for (NodeListMenuListener l : menuListeners) {
            l.showDetails();
        }
    }

    private void fireEditLabel() {
        for (NodeListMenuListener l : menuListeners) {
            l.editLabel(null);
        }
    }

    private void fireSave() {
        for (NodeListMenuListener l : menuListeners) {
            l.savePendingChanges();
        }
    }

    private void fireClearError() {
        for (NodeListMenuListener l : menuListeners) {
            l.clearErrors();
        }
    }

    private void fireExport() {
        for (NodeListMenuListener l : menuListeners) {
            l.exportNode();
        }
    }

    private void fireExternalStartEnabled(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.externalStartEnabled(isSelected);
        }
    }

    private void fireFeedbackMessagesEnabled(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.feedbackMessagesEnabled(isSelected);
        }
    }

    private void fireFeedbackMirrorDisabled(boolean disable) {
        for (NodeListMenuListener l : menuListeners) {
            l.feedbackMirrorDisabled(disable);
        }
    }

    private void fireFirmwareUpdate() {
        for (NodeListMenuListener l : menuListeners) {
            l.firmwareUpdate();
        }
    }

    private void fireIdentify(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.identify(isSelected);
        }
    }

    private void fireDisplayNodeDetails() {
        for (NodeListMenuListener l : menuListeners) {
            l.displayNodeDetails();
        }
    }

    private void firedDccAdvView() {
        for (NodeListMenuListener l : menuListeners) {
            l.dccAdvView();
        }
    }

    private void fireImport() {
        for (NodeListMenuListener l : menuListeners) {
            l.importNode();
        }
    }

    private void fireKeyMessagesEnabled(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.keyMessagesEnabled(isSelected);
        }
    }

    private void fireFeatures() {
        for (NodeListMenuListener l : menuListeners) {
            l.features();
        }
    }

    private void fireReset() {
        for (NodeListMenuListener l : menuListeners) {
            l.reset();
        }
    }

    private void fireReloadNode() {
        for (NodeListMenuListener l : menuListeners) {
            l.reloadNode();
        }
    }

    private void firePing() {
        for (NodeListMenuListener l : menuListeners) {
            l.ping();
        }
    }

    private void fireEnable() {
        for (NodeListMenuListener l : menuListeners) {
            l.enable();
        }
    }

    private void fireDisable() {
        for (NodeListMenuListener l : menuListeners) {
            l.disable();
        }
    }

    private void fireReadUniqueId() {
        for (NodeListMenuListener l : menuListeners) {
            l.readUniqueId();
        }
    }

    private void fireDetachAttachNode() {
        for (NodeListMenuListener l : menuListeners) {
            l.detachAttachNode();
        }
    }

    private void fireDmxModeler() {
        for (NodeListMenuListener l : menuListeners) {
            l.dmxModeler();
        }
    }

    private void fireLoco() {
        for (NodeListMenuListener l : menuListeners) {
            l.loco();
        }
    }

    private void fireLocoList() {
        for (NodeListMenuListener l : menuListeners) {
            l.locoList();
        }
    }

    private void fireDccAccessory() {
        for (NodeListMenuListener l : menuListeners) {
            l.dccAccessory();
        }
    }

    private void fireLocoCv() {
        for (NodeListMenuListener l : menuListeners) {
            l.locoCv();
        }
    }

    private void fireLocoCvPt() {
        for (NodeListMenuListener l : menuListeners) {
            l.locoCvPt();
        }
    }

    private void fireBulkSwitch() {
        for (NodeListMenuListener l : menuListeners) {
            l.bulkSwitchNode();
        }
    }

    private void fireGenerateDocumentation() {
        for (NodeListMenuListener l : menuListeners) {
            l.generateDocumentation();
        }
    }

    private void fireGenerateDefaultLabels() {
        for (NodeListMenuListener l : menuListeners) {
            l.generateDefaultLabels();
        }
    }

    private void fireApplyDefaultLabels() {
        for (NodeListMenuListener l : menuListeners) {
            l.applyDefaultLabels();
        }
    }

    private void fireDeleteNodeLabels() {
        for (NodeListMenuListener l : menuListeners) {
            l.deleteNodeLabels();
        }
    }

    public JMenu getJMenu() {
        JMenu menu = new JMenu();

        addNodeListMenu(menu);
        return menu;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new BasicPopupMenu() {
            private static final long serialVersionUID = 1L;

            @Override
            public void show(Component invoker, int x, int y) {
                NodeInterface node = ((LabeledDisplayItems<NodeInterface>) invoker).getSelectedItem();
                if (node != null) {
                    updateMenuItems(node);
                    super.show(invoker, x, y);
                }
            }
        };

        addNodeListMenu(popupMenu);
        return popupMenu;
    }

    public void updateMenuItems(final NodeInterface node) {
        boolean nodeIsSelected = node.equals(model.getSelectedNode());

        setAddressMessagesEnabled(node.isAddressMessagesEnabled());
        setDccStartEnabled(node.isDccStartEnabled());
        setExternalStartEnabled(node.isExternalStartEnabled());
        setFeedbackMessagesEnabled(node.isFeedbackMessagesEnabled());

        // feedback mirror disabled is only available for power users
        setFeedbackMirrorDisabled(node.isFeedbackMirrorDisabled());
        boolean isPowerUser = settingsService.getWizardSettings().isPowerUser();
        feedbackMirrorDisabled.setVisible(node.hasFeedbackPorts() && isPowerUser);

        ping.setVisible(isPowerUser);
        enable.setVisible(isPowerUser);
        disable.setVisible(isPowerUser);
        detachAttachNode.setVisible(Arrays.equals(node.getAddr(), Node.ROOTNODE_ADDR));

        uniqueId.setVisible(isPowerUser);

        if (keyMessagesEnabled.isVisible() || dccStartEnabled.isVisible() || externalStartEnabled.isVisible()) {
            keyMessagesExtMacroStartSeparator.setVisible(true);
        }
        else {
            keyMessagesExtMacroStartSeparator.setVisible(false);
        }

        setClearErrorEnabled(node.isNodeHasError());
        setFeaturesEnabled(!node.isBootloaderNode());
        setFirmwareUpdateEnabled(node.isUpdatable());

        // loco dialog
        final BoosterControl boosterControl =
            node.getBoosterNode() != null ? node.getBoosterNode().getBoosterControl() : null;
        boolean isCommandStation = node.getCommandStationNode() != null;
        if (isCommandStation && boosterControl != null && ProductUtils.isReadyBoostProg(node.getUniqueId())) {
            // special handling
            switch (boosterControl) {
                case LOCAL:
                    // local generator
                    break;
                default:
                    // only booster
                    LOGGER.info("No local boosterControl available. The command station function is not available.");
                    isCommandStation = false;
                    break;
            }
        }
        else if (ProductUtils.isRFBasisNode(node.getUniqueId())) {
            if (node.getBaseNumber() > 1) {
                LOGGER.info("The current RF base is not a master base.");
                isCommandStation = false;
            }
        }

        setLocoEnabled(isCommandStation, true /* nodeIsSelected */, node);
        setDccAccessoryEnabled(isCommandStation, true /* nodeIsSelected */);

        setDccAdvEnabled(isCommandStation && node.getCommandStationNode().isDccAdvAvailable());

        // must check bit 3 of class
        setLocoCvEnabled(isCommandStation,
            isCommandStation && NodeUtils.hasCommandStationProgrammingFunctions(node.getUniqueId()),
            true /* nodeIsSelected */);
        setIdentifyStateSelected(node.getIdentifyState());
        setBulkSwitchEnabled(NodeUtils.hasSwitchFunctions(node.getUniqueId()));

        boolean hasData = hasExchangeableData(node);
        setImportEnabled(hasData);
        setExportEnabled(hasData);

        generateNodeDefaultLabels.setEnabled(nodeIsSelected);

        if (nodeIsSelected) {
            final String lang = XmlLocaleUtils.getXmlLocaleVendorCV();

            VersionedDefaultNodeLabelsWrapper available =
                wizardLabelWrapper
                    .isDefaultLabelsAvailable(lang, node.getUniqueId(), node.getNode().getSoftwareVersion(),
                        node.getNode().getRelevantPidBits());
            applyNodeDefaultLabels.setEnabled(nodeIsSelected && available != null);
        }
        else {
            applyNodeDefaultLabels.setEnabled(false);
        }

        // the DMX modeler is enabled for OneDMX or ReadyDMX roomlight version only
        boolean isOneDMX =
            ProductUtils.isReadyDMXRoomlight(node.getUniqueId()) || ProductUtils.isOneDMXRoomlight(node.getUniqueId());
        setDmxModelerEnabled(NodeUtils.hasAccessoryFunctions(node.getUniqueId()) && isOneDMX, nodeIsSelected);

        setLocalLogoffEnabled(NodeUtils.isAddressEqual(node.getNode().getAddr(), NodeUtils.ROOT_ADDRESS),
            nodeIsSelected);
    }

    public void setClearErrorEnabled(Boolean isClearErrorEnabled) {
        clearError.setVisible(isClearErrorEnabled != null && isClearErrorEnabled);
        clearError.setEnabled(isClearErrorEnabled != null && isClearErrorEnabled);
    }

    private boolean hasExchangeableData(final NodeInterface node) {
        if (node != null && node.equals(model.getSelectedNode())) {
            boolean hasVendorCV = node.getVendorCV() != null;
            boolean hasFeatures = !node.isBootloaderNode();
            return hasVendorCV || hasFeatures || node.getAccessories().size() > 0 || node.getMacros().size() > 0
                || node.getFeedbackPorts().size() > 0 || NodeUtils.hasSwitchFunctions(node.getUniqueId());
        }
        return false;
    }

    public void setAddressMessagesEnabled(Boolean isAddressMessagesEnabled) {
        addressMessagesEnabled.setVisible(isAddressMessagesEnabled != null);
        addressMessagesEnabled.setSelected(isAddressMessagesEnabled != null && isAddressMessagesEnabled);
    }

    public void setDccStartEnabled(Boolean isDccStartEnabled) {
        dccStartEnabled.setVisible(isDccStartEnabled != null);
        dccStartEnabled.setSelected(isDccStartEnabled != null && isDccStartEnabled);
    }

    public void setExportEnabled(Boolean exportEnabled) {
        exportNode.setEnabled(exportEnabled != null && exportEnabled);
        generateNodeDocumentation.setEnabled(exportEnabled != null && exportEnabled);
    }

    public void setExternalStartEnabled(Boolean isExternalStartEnabled) {
        externalStartEnabled.setVisible(isExternalStartEnabled != null);
        externalStartEnabled.setSelected(isExternalStartEnabled != null && isExternalStartEnabled);
    }

    public void setDccAdvEnabled(Boolean isDccAdvAvailable) {
        boolean isEnabled = isDccAdvAvailable != null && isDccAdvAvailable.booleanValue();
        this.dccAdvAvailable.setEnabled(isEnabled);
        this.dccAdvAvailable.setVisible(isEnabled);
    }

    public void setFeedbackMessagesEnabled(Boolean isFeedbackMessagesEnabled) {
        feedbackMessagesEnabled.setVisible(isFeedbackMessagesEnabled != null);
        feedbackMessagesEnabled.setSelected(isFeedbackMessagesEnabled != null && isFeedbackMessagesEnabled);
    }

    public void setFeedbackMirrorDisabled(Boolean isFeedbackMirrorDisabled) {
        feedbackMirrorDisabled.setVisible(isFeedbackMirrorDisabled != null);
        feedbackMirrorDisabled.setSelected(isFeedbackMirrorDisabled != null && isFeedbackMirrorDisabled);
    }

    public void setFirmwareUpdateEnabled(boolean isFirmwareUpdateEnabled) {
        firmwareUpdate.setEnabled(isFirmwareUpdateEnabled);
    }

    public void setFeaturesEnabled(boolean isFeaturesEnabled) {
        features.setEnabled(isFeaturesEnabled);
    }

    public void setIdentifyStateSelected(IdentifyState identifyState) {
        identify.setSelected(identifyState == IdentifyState.ON);
    }

    public void setDetachedStateSelected(DetachedState detachedState) {

        detachAttachNode.setSelected(detachedState == DetachedState.DETACHED);
    }

    public void setImportEnabled(Boolean importEnabled) {
        importNode.setEnabled(importEnabled != null && importEnabled);
    }

    public void setKeyMessagesEnabled(Boolean isKeyMessagesEnabled) {
        keyMessagesEnabled.setVisible(isKeyMessagesEnabled != null);
        keyMessagesEnabled.setSelected(isKeyMessagesEnabled != null && isKeyMessagesEnabled);
    }

    private void setLocoEnabled(Boolean isLocoEnabled, Boolean nodeIsSelected, final NodeInterface node) {

        long uniqueId = node.getUniqueId();
        loco.setEnabled(isLocoEnabled != null && isLocoEnabled && nodeIsSelected != null && nodeIsSelected);
        loco.setVisible(isLocoEnabled != null && isLocoEnabled);

        if (loco.isVisible()) {
            // change the label
            if (ProductUtils.isRFBasisNode(uniqueId) || ProductUtils.isSpeedometer(uniqueId)) {
                loco.setText(Resources.getString(getClass(), "car") + " ...");
            }
            else {
                loco.setText(Resources.getString(getClass(), "loco") + " ...");
            }
        }

        // locolist
        boolean isLocoListEnabled = false;

        Boolean locoListFeatureAvailable =
            Feature
                .getBitFeatureValue(node.getNode().getFeatures(), FeatureEnum.FEATURE_GEN_EXT_AVAILABLE.getNumber(), 7);
        if (locoListFeatureAvailable == Boolean.TRUE || ProductUtils.isIF2(uniqueId)
            || ProductUtils.isIFnet(uniqueId)) {
            isLocoListEnabled = true;
        }

        locoList
            .setEnabled(isLocoEnabled != null && isLocoEnabled && nodeIsSelected != null && nodeIsSelected
                && isLocoListEnabled);
        locoList.setVisible(isLocoEnabled != null && isLocoEnabled && isLocoListEnabled);
        locoListSeparator.setVisible(isLocoEnabled != null && isLocoEnabled && isLocoListEnabled);
    }

    private void setDccAccessoryEnabled(Boolean isDccAccessoryEnabled, Boolean nodeIsSelected) {
        dccAccessory
            .setEnabled(
                isDccAccessoryEnabled != null && isDccAccessoryEnabled && nodeIsSelected != null && nodeIsSelected);
        dccAccessory.setVisible(isDccAccessoryEnabled != null && isDccAccessoryEnabled);
    }

    private void setLocoCvEnabled(Boolean isDccGenerator, Boolean isLocoCvEnabled, Boolean nodeIsSelected) {

        // TODO find a better solution for this hack ...
        boolean isLocoCvOpened = false;
        if (PtProgrammerController.isOpened()) {
            LOGGER.info("The dialog is already opened.");
            isLocoCvOpened = true;
        }

        // enable the menu items: DCC generator must always support POM
        locoCv.setEnabled(isDccGenerator != null && isDccGenerator && nodeIsSelected != null && nodeIsSelected);
        locoCvPt
            .setEnabled(isLocoCvEnabled != null && isLocoCvEnabled && !isLocoCvOpened && nodeIsSelected != null
                && nodeIsSelected);

        locoCv.setVisible(isDccGenerator != null && isDccGenerator);
        locoCvPt.setVisible(isLocoCvEnabled != null && isLocoCvEnabled);
    }

    private void setDmxModelerEnabled(Boolean isDmxModelerEnabled, Boolean nodeIsSelected) {

        dmxModelerSeparator.setVisible(isDmxModelerEnabled != null && isDmxModelerEnabled);
        dmxModeler
            .setEnabled(isDmxModelerEnabled != null && isDmxModelerEnabled && nodeIsSelected != null && nodeIsSelected);
        dmxModeler.setVisible(isDmxModelerEnabled != null && isDmxModelerEnabled);
    }

    private void setLocalLogoffEnabled(Boolean isRootNode, Boolean nodeIsSelected) {
        detachAttachNode.setEnabled(isRootNode != null && isRootNode && nodeIsSelected != null && nodeIsSelected);
        detachAttachNode.setVisible(isRootNode != null && isRootNode);
    }

    private void setBulkSwitchEnabled(Boolean isBulkSwitchEnabled) {
        boolean isPowerUser = settingsService.getWizardSettings().isPowerUser();

        // show bulk switch operations only for power users
        bulkSwitchNode.setEnabled(isBulkSwitchEnabled);
        bulkSwitchNode.setVisible(isPowerUser);
        bulkSwitchSeparator.setVisible(isPowerUser);
    }
}
