package org.bidib.wizard.mvc.main.view.panel.renderer;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.common.utils.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroListRenderer extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(MacroListRenderer.class);

    private ImageIcon bidibErrorIcon;

    private ImageIcon pendingChangesIcon;

    private ImageIcon savedChangesIcon;

    private ImageIcon permanentlyStoredIcon;

    private ImageIcon notLoadedFromNodeIcon;

    public MacroListRenderer() {
        bidibErrorIcon = ImageUtils.createImageIcon(MacroListRenderer.class, "/icons/error-leaf.png");
        pendingChangesIcon = ImageUtils.createImageIcon(MacroListRenderer.class, "/icons/16x16/write.png");
        savedChangesIcon = ImageUtils.createImageIcon(MacroListRenderer.class, "/icons/16x16/savetonode.png");
        permanentlyStoredIcon = ImageUtils.createImageIcon(MacroListRenderer.class, "/icons/16x16/lock.png");
        notLoadedFromNodeIcon = ImageUtils.createImageIcon(MacroListRenderer.class, "/icons/16x16/loadfromnode.png");
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable list, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        // prepare the default renderer
        Component renderer = super.getTableCellRendererComponent(list, value, isSelected, cellHasFocus, row, column);
        if (value instanceof Macro) {
            Macro macro = (Macro) value;
            if (macro.isContainsError()) {
                LOGGER.info("The current macro contains an error: {}", macro);
                // set the error icon
                setIcon(bidibErrorIcon);
            }
            else {
                switch (macro.getMacroSaveState()) {
                    case NOT_LOADED_FROM_NODE:
                        // set the not loaded from icon
                        setIcon(notLoadedFromNodeIcon);
                        break;
                    case PENDING_CHANGES:
                        // set the pending changes icon
                        setIcon(pendingChangesIcon);
                        break;
                    case SAVED_ON_NODE:
                        setIcon(savedChangesIcon);
                        break;
                    case PERMANENTLY_STORED_ON_NODE:
                        setIcon(permanentlyStoredIcon);
                        break;
                    default:
                        LOGGER.error("Unknown macro save state detected: {}", macro.getMacroSaveState());
                        break;
                }
            }

            String text = null;
            if (StringUtils.isNotBlank(macro.getLabel())) {
                text = String.format("%1$02d : %2$s", macro.getId(), macro.getLabel());
            }
            else if (macro.getId() > -1) {
                text = String.format("%1$02d :", macro.getId());
            }
            else {
                text = " ";
            }

            setText(text);

        }
        return renderer;
    }
}