package org.bidib.wizard.mvc.loco.view.speedo;

import java.lang.reflect.InvocationTargetException;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import org.bidib.wizard.mvc.loco.model.SpeedometerProgBeanModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovePidParamsDialogTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApprovePidParamsDialogTest.class);

    public static void main(String[] args) throws InvocationTargetException, InterruptedException {

        SwingUtilities.invokeAndWait(() -> {

            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | InstantiationException | IllegalAccessException
                | UnsupportedLookAndFeelException ex) {
                LOGGER.warn("Set L&F failed.", ex);
            }

            JFrame frame = new JFrame("Test");

            SpeedometerProgBeanModel speedoProgBeanModel = new SpeedometerProgBeanModel();
            speedoProgBeanModel.setCv61(10);
            speedoProgBeanModel.setCv62(2);
            speedoProgBeanModel.setCv63(2);

            int result = JOptionPane.CANCEL_OPTION;
            ApprovePidParamsDialog dialog = new ApprovePidParamsDialog(frame, speedoProgBeanModel);

            result = dialog.getResult();
            LOGGER.info("Result: {}", result);

            System.exit(0);
        });
    }
}
