/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.booster.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import javax.swing.Timer;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.model.event.NodeStatusEvent;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.client.common.view.statusbar.StatusBarPublisher;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.booster.controller.listener.BoosterTableControllerListener;
import org.bidib.wizard.mvc.booster.model.BoosterModel;
import org.bidib.wizard.mvc.booster.model.BoosterTableModel;
import org.bidib.wizard.mvc.booster.view.BoosterTableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BoosterTableController
implements BoosterTableControllerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterTableController.class);
    private BoosterTableView boosterTableView;
    private BoosterTableModel boosterTableModel;
    private Timer boosterCurrentTimer;
    private static final long CURRENT_UPDATE_TIMEOUT = 3000L;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private BoosterService boosterService;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private StatusBar statusBar;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private ConsoleService consoleService;
    private final DockingDesktop desktop;
    private DockableStateChangeListener dockableStateChangeListener;
    private final Supplier<NodeProvider> nodeProviderSupplier;
    private final NodeListProvider nodeListProvider;
    protected final ScheduledExecutorService serviceWorker;

    public BoosterTableController(DockingDesktop desktop, Supplier<NodeProvider> nodeProviderSupplier, NodeListProvider nodeListProvider) {
        this.desktop = desktop;
        this.nodeProviderSupplier = nodeProviderSupplier;
        this.nodeListProvider = nodeListProvider;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("boosterServiceWorkers-thread-%d").build();
        this.serviceWorker = Executors.newScheduledThreadPool(2, namedThreadFactory);
    }

    public void start() {
        String searchKey = "BoosterTableView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = this.desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing booster table view.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        this.createDockable();
    }

    public Dockable createDockable() {
        LOGGER.info("Create new BoosterTableView.");
        if (this.boosterTableView != null) {
            LOGGER.info("Select the existing booster table view.");
            DockUtils.selectWindow((Dockable)this.boosterTableView);
            return this.boosterTableView;
        }
        this.boosterTableModel = new BoosterTableModel((StatusBarPublisher<String, Integer>)((StatusBarPublisher)(text, duration) -> this.statusBar.setStatusText(text, duration.intValue())), this.consoleService);
        this.boosterTableView = new BoosterTableView(this, this.boosterTableModel);
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (this.desktop.getDockables().length > 1) {
            DockableState consoleView = null;
            for (DockableState dockable : dockables) {
                if (DockKeys.DOCKKEY_CONSOLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) {
                    LOGGER.info("Found the console view dockable.");
                    consoleView = dockable;
                    break;
                }
                if (!DockKeys.DOCKKEY_DEBUG_CONSOLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the debug console view dockable.");
                consoleView = dockable;
                break;
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (consoleView != null) {
                LOGGER.info("Add the booster table view to the console view panel.");
                dock = consoleView.getDockable();
                int order = 0;
                LOGGER.info("Add new booster table at order: {}", (Object)order);
                this.desktop.createTab(dock, (Dockable)this.boosterTableView, order, true);
                TabbedDockableContainer baseTab = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                baseTab.removeDockable((Dockable)this.boosterTableView);
                baseTab.addDockable((Dockable)this.boosterTableView, order);
                baseTab.setSelectedDockable((Dockable)this.boosterTableView);
            } else if (this.desktop.getDockables().length > 1) {
                this.desktop.split(dock, (Dockable)this.boosterTableView, DockingConstants.SPLIT_BOTTOM);
                this.desktop.setDockableHeight((Dockable)this.boosterTableView, 0.2);
            } else {
                this.desktop.split(dock, (Dockable)this.boosterTableView, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            this.desktop.addDockable((Dockable)this.boosterTableView, RelativeDockablePosition.RIGHT);
        }
        DefaultNodeListListener nodeListListener = new DefaultNodeListListener(){

            public void listNodeAdded(NodeInterface node) {
                LOGGER.info("The nodelist has a new node: {}", (Object)node);
                BoosterTableController.this.nodeNew(node);
            }

            public void listNodeRemoved(NodeInterface node) {
                LOGGER.info("The nodelist has a node removed: {}", (Object)node);
                BoosterTableController.this.nodeLost(node);
            }
        };
        this.nodeListProvider.addNodeListListener((NodeListListener)nodeListListener);
        try {
            Collection nodes;
            this.connectionService.subscribeConnectionStatusChanges(connectionInfo -> {
                if (connectionInfo.getConnectionId().equals("main")) {
                    LOGGER.info("Current state: {}", (Object)connectionInfo.getConnectionState());
                    switch (connectionInfo.getConnectionState().getActualPhase()) {
                        case CONNECTED: {
                            LOGGER.info("The communication was opened.");
                            break;
                        }
                        case DISCONNECTED: {
                            LOGGER.info("The communication was closed.");
                            LinkedList<BoosterModel> boosters = new LinkedList<BoosterModel>(this.boosterTableModel.getBoosters());
                            for (BoosterModel booster : boosters) {
                                SwingUtils.executeInEDT(() -> this.boosterTableModel.removeBooster(booster.getBooster()));
                            }
                            break;
                        }
                    }
                }
            }, error -> LOGGER.warn("The connection status change caused an error.", error));
            NodeProvider nodeProvider = this.nodeProviderSupplier.get();
            if (nodeProvider != null && CollectionUtils.isNotEmpty((Collection)(nodes = nodeProvider.getNodes()))) {
                for (NodeInterface node : nodes) {
                    LOGGER.info("Initially add node.");
                    this.nodeNew(node);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Register controller as connection status listener failed.", (Throwable)ex);
        }
        this.dockableStateChangeListener = new DockableStateChangeListener(){
            final /* synthetic */ NodeListListener val$nodeListListener;
            {
                this.val$nodeListListener = nodeListListener;
            }

            public void dockableStateChanged(DockableStateChangeEvent event) {
                if (event.getNewState().getDockable().equals((Object)BoosterTableController.this.boosterTableView) && event.getNewState().isClosed()) {
                    LOGGER.info("BoosterTableView was closed, free resources.");
                    try {
                        BoosterTableController.this.desktop.removeDockableStateChangeListener(BoosterTableController.this.dockableStateChangeListener);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Remove dockableStateChangeListener from desktop failed: " + String.valueOf(BoosterTableController.this.dockableStateChangeListener), (Throwable)ex);
                    }
                    finally {
                        BoosterTableController.this.dockableStateChangeListener = null;
                    }
                    try {
                        if (this.val$nodeListListener != null) {
                            BoosterTableController.this.nodeListProvider.removeNodeListListener(this.val$nodeListListener);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Unregister controller as node listener failed.", (Throwable)ex);
                    }
                    if (BoosterTableController.this.boosterCurrentTimer != null) {
                        LOGGER.info("Stop the booster current timer.");
                        BoosterTableController.this.boosterCurrentTimer.stop();
                        BoosterTableController.this.boosterCurrentTimer = null;
                    }
                    BoosterTableController.this.boosterTableView = null;
                }
            }
        };
        this.desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
        try {
            this.boosterCurrentTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.trace("The booster current timer has elapsed.");
                    long now = System.currentTimeMillis();
                    try {
                        List<BoosterModel> boosters = BoosterTableController.this.boosterTableModel.getBoosters();
                        for (BoosterModel boosterModel : boosters) {
                            Integer current = boosterModel.getCurrent();
                            if (current == null || current <= 0 || boosterModel.getLastCurrentUpdate() >= now - 3000L) continue;
                            LOGGER.info("the current value is outdated -> clear the value, booster: {}", (Object)boosterModel);
                            BoosterTableController.this.boosterTableModel.setBoosterCurrent(boosterModel.getBooster(), null, null);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Clear the outdated booster current value failed.", (Throwable)ex);
                    }
                }
            });
            this.boosterCurrentTimer.setCoalesce(true);
            this.boosterCurrentTimer.start();
        }
        catch (Exception ex) {
            LOGGER.warn("Start the booster current timer failed.", (Throwable)ex);
        }
        return this.boosterTableView;
    }

    private void nodeLost(NodeInterface node) {
        if (NodeUtils.hasBoosterFunctions((long)node.getUniqueId()) || NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) {
            LOGGER.info("Remove booster from model: {}", (Object)node);
            SwingUtils.executeInEDT(() -> this.boosterTableModel.removeBooster(node));
        }
    }

    private void nodeNew(NodeInterface node) {
        if (NodeUtils.hasBoosterFunctions((long)node.getUniqueId()) || NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) {
            LOGGER.info("New booster in system detected: {}", (Object)node);
            SwingUtils.executeInEDT(() -> this.internalNewNode(node));
        }
    }

    private void internalNewNode(NodeInterface node) {
        LOGGER.info("Add new booster to table: {}", (Object)node);
        this.boosterTableModel.addBooster(node, this.wizardLabelWrapper);
        if (NodeStatusEvent.StatusIdentifier.InitialLoadPending == node.getNodeLoadStatusIdentifier()) {
            LOGGER.info("The initial load of the booster node is still pending. Skip fetch booster state for node: {}", (Object)node);
            return;
        }
        this.fetchBoosterState(node);
    }

    private void fetchBoosterState(NodeInterface node) {
        LOGGER.info("Fetch the booster state.");
        try {
            if (NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) {
                this.boosterTableModel.triggerFetchBoosterMaxCurrent(node);
                this.serviceWorker.submit(() -> this.boosterService.queryBoosterState("main", node.getBoosterNode()));
            }
            if (NodeUtils.hasCommandStationFunctions((long)node.getUniqueId()) && node.getCommandStationNode() != null) {
                this.serviceWorker.submit(() -> this.commandStationService.queryCommandStationState("main", node.getCommandStationNode()));
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get the booster and command station state failed.", (Throwable)ex);
        }
    }

    @Override
    public void setBoosterState(NodeInterface node, BoosterStatus boosterStatus) {
        LOGGER.info("Set the booster status, node: {}, boosterStatus: {}", (Object)node, (Object)boosterStatus);
        try {
            if (node.getBoosterNode() != null) {
                this.boosterService.setBoosterState("main", node.getBoosterNode(), boosterStatus);
            } else {
                this.boosterService.setBoosterState("main", node.getInterfaceNode(), boosterStatus);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Set the booster status failed.", (Throwable)ex);
        }
    }

    @Override
    public void setCommandStationState(NodeInterface node, CommandStationState csStatus) {
        LOGGER.info("Set the command station status, node: {}, csStatus: {}", (Object)node, (Object)csStatus);
        try {
            this.commandStationService.setCommandStationState("main", node.getCommandStationNode(), CommandStationStatus.valueOf((CommandStationState)csStatus));
        }
        catch (Exception ex) {
            LOGGER.warn("Set the command station status failed.", (Throwable)ex);
        }
    }
}

