/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.converter;

import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.common.base.Preconditions;
import java.text.Format;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalculatingConverter
implements BindingConverter<Integer, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculatingConverter.class);
    private final Format format;
    private final Function<Integer, Integer> calc;

    public CalculatingConverter(Format format, Function<Integer, Integer> calc) {
        this.format = (Format)Preconditions.checkNotNull((Object)format, (String)"The format must not be null.");
        this.calc = calc;
    }

    public String targetValue(Integer sourceValue) {
        if (sourceValue != null) {
            if (this.calc != null) {
                sourceValue = this.calc.apply(sourceValue);
            }
            return this.format.format(sourceValue);
        }
        return null;
    }

    public Integer sourceValue(String targetValue) {
        try {
            if (StringUtils.isNotBlank((CharSequence)targetValue)) {
                return Integer.valueOf(targetValue);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Cannot parse the target value {}", (Object)targetValue);
        }
        return null;
    }
}

