/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.error.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.LinkedList;
import org.bidib.wizard.mvc.error.model.listener.ErrorListener;

public class ErrorModel {
    private final Collection<ErrorListener> errorListeners = new LinkedList<ErrorListener>();
    private Throwable error;
    private String stackTrace = " ";
    private final Object errorLock = new Object();

    public void addErrorListener(ErrorListener l) {
        this.errorListeners.add(l);
    }

    private void fireErrorChanged(String errorMessage, String stackTrace) {
        for (ErrorListener l : this.errorListeners) {
            l.errorChanged(errorMessage, stackTrace);
        }
    }

    public Throwable getError() {
        return this.error;
    }

    public String getStackTrace(Throwable throwable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        throwable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(Throwable error) {
        Object object = this.errorLock;
        synchronized (object) {
            this.error = error;
            String errorStackTrace = this.getStackTrace(error);
            if (errorStackTrace != null && !errorStackTrace.equals(this.stackTrace) || errorStackTrace == null && this.stackTrace != null) {
                this.stackTrace = errorStackTrace;
                Throwable cause = error.getCause();
                this.fireErrorChanged(cause != null ? cause.toString() : error.toString(), errorStackTrace);
            }
        }
    }

    public void resetStackTrace() {
        this.stackTrace = null;
    }
}

