/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.features.view.panel;

import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.TableStyleProvider;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.mvc.features.model.FeaturesModel;
import org.bidib.wizard.mvc.features.model.listener.FeatureListener;
import org.bidib.wizard.mvc.features.view.panel.FeatureAwareEditor;
import org.bidib.wizard.mvc.features.view.panel.FeatureAwareRenderer;
import org.bidib.wizard.mvc.features.view.panel.FeatureTableModel;
import org.bidib.wizard.mvc.features.view.panel.listener.FeaturesWriteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesPanel.class);
    private final Set<FeaturesWriteListener> listeners = new LinkedHashSet<FeaturesWriteListener>();
    private FeatureTableModel featureTableModel;
    private AbstractEmptyTable table;
    private final FeaturesModel model;
    int featuresAdded = 0;

    public FeaturesPanel(FeaturesModel model) {
        this.model = model;
        this.featureTableModel = new FeatureTableModel();
        this.table = new AbstractEmptyTable(this.featureTableModel, Resources.getString(FeaturesPanel.class, (String)"emptyTable")){
            private static final long serialVersionUID = 1L;
        };
        this.table.getColumnModel().getColumn(3).setCellEditor(new FeatureAwareEditor());
        this.table.getColumnModel().getColumn(3).setCellRenderer(new FeatureAwareRenderer());
        RowStripeTableStyleProvider tableStyleProvider = new RowStripeTableStyleProvider(new Color[]{UIManager.getColor("tableRowStripe.background"), UIManager.getColor("tableRowStripe.alternativeBackground")});
        this.table.setTableStyleProvider((TableStyleProvider)tableStyleProvider);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.table.adjustRowHeight();
        this.add((Component)this.table);
        model.addFeatureListener(new FeatureListener(){

            @Override
            public void featureChanged(Feature feature) {
                LOGGER.debug("The following feature has changed: {}", (Object)feature);
                FeaturesPanel.this.showFeature(feature);
            }

            @Override
            public void featuresChanged() {
                LOGGER.info("The features have changed.");
            }
        });
        this.table.sortColumn(1);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(400);
        this.showFeatures(model.getFeatures());
    }

    public void addFeaturesWriteListener(FeaturesWriteListener listener) {
        this.listeners.add(listener);
    }

    public void showFeatures(Collection<Feature> features) {
        LOGGER.debug("Show features: {}", features);
        this.featureTableModel.clear();
        for (Feature feature : features) {
            LOGGER.debug("Add feature: {}", (Object)feature);
            this.showFeature(feature);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    private void showFeature(Feature feature) {
        LOGGER.debug("Show feature: {}", (Object)feature);
        this.featureTableModel.updateRow(feature);
    }

    public void writeFeatures() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        List<Feature> features = this.featureTableModel.getFeatures();
        Collection<Feature> featuresToWrite = this.model.prepareUpdateFeatures(features);
        this.fireWrite(featuresToWrite);
        this.model.setFeatures(featuresToWrite);
    }

    private void fireWrite(Collection<Feature> features) {
        for (FeaturesWriteListener l : this.listeners) {
            l.write(features);
        }
    }
}

