/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.model.command;

import io.reactivex.rxjava3.core.SingleObserver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Timer;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.jbidibc.messages.utils.CollectionUtils;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.mvc.loco.model.SpeedometerProgBeanModel;
import org.bidib.wizard.mvc.loco.view.PomProgrammerRequestListener;
import org.bidib.wizard.mvc.loco.view.command.PomProgResultListener;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomOperationCommand;
import org.bidib.wizard.mvc.pom.model.command.PomOperationContinueAfterTimeoutCommand;
import org.bidib.wizard.mvc.pom.model.command.PomOperationIfElseCommand;
import org.bidib.wizard.mvc.pom.model.listener.ProgCommandListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomRequestProcessor<M extends ProgCommandAwareBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomRequestProcessor.class);
    public static final int DEFAULT_TIMEOUT = 1000;
    private int timeout = 1000;
    private final SpeedometerProgBeanModel speedoProgBeanModel;
    private final PomProgrammerModel cvProgrammerModel;
    private final PomProgrammerRequestListener pomProgrammerRequestListener;
    private final PomProgResultListener pomProgResultListener;
    private Timer readTimeout;
    private Object readTimeoutLock = new Object();
    private final SettingsService settingsService;

    public PomRequestProcessor(SpeedometerProgBeanModel speedoProgBeanModel, PomProgrammerModel cvProgrammerModel, PomProgrammerRequestListener pomProgrammerRequestListener, PomProgResultListener pomProgResultListener, SettingsService settingsService) {
        this.speedoProgBeanModel = speedoProgBeanModel;
        this.cvProgrammerModel = cvProgrammerModel;
        this.pomProgrammerRequestListener = pomProgrammerRequestListener;
        this.pomProgResultListener = pomProgResultListener;
        this.settingsService = settingsService;
    }

    public void submitProgCommands(List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> pomProgCommands, SingleObserver<String> finishAction) {
        LOGGER.info("Submit the new commands for execution: {}", pomProgCommands);
        List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = this.speedoProgBeanModel.getProgCommands();
        progCommands.clear();
        progCommands.addAll(pomProgCommands);
        LOGGER.info("Set the finish action in the speedoProgBeanModel: {}", finishAction);
        this.speedoProgBeanModel.setFinishAction(finishAction);
        this.speedoProgBeanModel.getExecutedProgCommands().clear();
        this.timeout = this.settingsService.getExperimentalSettings().getSpeedometerTimeout();
        LOGGER.info("Current value of speedometer timeout: {}", (Object)this.timeout);
        this.startTimeoutControl(this.timeout);
        this.fireNextCommand();
    }

    protected void sendRequest(PomAddressData decoderAddress, PomOperation operation, int cvNumber, int cvValue) {
        LOGGER.info("Send the POM request, cvNumber: {}, cvValue: {}", (Object)cvNumber, (Object)cvValue);
        this.cvProgrammerModel.setCvNumber(cvNumber);
        this.cvProgrammerModel.setCvValue(null);
        this.cvProgrammerModel.setPomProgState(PomProgState.POM_PROG_START);
        this.pomProgrammerRequestListener.sendRequest(decoderAddress, operation, cvNumber, cvValue);
    }

    protected void fireNextCommand() {
        this.pomProgResultListener.disableInputElements();
        List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = this.speedoProgBeanModel.getProgCommands();
        LOGGER.info("Prepared commands for addressing the decoder: {}", progCommands);
        PomOperationCommand<? extends ProgCommandAwareBeanModel> progCommand = progCommands.remove(0);
        this.speedoProgBeanModel.setCurrentOperation(progCommand.getPomOperation());
        LOGGER.info("Updated current operation: {}", (Object)this.speedoProgBeanModel.getCurrentOperation());
        switch (progCommand.getPomOperation()) {
            case WR_BIT: 
            case WR_BYTE: {
                this.speedoProgBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.WRITE);
                break;
            }
            default: {
                this.speedoProgBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.READ);
            }
        }
        this.speedoProgBeanModel.setExecutingProgCommand(progCommand);
        this.publishLogText("Prog write request: {}", progCommand);
        this.sendRequest(progCommand.getDecoderAddress(), progCommand.getPomOperation(), progCommand.getCvNumber(), progCommand.getCvValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTimeoutControl(final int timeout) {
        LOGGER.info("Timeout control is started, timeout: {}.", (Object)timeout);
        Object object = this.readTimeoutLock;
        synchronized (object) {
            if (this.readTimeout != null) {
                LOGGER.info("The timeout control is already assigned: {}", (Object)this.readTimeout);
                if (this.readTimeout.isRunning()) {
                    LOGGER.info("The timeout control is already running and will be stopped.");
                    this.readTimeout.stop();
                }
                this.readTimeout = null;
            }
            this.readTimeout = new Timer(timeout, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.warn("Timeout control has expired. Current executing command: {}", PomRequestProcessor.this.speedoProgBeanModel.getExecutingProgCommand());
                    PomRequestProcessor.this.publishLogText("Timeout control has expired. No answer from decoder received.", new Object[0]);
                    PomOperationCommand<? extends ProgCommandAwareBeanModel> currentExecutingProgCommand = PomRequestProcessor.this.speedoProgBeanModel.getExecutingProgCommand();
                    if (currentExecutingProgCommand != null && currentExecutingProgCommand.decrementRetryCount() > -1) {
                        List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = PomRequestProcessor.this.speedoProgBeanModel.getProgCommands();
                        LOGGER.info("Add current executing command at head: {}", currentExecutingProgCommand);
                        progCommands.add(0, currentExecutingProgCommand);
                    }
                    if (CollectionUtils.hasElements(PomRequestProcessor.this.speedoProgBeanModel.getProgCommands())) {
                        LOGGER.info("Prepare the next command to send.");
                        PomRequestProcessor.this.startTimeoutControl(timeout);
                        PomRequestProcessor.this.fireNextCommand();
                    } else if (PomRequestProcessor.this.speedoProgBeanModel.getExecutingProgCommand() instanceof PomOperationIfElseCommand) {
                        boolean ignoreError = false;
                        PomOperationCommand<? extends ProgCommandAwareBeanModel> executingProgCommand = PomRequestProcessor.this.speedoProgBeanModel.getExecutingProgCommand();
                        LOGGER.info("The executingProgCommand: {}", executingProgCommand);
                        if (executingProgCommand instanceof PomOperationIfElseCommand) {
                            PomOperationIfElseCommand ifElseCommand = (PomOperationIfElseCommand)executingProgCommand;
                            LOGGER.info("The executing command is a if-else-command: {}", (Object)ifElseCommand);
                            List failureCommands = ifElseCommand.getProgCommandsFailure();
                            if (CollectionUtils.hasElements(failureCommands)) {
                                LOGGER.info("Found failure commands to be executed: {}", failureCommands);
                                if (failureCommands.get(0) instanceof PomOperationContinueAfterTimeoutCommand) {
                                    LOGGER.info("The first failure command is a PomOperationContinueAfterTimeoutCommand. This is no error, we can proceed.");
                                    List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = PomRequestProcessor.this.speedoProgBeanModel.getProgCommands();
                                    progCommands.clear();
                                    progCommands.addAll(failureCommands);
                                    ignoreError = true;
                                }
                            }
                        }
                        if (!ignoreError) {
                            LOGGER.info("No more commands to send, enable the input elements.");
                            PomRequestProcessor.this.cvProgrammerModel.setPomProgState(PomProgState.POM_PROG_NO_ANSWER);
                            SingleObserver<String> finishAction = PomRequestProcessor.this.speedoProgBeanModel.getFinishAction();
                            if (finishAction != null) {
                                finishAction.onError(null);
                            }
                        } else {
                            LOGGER.info("Start the timeout control and fire the next command.");
                            PomRequestProcessor.this.startTimeoutControl(timeout);
                            PomRequestProcessor.this.fireNextCommand();
                        }
                    } else {
                        LOGGER.info("Timeout expired. No more commands to send, enable the input elements.");
                        PomRequestProcessor.this.cvProgrammerModel.setPomProgState(PomProgState.POM_PROG_NO_ANSWER);
                        SingleObserver<String> finishAction = PomRequestProcessor.this.speedoProgBeanModel.getFinishAction();
                        if (finishAction != null) {
                            finishAction.onError(null);
                        }
                    }
                }
            });
            this.readTimeout.setRepeats(false);
            this.readTimeout.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTimeoutControl() {
        LOGGER.info("Timeout control is stopped.");
        Object object = this.readTimeoutLock;
        synchronized (object) {
            if (this.readTimeout != null) {
                LOGGER.info("The timeout control is assigned and will be stopped: {}", (Object)this.readTimeout);
                this.readTimeout.stop();
                this.readTimeout = null;
            }
        }
    }

    private void publishLogText(String logLine, Object ... args) {
        this.pomProgResultListener.addLogText(logLine, args);
    }

    public void addPomProgrammerModelListeners() {
        LOGGER.info("Add the pom programmer model listeners.");
        this.cvProgrammerModel.addProgCommandListener(new ProgCommandListener(){

            @Override
            public void progPomFinished(PomProgState pomProgState) {
                LOGGER.info("The prog command has finished, pomProgState: {}", (Object)pomProgState);
                if (!PomProgState.POM_PROG_START.equals((Object)pomProgState) && !PomProgState.POM_PROG_RUNNING.equals((Object)pomProgState)) {
                    PomOperationCommand<? extends ProgCommandAwareBeanModel> executingProgCommand = PomRequestProcessor.this.speedoProgBeanModel.getExecutingProgCommand();
                    if (executingProgCommand != null) {
                        LOGGER.info("The executingProgCommand: {}", executingProgCommand);
                        executingProgCommand.setProgStateResult(pomProgState);
                        boolean ignoreError = false;
                        if (executingProgCommand instanceof PomOperationIfElseCommand) {
                            PomOperationIfElseCommand ifElseCommand = (PomOperationIfElseCommand)executingProgCommand;
                            LOGGER.info("The executing command is a if-else-command: {}", (Object)ifElseCommand);
                            if (!PomProgState.POM_PROG_OKAY.equals((Object)ifElseCommand.getProgStateResult()) || !ifElseCommand.isExpectedResult()) {
                                LOGGER.info("The command was not successful executed or expected result was not received!");
                                List failureCommands = ifElseCommand.getProgCommandsFailure();
                                if (CollectionUtils.hasElements(failureCommands)) {
                                    LOGGER.info("Found failure commands to be executed: {}", failureCommands);
                                    List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = PomRequestProcessor.this.speedoProgBeanModel.getProgCommands();
                                    progCommands.clear();
                                    progCommands.addAll(failureCommands);
                                    ignoreError = true;
                                }
                            } else {
                                LOGGER.info("The command was successful executed!");
                                List successCommands = ifElseCommand.getProgCommandsSuccess();
                                if (CollectionUtils.hasElements(successCommands)) {
                                    LOGGER.info("Found success commands to be executed: {}", successCommands);
                                    List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = PomRequestProcessor.this.speedoProgBeanModel.getProgCommands();
                                    progCommands.clear();
                                    progCommands.addAll(successCommands);
                                }
                            }
                        }
                        if (PomProgState.POM_PROG_OKAY.equals((Object)executingProgCommand.getProgStateResult())) {
                            LOGGER.info("PostExecute the command. This will set the value in the speedoProgBeanModel, command: {}", executingProgCommand);
                            executingProgCommand.postExecute(PomRequestProcessor.this.speedoProgBeanModel);
                        } else if (!ignoreError) {
                            LOGGER.warn("Clear remaining prog commands because command has finished with an error: {}", executingProgCommand);
                            if (CollectionUtils.hasElements(PomRequestProcessor.this.speedoProgBeanModel.getProgCommands())) {
                                PomRequestProcessor.this.speedoProgBeanModel.getProgCommands().clear();
                            }
                            PomRequestProcessor.this.publishLogText("Error detected. Please try again.", new Object[0]);
                        }
                        PomRequestProcessor.this.speedoProgBeanModel.getExecutedProgCommands().add(executingProgCommand);
                        executingProgCommand = null;
                    }
                    if (CollectionUtils.hasElements(PomRequestProcessor.this.speedoProgBeanModel.getProgCommands())) {
                        LOGGER.info("Prepare the next command.");
                        PomRequestProcessor.this.startTimeoutControl(PomRequestProcessor.this.timeout);
                        LOGGER.info("Fire the next command.");
                        PomRequestProcessor.this.fireNextCommand();
                    } else {
                        LOGGER.info("No more commands to send, enable the input elements.");
                        PomRequestProcessor.this.stopTimeoutControl();
                        PomRequestProcessor.this.pomProgResultListener.enableInputElements();
                        SingleObserver<String> finishAction = PomRequestProcessor.this.speedoProgBeanModel.getFinishAction();
                        LOGGER.info("Registered finish action: {}", finishAction);
                        if (finishAction != null) {
                            LOGGER.info("Call the finish action.");
                            finishAction.onSuccess(null);
                        }
                    }
                }
            }
        });
        this.cvProgrammerModel.addPropertyChangeListener("cvValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                block8: {
                    block7: {
                        LOGGER.info("The CV value has been changed: {}, currentOperation: {}", evt.getNewValue(), (Object)PomRequestProcessor.this.speedoProgBeanModel.getCurrentOperation());
                        if (PomRequestProcessor.this.speedoProgBeanModel.getCurrentOperation() == null) break block7;
                        switch (PomRequestProcessor.this.speedoProgBeanModel.getCurrentOperation()) {
                            case RD_BIT: 
                            case RD_BYTE: {
                                PomOperationCommand<? extends ProgCommandAwareBeanModel> progCommand = PomRequestProcessor.this.speedoProgBeanModel.getExecutingProgCommand();
                                progCommand.setCvValueResult((Integer)evt.getNewValue());
                                if (evt.getNewValue() != null) {
                                    PomRequestProcessor.this.publishLogText("Read operation returned: {}", progCommand.getCvValueResult());
                                    break;
                                }
                                break block8;
                            }
                            case WR_BYTE: {
                                PomOperationCommand<? extends ProgCommandAwareBeanModel> progCommand = PomRequestProcessor.this.speedoProgBeanModel.getExecutingProgCommand();
                                progCommand.setCvValueResult((Integer)evt.getNewValue());
                                if (evt.getNewValue() != null) {
                                    PomRequestProcessor.this.publishLogText("Write operation returned: {}", progCommand.getCvValueResult());
                                    break;
                                }
                                break block8;
                            }
                            case WR_BIT: {
                                break;
                            }
                        }
                        break block8;
                    }
                    LOGGER.info("No operation performed.");
                }
            }
        });
    }
}

