/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.view;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.table.PortValidationResultModel;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.dmx.client.view.scenery.tree.AbstractValidationDialog;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoEditDialog
extends AbstractValidationDialog<LocoListModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoEditDialog.class);
    private static final long serialVersionUID = 1L;
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, max(pref;100dlu)";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private final JButton cancelButton = new JButton(Resources.getString(LocoEditDialog.class, (String)"cancel"));
    private final JButton applyButton = new JButton(Resources.getString(LocoEditDialog.class, (String)"apply"));
    private final LocoListModel locoModel;
    private ValueModel locoAddressValueModel;

    public LocoEditDialog(Frame frame, String title, LocoListModel locoModel) {
        super(frame, title, false);
        this.locoModel = locoModel;
    }

    private JPanel createPanel() {
        FormBuilder builder = null;
        boolean debug = false;
        builder = debug ? FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)new FormDebugPanel()) : FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel(new JPanel());
        builder.border((Border)Paddings.TABBED_DIALOG);
        this.trigger = new Trigger();
        this.presentationModel = new PresentationModel((Object)this.locoModel, (ValueModel)this.trigger);
        this.validationResultModel = new PortValidationResultModel();
        int row = 1;
        this.locoAddressValueModel = this.presentationModel.getBufferedModel("address");
        ConverterValueModel locoAddressConverterModel = new ConverterValueModel(this.locoAddressValueModel, (BindingConverter)new StringToIntegerConverter());
        builder.add(Resources.getString(LocoEditDialog.class, (String)"address"), new Object[0]).xy(1, row);
        JTextField locoAddress = WizardComponentFactory.createTextField((ValueModel)locoAddressConverterModel, (boolean)false);
        locoAddress.setEditable(false);
        builder.add((Component)locoAddress).xy(3, row);
        BufferedValueModel locoNameValueModel = this.presentationModel.getBufferedModel("locoName");
        builder.add(Resources.getString(LocoEditDialog.class, (String)"name"), new Object[0]).xy(1, row += 2);
        JTextField locoName = WizardComponentFactory.createTextField((ValueModel)locoNameValueModel, (boolean)false);
        builder.add((Component)locoName).xy(3, row);
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.applyButton, this.cancelButton}).build();
        builder.add((Component)buttons).xyw(1, row += 2, 3);
        this.applyButton.setEnabled(this.getApplyButtonEnabled().getValue() == Boolean.TRUE);
        PropertyConnector.connect((Object)this.getApplyButtonEnabled(), (String)"value", (Object)this.applyButton, (String)"enabled");
        locoNameValueModel.addValueChangeListener(evt -> this.triggerValidation());
        JPanel contentPanel = builder.build();
        LOGGER.debug("Create iconfeedback panel.");
        IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.validationResultModel, (JComponent)contentPanel);
        FormBuilder feedbackBuilder = FormBuilder.create().columns("pref:grow", new Object[0]).rows("fill:pref:grow", new Object[0]);
        feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
        JPanel dialogContent = feedbackBuilder.build();
        this.triggerValidation();
        return dialogContent;
    }

    protected void performCancelAction(KeyEvent e) {
        if (this.isDirty()) {
            LOGGER.warn("The model is dirty. Ask user if he want's to cancel.");
        }
        this.setVisible(false);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog(Consumer<LocoListModel> saveConsumer) {
        this.add(this.createPanel(), "Center");
        this.applyButton.addActionListener(evt -> {
            LocoListModel locoModel = (LocoListModel)this.getPresentationModel().getBean();
            if (this.trigger != null) {
                this.trigger.triggerCommit();
            }
            LOGGER.info("Prepared the locoModel: {}", (Object)locoModel);
            saveConsumer.accept(locoModel);
            this.close();
        });
        this.cancelButton.addActionListener(evt -> this.close());
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    protected ValidationResult validatePanel() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.getPresentationModel(), "validation");
        if (this.locoAddressValueModel.getValue() == null || StringUtils.isBlank((CharSequence)this.locoAddressValueModel.getValue().toString())) {
            support.addError("address_key", "not_empty");
        }
        ValidationResult validationResult = support.getResult();
        return validationResult;
    }
}

