/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.BoosterStatusListener;
import org.bidib.wizard.api.model.listener.CommandStationStatusListener;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.BoosterPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.StatusListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BoosterPanelController
extends DefaultNodeListListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterPanelController.class);
    private final MainModel mainModel;
    private BoosterPanel boosterPanel;
    private Timer boosterCurrentTimer;
    private NodeInterface selectedNode;
    private final BoosterStatusListener boosterStatusListener;
    private final CommandStationStatusListener commandStationStatusListener;
    @Autowired
    private BoosterService boosterService;
    @Autowired
    private CommandStationService commandStationService;
    private static final long CURRENT_UPDATE_TIMEOUT = 3000L;

    public BoosterPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.boosterStatusListener = new BoosterStatusListener(){

            public void currentChanged(NodeInterface node, final Integer current, final long timestamp) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.internalCurrentChanged(current, timestamp);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.internalCurrentChanged(current, timestamp);
                        }
                    });
                }
            }

            private void internalCurrentChanged(Integer current, long timestamp) {
                if (BoosterPanelController.this.boosterPanel != null) {
                    BoosterPanelController.this.boosterPanel.boosterCurrentChanged(current, timestamp);
                }
            }

            public void maximumCurrentChanged(NodeInterface node, final Integer maximumCurrent) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.internalMaximumCurrentChanged(maximumCurrent);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.internalMaximumCurrentChanged(maximumCurrent);
                        }
                    });
                }
            }

            private void internalMaximumCurrentChanged(Integer maximumCurrent) {
                if (BoosterPanelController.this.boosterPanel != null) {
                    BoosterPanelController.this.boosterPanel.boosterMaximumCurrentChanged(maximumCurrent);
                }
            }

            public void stateChanged(NodeInterface node, final BoosterStatus status) {
                LOGGER.info("The booster state has changed: {}", (Object)status);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.internalStateChanged(status);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.internalStateChanged(status);
                        }
                    });
                }
            }

            private void internalStateChanged(BoosterStatus status) {
                LOGGER.info("Status of booster has changed: {}", (Object)status);
                if (BoosterPanelController.this.boosterPanel != null) {
                    BoosterPanelController.this.boosterPanel.boosterStateChanged(status);
                }
            }

            public void temperatureChanged(NodeInterface node, final Integer temperature) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.internalTemperatureChanged(temperature);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.internalTemperatureChanged(temperature);
                        }
                    });
                }
            }

            private void internalTemperatureChanged(Integer temperature) {
                if (BoosterPanelController.this.boosterPanel != null) {
                    BoosterPanelController.this.boosterPanel.temperatureChanged(temperature);
                }
            }

            public void voltageChanged(NodeInterface node, final Integer voltage) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.internalVoltageChanged(voltage);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.internalVoltageChanged(voltage);
                        }
                    });
                }
            }

            private void internalVoltageChanged(Integer voltage) {
                if (BoosterPanelController.this.boosterPanel != null) {
                    BoosterPanelController.this.boosterPanel.voltageChanged(voltage);
                }
            }

            public void controlChanged(NodeInterface node, BoosterControl control) {
            }
        };
        this.commandStationStatusListener = new CommandStationStatusListener(){

            public void statusChanged(final NodeInterface node, final CommandStationStatus status) {
                LOGGER.debug("The command station status has changed, node: {}, status: {}", (Object)node, (Object)status);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.internalStateChanged(node, status);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.internalStateChanged(node, status);
                        }
                    });
                }
            }

            private void internalStateChanged(NodeInterface node, CommandStationStatus status) {
                LOGGER.debug("Status of command station has changed: {}", (Object)status);
                if (BoosterPanelController.this.boosterPanel != null && node.equals((Object)BoosterPanelController.this.selectedNode)) {
                    BoosterPanelController.this.boosterPanel.commandStationStatusChanged(status);
                }
            }
        };
    }

    public BoosterPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        LOGGER.info("Create new booster panel.");
        BoosterPanel boosterPanel = new BoosterPanel(this.mainModel);
        boosterPanel.addStatusListener(new StatusListener(){

            @Override
            public void switchedOff() {
                NodeInterface node = BoosterPanelController.this.mainModel.getSelectedNode();
                BoosterPanelController.this.boosterService.setBoosterState("main", node.getBoosterNode(), BoosterStatus.OFF);
            }

            @Override
            public void switchedOn() {
                NodeInterface node = BoosterPanelController.this.mainModel.getSelectedNode();
                BoosterPanelController.this.boosterService.setBoosterState("main", node.getBoosterNode(), BoosterStatus.ON);
            }

            @Override
            public void queryBoosterState() {
                NodeInterface node = BoosterPanelController.this.mainModel.getSelectedNode();
                BoosterPanelController.this.boosterService.queryBoosterState("main", node.getBoosterNode());
            }

            @Override
            public void switchedCommandStationOn(boolean ignoreWatchDog) {
                LOGGER.info("Switch command station on, ignoreWatchDog: {}", (Object)ignoreWatchDog);
                this.setCommandStationState(ignoreWatchDog ? CommandStationStatus.GO_IGN_WD : CommandStationStatus.GO);
            }

            @Override
            public void switchedCommandStationStop() {
                LOGGER.info("Switch command station to stop.");
                this.setCommandStationState(CommandStationStatus.STOP);
            }

            @Override
            public void switchedCommandStationSoftStop() {
                LOGGER.info("Switch command station to softStop.");
                this.setCommandStationState(CommandStationStatus.SOFTSTOP);
            }

            @Override
            public void switchedCommandStationOff() {
                LOGGER.info("Switch command station off.");
                this.setCommandStationState(CommandStationStatus.OFF);
            }

            private void setCommandStationState(CommandStationStatus status) {
                NodeInterface node = BoosterPanelController.this.mainModel.getSelectedNode();
                if (node != null && node.getCommandStationNode() != null) {
                    BoosterPanelController.this.commandStationService.setCommandStationState("main", node.getCommandStationNode(), status);
                } else {
                    LOGGER.warn("No command station node available.");
                }
            }
        });
        try {
            this.boosterCurrentTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.trace("The booster current timer has elapsed.");
                    long now = System.currentTimeMillis();
                    try {
                        BoosterNodeInterface boosterNode;
                        NodeInterface selectedNode = BoosterPanelController.this.mainModel.getSelectedNode();
                        if (selectedNode != null && NodeUtils.hasBoosterFunctions((long)selectedNode.getUniqueId()) && (boosterNode = selectedNode.getBoosterNode()) != null && boosterNode.getBoosterCurrent() != null && boosterNode.getLastCurrentUpdate() != null && boosterNode.getBoosterCurrent() >= 0 && boosterNode.getLastCurrentUpdate() < now - 3000L) {
                            LOGGER.info("the current value is outdated -> clear the value, node: {}", (Object)selectedNode);
                            boosterNode.setBoosterCurrent(null, System.currentTimeMillis());
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Clear the outdated booster current value failed.", (Throwable)ex);
                    }
                }
            });
            this.boosterCurrentTimer.setCoalesce(true);
            this.boosterCurrentTimer.start();
        }
        catch (Exception ex) {
            LOGGER.warn("Start the booster current timer failed.", (Throwable)ex);
        }
        this.boosterPanel = boosterPanel;
        return boosterPanel;
    }

    public void nodeChanged(NodeInterface node) {
        this.updateComponentState();
    }

    private void updateComponentState() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (this.selectedNode != null && this.selectedNode.equals((Object)node)) {
            LOGGER.debug("Node is selected already: {}", (Object)node);
            return;
        }
        if (this.selectedNode != null) {
            BoosterNodeInterface boosterNode = this.selectedNode.getBoosterNode();
            if (boosterNode != null) {
                LOGGER.debug("Remove booster status listener from boosterNode: {}", (Object)boosterNode);
                boosterNode.removeBoosterStatusListener(this.boosterStatusListener);
            } else {
                LOGGER.debug("The selected node has no booster functions.");
            }
            CommandStationNodeInterface commandStationNode = this.selectedNode.getCommandStationNode();
            if (commandStationNode != null) {
                commandStationNode.removeCommandStationStatusListener(this.commandStationStatusListener);
            } else {
                LOGGER.debug("The selected node has no command station functions.");
            }
        }
        this.selectedNode = null;
        boolean isBooster = false;
        if (node != null && NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) {
            isBooster = true;
        }
        boolean isCommandStation = false;
        if (node != null && NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) {
            isCommandStation = true;
        }
        if (isBooster || isCommandStation) {
            this.selectedNode = node;
        }
        LOGGER.info("The selected node has booster functions: {}, has command station functions: {}, node: {}", new Object[]{isBooster, isCommandStation, node});
        BoosterNodeInterface boosterNode = null;
        CommandStationNodeInterface commandStationNode = null;
        if (this.selectedNode != null) {
            boosterNode = this.selectedNode.getBoosterNode();
            if (boosterNode != null) {
                LOGGER.debug("Add booster status listener to boosterNode: {}", (Object)boosterNode);
                boosterNode.addBoosterStatusListener(this.boosterStatusListener);
            } else {
                LOGGER.debug("The new selected node has no booster functions.");
            }
            commandStationNode = this.selectedNode.getCommandStationNode();
            if (commandStationNode != null) {
                LOGGER.debug("Adding command station status listener to node: {}", (Object)commandStationNode);
                commandStationNode.addCommandStationStatusListener(this.commandStationStatusListener);
            } else {
                LOGGER.debug("The new selected node has no command station functions.");
            }
        }
        if (this.boosterPanel != null) {
            this.boosterPanel.nodeChanged();
        }
        if (boosterNode != null) {
            Integer voltage = boosterNode.getBoosterVoltage();
            LOGGER.debug("Set the voltage: {}", (Object)voltage);
            this.boosterStatusListener.voltageChanged(this.selectedNode, voltage);
            this.boosterStatusListener.stateChanged(node, boosterNode.getBoosterStatus());
            this.boosterStatusListener.maximumCurrentChanged(node, boosterNode.getBoosterMaximumCurrent());
            this.boosterStatusListener.currentChanged(node, boosterNode.getBoosterCurrent(), System.currentTimeMillis());
            this.boosterStatusListener.temperatureChanged(node, boosterNode.getBoosterTemperature());
        }
        if (commandStationNode != null) {
            CommandStationStatus csStatus = commandStationNode.getCommandStationStatus();
            if (csStatus == null) {
                LOGGER.warn("The command station status is not available. Use OFF as state.");
                csStatus = CommandStationStatus.OFF;
            }
            this.commandStationStatusListener.statusChanged(node, csStatus);
        }
    }
}

