/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.TableColumnChooser;
import io.reactivex.rxjava3.subjects.Subject;
import java.awt.Color;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.renderer.DmxChannelRenderer;
import org.bidib.wizard.client.common.view.renderer.LocalPortConfigErrorAwareRenderer;
import org.bidib.wizard.client.common.view.slider.ConfigXAwareSliderRenderer;
import org.bidib.wizard.client.common.view.slider.SliderRenderer;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.mvc.main.model.BacklightPortTableModel;
import org.bidib.wizard.mvc.main.view.table.BacklightPortEditorPanel;

public class BacklightPortTable
extends AbstractPortHierarchicalTable<BacklightPort> {
    private static final long serialVersionUID = 1L;
    private final BacklightPortTableModel backlightPortTableModel;

    public BacklightPortTable(BacklightPortTableModel backlightPortTableModel, String emptyTableText) {
        super((SimpleHierarchicalPortTableModel)backlightPortTableModel, emptyTableText);
        this.backlightPortTableModel = backlightPortTableModel;
    }

    protected BacklightPortEditorPanel createPortEditorPanel(BacklightPort port, int row, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        BacklightPortEditorPanel editorPanel = new BacklightPortEditorPanel(port, backlightPort -> this.backlightPortTableModel.updatePortConfig((BacklightPort)backlightPort), backlightPort -> this.backlightPortTableModel.fireTestButtonPressed((BacklightPort)backlightPort), backlightPort -> this.backlightPortTableModel.refreshRow((BacklightPort)backlightPort, changedRow -> this.repaint(this.getCellRect(changedRow, 0, true))), portConfigChangeEventSubject, nodeSelectionProvider);
        editorPanel.createComponent();
        return editorPanel;
    }

    public void clearTable() {
    }

    protected RowStripeTableStyleProvider createTableStyleProvider(final TableModel portTableModel) {
        RowStripeTableStyleProvider tableStyleProvider = new RowStripeTableStyleProvider(new Color[]{UIManager.getColor("tableRowStripe.background"), UIManager.getColor("tableRowStripe.alternativeBackground")}){

            public CellStyle getCellStyleAt(JTable table, int rowIndex, int columnIndex) {
                int modelColumn = table.convertColumnIndexToModel(columnIndex);
                if (modelColumn != 0) {
                    return super.getCellStyleAt(table, rowIndex, modelColumn);
                }
                Port port = (Port)portTableModel.getValueAt(rowIndex, modelColumn);
                CellStyle style = super.getCellStyleAt(table, rowIndex, modelColumn);
                if (!port.isEnabled()) {
                    style = new CellStyle(style);
                    style.setForeground(BacklightPortTable.this.disabledForeground);
                    return style;
                }
                return style;
            }
        };
        return tableStyleProvider;
    }

    public void prepareTableColumns() {
        TableColumn tc = this.getColumnModel().getColumn(0);
        tc.setCellRenderer((TableCellRenderer)new LocalPortConfigErrorAwareRenderer(0));
        tc.setIdentifier(0);
        tc = this.getColumnModel().getColumn(2);
        tc.setIdentifier(2);
        ConfigXAwareSliderRenderer sliderRendererDimmMin = new ConfigXAwareSliderRenderer(1, 255, 10, new byte[]{4, 68});
        tc.setCellRenderer((TableCellRenderer)sliderRendererDimmMin);
        tc = this.getColumnModel().getColumn(1);
        tc.setIdentifier(1);
        ConfigXAwareSliderRenderer sliderRendererDimmMax = new ConfigXAwareSliderRenderer(1, 255, 10, new byte[]{3, 67});
        tc.setCellRenderer((TableCellRenderer)sliderRendererDimmMax);
        TableColumn tcDmxMapping = this.getColumnModel().getColumn(3);
        tcDmxMapping.setIdentifier(3);
        tcDmxMapping.setMaxWidth(80);
        tcDmxMapping.setCellRenderer((TableCellRenderer)new DmxChannelRenderer());
        tc = this.getColumnModel().getColumn(4);
        tc.setIdentifier(4);
        tc.setCellRenderer((TableCellRenderer)new SliderRenderer(0, 100, 10){

            protected void updateSliderTextValue(JTable table, int value, boolean isSelected, int row, int column) {
                String newValue = Integer.toString(value) + "%";
                this.sliderValue.setText(newValue);
            }
        });
        TableColumnChooser.hideColumn((JTable)((Object)this), (int)5);
    }
}

