/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.ping.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.event.ConsoleMessageEvent;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.mvc.ping.model.NodePingModel;
import org.bidib.wizard.mvc.ping.model.NodePingState;
import org.bidib.wizard.mvc.ping.model.PingTableNodePreferenceEntry;
import org.bidib.wizard.mvc.ping.model.PingTablePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingTableModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PingTableModel.class);
    public static final String PROPERTY_NODES = "nodes";
    public static final String PROPERTY_NODE_PING_STATUS = "nodePingStatus";
    private ArrayListModel<NodePingModel> nodeList = new ArrayListModel();
    private final PropertyChangeListener pclNodePingModel;
    private int defaultPingInterval = 200;
    private final PingTablePreferences pingTablePreferences;

    public PingTableModel(PingTablePreferences pingTablePreferences) {
        this.pingTablePreferences = pingTablePreferences;
        this.pclNodePingModel = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("The property of the node ping model has changed: {}", evt.getSource());
                if (evt.getSource() instanceof NodePingModel) {
                    NodePingModel nodePingModel = (NodePingModel)((Object)evt.getSource());
                    switch (evt.getPropertyName()) {
                        case "nodePingStatus": {
                            PingTableModel.this.firePropertyChange(PingTableModel.PROPERTY_NODE_PING_STATUS, null, nodePingModel.getNode());
                            break;
                        }
                        case "pingInterval": {
                            try {
                                PingTableNodePreferenceEntry prefs = PingTableModel.this.pingTablePreferences.getPrefencesOrDefault(nodePingModel.getNode().getUniqueId());
                                prefs.setPingInterval(nodePingModel.getPingInterval());
                                PingTableModel.this.pingTablePreferences.store();
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Store ping table preferences failed.", (Throwable)ex);
                            }
                            break;
                        }
                        case "additionalFillBytesCount": {
                            try {
                                PingTableNodePreferenceEntry prefs = PingTableModel.this.pingTablePreferences.getPrefencesOrDefault(nodePingModel.getNode().getUniqueId());
                                prefs.setAdditionalFillBytesCount(nodePingModel.getAdditionalFillBytesCount());
                                PingTableModel.this.pingTablePreferences.store();
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Store ping table preferences failed.", (Throwable)ex);
                            }
                            break;
                        }
                        case "additionalTotalBytesCount": {
                            try {
                                PingTableNodePreferenceEntry prefs = PingTableModel.this.pingTablePreferences.getPrefencesOrDefault(nodePingModel.getNode().getUniqueId());
                                prefs.setAdditionalTotalBytesCount(nodePingModel.getAdditionalTotalBytesCount());
                                PingTableModel.this.pingTablePreferences.store();
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Store ping table preferences failed.", (Throwable)ex);
                            }
                            break;
                        }
                        case "identifyProcessingWaitDuration": {
                            try {
                                PingTableNodePreferenceEntry prefs = PingTableModel.this.pingTablePreferences.getPrefencesOrDefault(nodePingModel.getNode().getUniqueId());
                                prefs.setIdentityProcessingWaitDuration(nodePingModel.getIdentifyProcessingWaitDuration());
                                PingTableModel.this.pingTablePreferences.store();
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Store ping table preferences failed.", (Throwable)ex);
                            }
                            break;
                        }
                    }
                }
            }
        };
    }

    public void setDefaultPingInterval(int pingInterval) {
        LOGGER.info("Set the defaultPingInterval: {}", (Object)pingInterval);
        this.defaultPingInterval = pingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(NodeInterface node) {
        ArrayListModel<NodePingModel> arrayListModel = this.nodeList;
        synchronized (arrayListModel) {
            NodePingModel nodePingModel = new NodePingModel(node);
            if (!this.nodeList.contains((Object)nodePingModel)) {
                LOGGER.info("Add node to ping node list: {}", (Object)node);
                nodePingModel.registerNode();
                nodePingModel.setPingInterval(this.defaultPingInterval);
                nodePingModel.setLastPingTimestamp(System.currentTimeMillis());
                nodePingModel.setNodePingState(NodePingState.OFF);
                String nodeLabel = nodePingModel.prepareNodeLabel();
                nodePingModel.setNodeLabel(nodeLabel);
                PingTableNodePreferenceEntry prefs = this.pingTablePreferences.getPrefences(node.getUniqueId());
                if (prefs != null) {
                    nodePingModel.setPingInterval(prefs.getPingInterval());
                    nodePingModel.setAdditionalFillBytesCount(prefs.getAdditionalFillBytesCount());
                    nodePingModel.setAdditionalTotalBytesCount(prefs.getAdditionalTotalBytesCount());
                    nodePingModel.setAdditionalPayloadStartValue(prefs.getAdditionalPayloadStartValue());
                    nodePingModel.setIdentifyProcessingWaitDuration(prefs.getIdentityProcessingWaitDuration());
                }
                LinkedList<NodePingModel> oldValue = new LinkedList<NodePingModel>((Collection<NodePingModel>)this.nodeList);
                this.nodeList.add((Object)nodePingModel);
                this.firePropertyChange(PROPERTY_NODES, oldValue, this.nodeList);
                nodePingModel.addPropertyChangeListener(this.pclNodePingModel);
            } else {
                LOGGER.warn("Node is already in ping node list: {}", (Object)node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(NodeInterface node) {
        ArrayListModel<NodePingModel> arrayListModel = this.nodeList;
        synchronized (arrayListModel) {
            LOGGER.info("Remove node from ping node list: {}", (Object)node);
            LinkedList<NodePingModel> oldValue = new LinkedList<NodePingModel>((Collection<NodePingModel>)this.nodeList);
            int index = this.nodeList.indexOf((Object)new NodePingModel(node));
            if (index > -1) {
                NodePingModel removed = (NodePingModel)((Object)this.nodeList.remove(index));
                LOGGER.info("Removed node: {}", (Object)removed);
                removed.removePropertyChangeListener(this.pclNodePingModel);
                if (removed != null) {
                    removed.freeNode();
                }
                this.firePropertyChange(PROPERTY_NODES, oldValue, this.nodeList);
            }
        }
    }

    public ArrayListModel<NodePingModel> getNodeListModel() {
        return this.nodeList;
    }

    public List<NodePingModel> getNodes() {
        return Collections.unmodifiableList(this.nodeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodePingState(NodeInterface node, NodePingState nodePingState) {
        ArrayListModel<NodePingModel> arrayListModel = this.nodeList;
        synchronized (arrayListModel) {
            NodePingModel nodePingModel;
            int index = this.nodeList.indexOf((Object)new NodePingModel(node));
            if (index > -1 && (nodePingModel = (NodePingModel)((Object)this.nodeList.get(index))) != null) {
                nodePingModel.setNodePingState(nodePingState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPongMarker(byte[] address, int marker, Consumer<ConsoleMessageEvent> consoleCallback) {
        NodePingModel pingModel;
        ArrayListModel<NodePingModel> arrayListModel = this.nodeList;
        synchronized (arrayListModel) {
            pingModel = this.nodeList.stream().filter(npm -> Arrays.equals(address, npm.getNode().getAddr())).findFirst().orElse(null);
        }
        if (pingModel != null) {
            long lastPongMarker = pingModel.getLastPongMarker();
            if (lastPongMarker >= 0L) {
                if (++lastPongMarker > 255L) {
                    lastPongMarker = 0L;
                }
                if ((long)marker != lastPongMarker) {
                    LOGGER.warn("Invalid pong marker detected. Received: {}, expected: {}", (Object)marker, (Object)lastPongMarker);
                    ConsoleMessageEvent consoleMessageEvent = new ConsoleMessageEvent(ConsoleColor.red, "Invalid pong marker detected. Received: " + marker + ", expected: " + lastPongMarker);
                    consoleCallback.accept(consoleMessageEvent);
                } else {
                    LOGGER.info("The pong marker is valid! Received: {}, expected: {}", (Object)marker, (Object)lastPongMarker);
                }
            }
            pingModel.setLastPongMarker(marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIdentifyWaitTime(byte[] address) {
        int identifyProcessingWaitDuration;
        NodePingModel pingModel;
        ArrayListModel<NodePingModel> arrayListModel = this.nodeList;
        synchronized (arrayListModel) {
            pingModel = this.nodeList.stream().filter(npm -> Arrays.equals(address, npm.getNode().getAddr())).findFirst().orElse(null);
        }
        if (pingModel != null && (identifyProcessingWaitDuration = pingModel.getIdentifyProcessingWaitDuration()) > 0) {
            LOGGER.info("Simulate long duration for processing, identifyProcessingWaitDuration: {}", (Object)identifyProcessingWaitDuration);
            try {
                Thread.sleep(identifyProcessingWaitDuration);
                LOGGER.info("identifyProcessingWaitDuration elapsed.");
            }
            catch (Exception ex) {
                LOGGER.warn("Wait for expiration of identifyProcessingWaitDuration failed.", (Throwable)ex);
            }
        }
    }
}

