/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.controller;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.PomAcknowledge;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.connection.AbstractMessageEvent;
import org.bidib.wizard.api.model.connection.event.CommandStationPomAcknowledgeMessageEvent;
import org.bidib.wizard.api.model.connection.event.CommandStationStateMessageEvent;
import org.bidib.wizard.api.model.connection.event.OccupancyCvMessageEvent;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.client.common.view.WindowUtils;
import org.bidib.wizard.core.model.connection.MessageAdapter;
import org.bidib.wizard.core.model.connection.MessageEventConsumer;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.common.DialogRegistry;
import org.bidib.wizard.mvc.common.view.RegisteredDialog;
import org.bidib.wizard.mvc.pom.controller.listener.PomProgrammerControllerListener;
import org.bidib.wizard.mvc.pom.model.CurrentAddressBeanModel;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.view.OperationAbortedException;
import org.bidib.wizard.mvc.pom.view.PomProgrammerView;
import org.bidib.wizard.mvc.pom.view.listener.PomProgrammerViewListener;
import org.oxbow.swingbits.dialog.task.CommandLink;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PomProgrammerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomProgrammerController.class);
    private final Collection<PomProgrammerControllerListener> listeners = new LinkedList<PomProgrammerControllerListener>();
    private final JFrame parent;
    private final CommandStationNodeInterface node;
    private final int x;
    private final int y;
    private final PomProgrammerModel model = new PomProgrammerModel();
    private PomProgrammerView view;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private BoosterService boosterService;
    @Autowired
    private CommandStationService commandStationService;
    private MessageAdapter messageAdapter;
    private static AtomicBoolean singleton = new AtomicBoolean();
    private final DialogRegistry dialogRegistry;

    public PomProgrammerController(CommandStationNodeInterface node, DialogRegistry dialogRegistry, JFrame parent, int x, int y) {
        this.parent = parent;
        this.dialogRegistry = dialogRegistry;
        this.node = node;
        this.x = x;
        this.y = y;
    }

    public static boolean isOpened() {
        return singleton.get();
    }

    private void setOpened(boolean opened) {
        singleton.set(opened);
    }

    public void addPomProgrammerControllerListener(PomProgrammerControllerListener l) {
        this.listeners.add(l);
    }

    private void fireClose() {
        for (PomProgrammerControllerListener l : this.listeners) {
            l.close();
        }
        this.setOpened(false);
    }

    private void fireSendRequest(PomAddressData decoderAddress, PomOperation operation, int cvNumber, int cvValue) {
        LOGGER.info("Send CV request, decoder addr: {}, operation: {}, cvNumber: {}, value: {}", new Object[]{decoderAddress, operation, cvNumber, cvValue});
        CommandStationPom opCode = CommandStationPom.valueOf((byte)ByteUtils.getLowByte((int)operation.getType()));
        this.model.clearCvValue();
        LOGGER.info("Prepared opCode: {}", (Object)opCode);
        for (PomProgrammerControllerListener l : this.listeners) {
            l.sendRequest(this.node, decoderAddress, opCode, cvNumber, cvValue);
        }
    }

    public void start(DockingDesktop desktop, AddressData initialAddress) {
        this.messageAdapter = new MessageAdapter(this.connectionService){

            protected void prepareMessageMap(Map<Class<? extends AbstractMessageEvent>, MessageEventConsumer<AbstractMessageEvent, NodeInterface>> messageActionMap) {
                LOGGER.info("Prepare the message map.");
                messageActionMap.put(CommandStationStateMessageEvent.class, (MessageEventConsumer<AbstractMessageEvent, NodeInterface>)((MessageEventConsumer)(evt, node) -> {
                    CommandStationStateMessageEvent event = (CommandStationStateMessageEvent)evt;
                    CommandStationState commandStationState = event.getCommandStationState();
                    byte[] address = event.getAddress();
                    LOGGER.info("The command station state has changed, address: {}, state: {}", (Object)address, (Object)commandStationState);
                    if (Arrays.equals(node.getNode().getAddr(), address)) {
                        LOGGER.info("The state of the selected command station node has changed.");
                        PomProgrammerController.this.model.setCommandStationState(commandStationState);
                    } else {
                        LOGGER.warn("Another command station has changed the state.");
                    }
                }));
                messageActionMap.put(CommandStationPomAcknowledgeMessageEvent.class, (MessageEventConsumer<AbstractMessageEvent, NodeInterface>)((MessageEventConsumer)(evt, node) -> {
                    CommandStationPomAcknowledgeMessageEvent event = (CommandStationPomAcknowledgeMessageEvent)evt;
                    byte[] address = event.getAddress();
                    PomAddressData decoderAddress = event.getAddressData();
                    PomAcknowledge pomAcknowledge = event.getPomAcknowledge();
                    LOGGER.info("POM ackn was received, node addr: {}, decoder address: {}, pomAcknowledge: {}", new Object[]{address, decoderAddress, pomAcknowledge});
                }));
                messageActionMap.put(OccupancyCvMessageEvent.class, (MessageEventConsumer<AbstractMessageEvent, NodeInterface>)((MessageEventConsumer)(evt, node) -> {
                    OccupancyCvMessageEvent event = (OccupancyCvMessageEvent)evt;
                    byte[] address = event.getAddress();
                    PomAddressData decoderAddress = event.getAddressData();
                    int cvNumber = event.getCvNumber();
                    int cvData = event.getCvValue();
                    LOGGER.info("CV was received, node addr: {}, decoder address: {}, cvNumber: {}, cvData: {}", new Object[]{address, decoderAddress, cvNumber, cvData});
                    PomProgrammerController.this.updatePomProgState(PomProgState.POM_PROG_OKAY, decoderAddress, cvNumber, cvData);
                }));
            }

            protected void onDisconnect() {
                if (PomProgrammerController.this.view != null) {
                    PomProgrammerController.this.view.close();
                    PomProgrammerController.this.view = null;
                }
                super.onDisconnect();
            }
        };
        this.messageAdapter.setNode(this.node.getNode());
        this.messageAdapter.start();
        CurrentAddressBeanModel currentAddressBeanModel = new CurrentAddressBeanModel();
        if (initialAddress != null) {
            LOGGER.info("Set the provided initial address: {}", (Object)initialAddress);
            currentAddressBeanModel.setDccAddress(initialAddress.getAddress());
            AddressTypeEnum addressTypeEnum = initialAddress.getType();
            PomAddressTypeEnum addressType = null;
            switch (addressTypeEnum) {
                case ACCESSORY: {
                    addressType = PomAddressTypeEnum.ACCESSORY;
                    break;
                }
                case EXTENDED_ACCESSORY: {
                    addressType = PomAddressTypeEnum.EXTENDED_ACCESSORY;
                    break;
                }
                default: {
                    addressType = PomAddressTypeEnum.LOCOMOTIVE;
                }
            }
            currentAddressBeanModel.setAddressType(addressType);
        }
        if (currentAddressBeanModel.getDccAddress() != null && CollectionUtils.isNotEmpty(this.dialogRegistry.getDialogRegistry())) {
            final String searchKey = PomProgrammerView.prepareKey(currentAddressBeanModel.getDccAddress());
            RegisteredDialog existingDialog = (RegisteredDialog)IterableUtils.find(this.dialogRegistry.getDialogRegistry(), (Predicate)new Predicate<RegisteredDialog>(){

                public boolean evaluate(RegisteredDialog dialog) {
                    return searchKey.equals(dialog.getKey());
                }
            });
            if (existingDialog != null) {
                LOGGER.info("Found existing dialog: {}", (Object)existingDialog);
                try {
                    if (SystemUtils.IS_OS_WINDOWS) {
                        WindowUtils.bringWindowToFront((Window)existingDialog.getWindow());
                    } else {
                        existingDialog.getWindow().toFront();
                    }
                    return;
                }
                catch (Exception ex) {
                    LOGGER.warn("Bring the existing dialog to front failed.");
                }
            } else {
                LOGGER.info("No existing dialog found.");
            }
        }
        this.view = new PomProgrammerView(this.model, currentAddressBeanModel);
        this.view.addPomProgrammerViewListener(new PomProgrammerViewListener(){

            @Override
            public void close() {
                PomProgrammerController.this.messageAdapter.dispose();
                PomProgrammerView registeredDialog = PomProgrammerController.this.view;
                PomProgrammerController.this.unregisterView(registeredDialog);
                PomProgrammerController.this.fireClose();
            }

            @Override
            public void sendRequest(PomAddressData decoderAddress, PomOperation operation, int cvNumber, int cvValue) {
                PomProgrammerController.this.fireSendRequest(decoderAddress, operation, cvNumber, cvValue);
            }

            @Override
            public boolean sendCommandStationStateRequest(boolean activate) {
                LOGGER.info("Set the command station to active mode: {}", (Object)activate);
                CommandStationStatus commandStationState = PomProgrammerController.this.commandStationService.queryCommandStationStateBlocking("main", PomProgrammerController.this.node);
                LinkedList<BoosterNodeInterface> boostersToStart = new LinkedList<BoosterNodeInterface>();
                for (BoosterNodeInterface node : PomProgrammerController.this.boosterService.getBoosterNodes("main")) {
                    LOGGER.info("+++ Query the booster state for node: {}", (Object)node);
                    BoosterStatus boosterState = node.getBoosterStatus();
                    LOGGER.info("+++ The current boosterState: {}", (Object)boosterState);
                    if (boosterState == null || !BoosterStatus.isOffState((BoosterStatus)boosterState)) continue;
                    LOGGER.info("The current booster is off: {}", (Object)node);
                    boostersToStart.add(node);
                }
                if (CommandStationStatus.isOffState((CommandStationStatus)commandStationState) || CollectionUtils.isNotEmpty(boostersToStart)) {
                    LinkedList<CommandLink> commandLinks = new LinkedList<CommandLink>();
                    commandLinks.add(new CommandLink(Resources.getString(PomProgrammerController.class, (String)"activate_booster_and_commandstation"), Resources.getString(PomProgrammerController.class, (String)"activate_booster_and_commandstation.text")));
                    commandLinks.add(new CommandLink(Resources.getString(PomProgrammerController.class, (String)"do_not_activate_booster_and_commandstation"), Resources.getString(PomProgrammerController.class, (String)"do_not_activate_booster_and_commandstation.text")));
                    if (SystemUtils.IS_OS_MAC_OSX) {
                        commandLinks.add(new CommandLink(Resources.getString(PomProgrammerController.class, (String)"cancel_pom_dialog"), Resources.getString(PomProgrammerController.class, (String)"cancel_pom_dialog.text")));
                    }
                    int choice = TaskDialogs.build((Window)PomProgrammerController.this.parent, (String)Resources.getString(PomProgrammerController.class, (String)"message-warn"), (String)Resources.getString(PomProgrammerController.class, (String)"message")).title(Resources.getString(PomProgrammerController.class, (String)"title")).choice(0, commandLinks);
                    LOGGER.info("User selected option: {}", (Object)choice);
                    switch (choice) {
                        case -1: {
                            LOGGER.info("User cancelled pomConfirmDialog.");
                            throw new OperationAbortedException("User cancelled pomConfirmDialog.");
                        }
                        case 0: {
                            if (NodeUtils.hasBoosterFunctions((long)PomProgrammerController.this.node.getNode().getUniqueId())) {
                                LOGGER.info("Activate the booster!");
                                PomProgrammerController.this.boosterService.setBoosterState("main", PomProgrammerController.this.node.getNode().getBoosterNode(), BoosterStatus.ON);
                            } else {
                                LOGGER.info("The command station has no booster!");
                            }
                            LOGGER.info("Activate the command station!");
                            PomProgrammerController.this.commandStationService.setCommandStationState("main", PomProgrammerController.this.node, CommandStationStatus.GO_IGN_WD);
                            for (BoosterNodeInterface booster : boostersToStart) {
                                LOGGER.info("Start the booster: {}", (Object)booster);
                                PomProgrammerController.this.boosterService.setBoosterState("main", booster.getNode().getBoosterNode(), BoosterStatus.ON);
                            }
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            LOGGER.info("User cancelled pomConfirmDialog.");
                            throw new OperationAbortedException("User cancelled pomConfirmDialog.");
                        }
                    }
                    return true;
                }
                LOGGER.info("Set the command station state: {}", (Object)commandStationState);
                PomProgrammerController.this.model.setCommandStationState(commandStationState != null ? commandStationState.getCommandStationState() : null);
                return false;
            }
        });
        LOGGER.info("Initialize the view.");
        this.setOpened(true);
        this.view.showDialog(this.parent, this.x, this.y);
        LOGGER.info("Register the LocoDialog in the dialog registry: {}", (Object)this.view);
        this.dialogRegistry.getDialogRegistry().add(this.view);
        LOGGER.info("The POM programmer dialog is now displayed.");
    }

    private void updatePomProgState(PomProgState pomProgState, PomAddressData decoderAddress, int cvNumber, int cvValue) {
        this.model.updatePomProgResult(pomProgState, decoderAddress, cvNumber, cvValue);
    }

    private void unregisterView(RegisteredDialog view) {
        block5: {
            if (view != null) {
                try {
                    if (!CollectionUtils.isNotEmpty(this.dialogRegistry.getDialogRegistry())) break block5;
                    final String searchKey = view.getKey();
                    RegisteredDialog existingDialog = (RegisteredDialog)IterableUtils.find(this.dialogRegistry.getDialogRegistry(), (Predicate)new Predicate<RegisteredDialog>(){

                        public boolean evaluate(RegisteredDialog dialog) {
                            return searchKey.equals(dialog.getKey());
                        }
                    });
                    if (existingDialog != null) {
                        LOGGER.info("Found existing dialog to unregister: {}", (Object)existingDialog);
                        this.dialogRegistry.getDialogRegistry().remove(existingDialog);
                        LOGGER.info("Registry after remove: {}", (Object)this.dialogRegistry);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Unregister view failed: {}", (Object)view, (Object)ex);
                }
            } else {
                LOGGER.info("No view available to unregister.");
            }
        }
    }
}

