/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.model;

import com.jgoodies.binding.beans.Model;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.stepcontrol.model.AccelarationScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.model.Gearing;
import org.bidib.wizard.mvc.stepcontrol.model.InvalidConfigurationException;
import org.bidib.wizard.mvc.stepcontrol.model.MicroStepsEnum;
import org.bidib.wizard.mvc.stepcontrol.model.MotorSizeType;
import org.bidib.wizard.mvc.stepcontrol.model.MovementScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.view.wizard.SummaryPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationWizardModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationWizardModel.class);
    public static final String PROPERTYNAME_TURNTABLE_TYPE = "turnTableType";
    public static final String PROPERTYNAME_MOTORSIZE_TYPE = "motorSizeType";
    public static final String PROPERTYNAME_STEPCOUNT = "stepCount";
    public static final String PROPERTYNAME_GEARING = "gearing";
    public static final String PROPERTYNAME_MICROSTEPPING = "microStepping";
    public static final String PROPERTYNAME_TOTALSTEPCOUNT = "totalStepCount";
    public static final String PROPERTYNAME_WIZARDSTATUS = "wizardStatus";
    public static final String PROPERTYNAME_HTMLCONTENT = "htmlContent";
    public static final String PROPERTYNAME_SPEED_SCALE = "speedScale";
    public static final String PROPERTYNAME_ACCELERATION_SCALE = "accelerationScale";
    public static final String PROPERTYNAME_SPEED = "speed";
    public static final String PROPERTYNAME_ACCEL = "accel";
    public static final String PROPERTYNAME_DECEL = "decel";
    private TurnTableType turnTableType;
    private MotorSizeType motorSizeType;
    private Integer stepCount;
    private Gearing gearing;
    private MicroStepsEnum microStepping = MicroStepsEnum.steps64;
    private MovementScaleEnum speedScale = MovementScaleEnum.scale1;
    private AccelarationScaleEnum accelerationScale = AccelarationScaleEnum.scale1;
    private WizardStatus wizardStatus = WizardStatus.started;
    private Integer speed;
    private Integer accel;
    private Integer decel;
    private final NodeInterface selectedNode;
    private static final long F_STEP_ACCEL_LIMIT = 19150L;

    public ConfigurationWizardModel(NodeInterface selectedNode) {
        this.selectedNode = selectedNode;
    }

    public NodeInterface getSelectedNode() {
        return this.selectedNode;
    }

    public TurnTableType getTurnTableType() {
        return this.turnTableType;
    }

    public void setTurnTableType(TurnTableType turnTableType) {
        LOGGER.info("Set the turnTableType: {}", (Object)turnTableType);
        TurnTableType oldValue = this.turnTableType;
        this.turnTableType = turnTableType;
        this.firePropertyChange(PROPERTYNAME_TURNTABLE_TYPE, oldValue, turnTableType);
    }

    public MotorSizeType getMotorSizeType() {
        return this.motorSizeType;
    }

    public void setMotorSizeType(MotorSizeType motorSizeType) {
        LOGGER.info("Set the motorSizeType: {}", (Object)motorSizeType);
        MotorSizeType oldValue = this.motorSizeType;
        this.motorSizeType = motorSizeType;
        this.firePropertyChange(PROPERTYNAME_MOTORSIZE_TYPE, (Object)oldValue, (Object)motorSizeType);
    }

    public Integer getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(Integer stepCount) {
        Integer oldValue = this.stepCount;
        Integer oldTotalStepCount = this.getTotalStepCount();
        this.stepCount = stepCount;
        this.firePropertyChange(PROPERTYNAME_STEPCOUNT, oldValue, stepCount);
        this.firePropertyChange(PROPERTYNAME_TOTALSTEPCOUNT, oldTotalStepCount, this.getTotalStepCount());
    }

    public Gearing getGearing() {
        if (this.gearing == null) {
            this.gearing = new Gearing("no");
        }
        return this.gearing;
    }

    public void setGearing(Gearing gearing) {
        Gearing oldValue = this.gearing;
        Integer oldTotalStepCount = this.getTotalStepCount();
        this.gearing = gearing;
        this.firePropertyChange(PROPERTYNAME_GEARING, (Object)oldValue, (Object)gearing);
        this.firePropertyChange(PROPERTYNAME_TOTALSTEPCOUNT, oldTotalStepCount, this.getTotalStepCount());
    }

    public MicroStepsEnum getMicroStepping() {
        return this.microStepping;
    }

    public void setMicroStepping(MicroStepsEnum microStepping) {
        LOGGER.info("Set the new microstepping value: {}", (Object)microStepping);
        MicroStepsEnum oldValue = this.microStepping;
        Integer oldTotalStepCount = this.getTotalStepCount();
        this.microStepping = microStepping;
        this.firePropertyChange(PROPERTYNAME_MICROSTEPPING, (Object)oldValue, (Object)microStepping);
        this.firePropertyChange(PROPERTYNAME_TOTALSTEPCOUNT, oldTotalStepCount, this.getTotalStepCount());
    }

    public Integer getTotalStepCount() {
        try {
            if (this.gearing != null && "yes".equals(this.gearing.getKey())) {
                int totalStepCount = this.stepCount * this.microStepping.getSteps() * this.gearing.getGearRatioPrimary() / this.gearing.getGearRatioSecondary();
                LOGGER.info("Calculated total step count: {}", (Object)totalStepCount);
                return totalStepCount;
            }
            return this.stepCount * this.microStepping.getSteps();
        }
        catch (Exception ex) {
            LOGGER.warn("Calculate total step count failed.");
            return null;
        }
    }

    public void triggerUpdateTotalSteps() {
        this.firePropertyChange(PROPERTYNAME_TOTALSTEPCOUNT, null, this.getTotalStepCount());
    }

    public MovementScaleEnum getSpeedScale() {
        return this.speedScale;
    }

    public void setSpeedScale(MovementScaleEnum speedScale) {
        MovementScaleEnum oldValue = this.speedScale;
        this.speedScale = speedScale;
        this.firePropertyChange(PROPERTYNAME_SPEED_SCALE, (Object)oldValue, (Object)speedScale);
    }

    public AccelarationScaleEnum getAccelerationScale() {
        return this.accelerationScale;
    }

    public void setAccelerationScale(AccelarationScaleEnum accelerationScale) {
        AccelarationScaleEnum oldValue = this.accelerationScale;
        this.accelerationScale = accelerationScale;
        this.firePropertyChange(PROPERTYNAME_ACCELERATION_SCALE, (Object)oldValue, (Object)accelerationScale);
    }

    public WizardStatus getWizardStatus() {
        return this.wizardStatus;
    }

    public void setWizardStatus(WizardStatus wizardStatus) {
        WizardStatus oldValue = this.wizardStatus;
        this.wizardStatus = wizardStatus;
        this.firePropertyChange(PROPERTYNAME_WIZARDSTATUS, (Object)oldValue, (Object)wizardStatus);
    }

    public Integer getSpeed() {
        return this.speed;
    }

    public void setSpeed(Integer speed) {
        LOGGER.info("Set speed: {}", (Object)speed);
        Integer oldValue = this.speed;
        this.speed = speed;
        this.firePropertyChange(PROPERTYNAME_SPEED, oldValue, speed);
    }

    public Integer getAccel() {
        return this.accel;
    }

    public void setAccel(Integer accel) {
        Integer oldValue = this.accel;
        this.accel = accel;
        this.firePropertyChange(PROPERTYNAME_ACCEL, oldValue, accel);
    }

    public Integer getDecel() {
        return this.decel;
    }

    public void setDecel(Integer decel) {
        Integer oldValue = this.decel;
        this.decel = decel;
        this.firePropertyChange(PROPERTYNAME_DECEL, oldValue, decel);
    }

    public void checkValidConfigurationValues(String valueIdentifier, LongSupplier newValueSupplier, LongConsumer correctedValueConsumer) {
        this.validateConfigurationValue(valueIdentifier, newValueSupplier, correctedValueConsumer);
    }

    private void validateConfigurationValue(String valueIdentifier, LongSupplier newValueSupplier, LongConsumer correctedValueConsumer) {
        if (this.getTotalStepCount() == null) {
            LOGGER.warn("The totalSteps are not available.");
            throw new IllegalArgumentException("The totalSteps are not available.");
        }
        long totalSteps = this.getTotalStepCount().longValue();
        long minDecel = totalSteps * newValueSupplier.getAsLong();
        if (minDecel < 19150L) {
            LOGGER.warn("The configured '{}' value is too small: {}", (Object)valueIdentifier, (Object)newValueSupplier.getAsLong());
            long calculatedMinDecel = 19150L / totalSteps + 1L;
            LOGGER.info("calculatedMinDecel: {}", (Object)calculatedMinDecel);
            throw new InvalidConfigurationException("The configured '" + valueIdentifier + "' value is too small: " + newValueSupplier.getAsLong() + ", minimum value: " + calculatedMinDecel, calculatedMinDecel);
        }
    }

    public String getHtmlContent() {
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(Resources.getString(SummaryPanel.class, (String)"turntableType", (Object[])new Object[]{Resources.getString(TurnTableType.class, (String)this.turnTableType.name())})).append("<br/>");
        sb.append(Resources.getString(SummaryPanel.class, (String)"motorSize", (Object[])new Object[]{Resources.getString(MotorSizeType.class, (String)this.motorSizeType.name())})).append("<br/>");
        if (this.gearing != null && !"no".equals(this.gearing.getKey())) {
            sb.append(Resources.getString(SummaryPanel.class, (String)PROPERTYNAME_GEARING, (Object[])new Object[]{this.gearing.getGearRatioPrimary(), this.gearing.getGearRatioSecondary(), this.gearing.getBackLash()})).append("<br/>");
        } else {
            sb.append(Resources.getString(SummaryPanel.class, (String)"gearingNone")).append("<br/>");
        }
        sb.append(Resources.getString(SummaryPanel.class, (String)PROPERTYNAME_STEPCOUNT, (Object[])new Object[]{this.stepCount})).append("<br/>");
        sb.append(Resources.getString(SummaryPanel.class, (String)PROPERTYNAME_MICROSTEPPING, (Object[])new Object[]{Resources.getString(MicroStepsEnum.class, (String)this.microStepping.getKey())})).append("<br/>");
        sb.append(Resources.getString(SummaryPanel.class, (String)PROPERTYNAME_TOTALSTEPCOUNT, (Object[])new Object[]{this.getTotalStepCount()})).append("<br/>");
        sb.append("</html>");
        return sb.toString();
    }

    public void triggerUpdateHtmlContent() {
        this.firePropertyChange(PROPERTYNAME_HTMLCONTENT, null, this.getHtmlContent());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static enum WizardStatus {
        started,
        finished,
        aborted;

    }
}

