/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import java.util.Map;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.bidib.wizard.mvc.stepcontrol.model.MicroStepsEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepControlCvUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepControlCvUtils.class);

    public static CvNode getNode(Map<String, CvNode> mapKeywordToNode, String keyword) {
        CvNode cvNode = mapKeywordToNode.get(keyword);
        return cvNode;
    }

    public static Integer getConfigVarByteValue(Map<String, CvNode> mapKeywordToNode, Map<String, CvNode> cvNumberToJideNodeMap, String keyword) {
        CvNode cvNode = StepControlCvUtils.getNode(mapKeywordToNode, keyword);
        if (cvNode != null) {
            Integer value = CvValueUtils.getConfigVarByteValue(cvNode, cvNumberToJideNodeMap);
            return value;
        }
        return null;
    }

    public static Integer getConfigVarIntValue(Map<String, CvNode> mapKeywordToNode, Map<String, CvNode> cvNumberToJideNodeMap, String keyword) {
        CvNode cvNode = StepControlCvUtils.getNode(mapKeywordToNode, keyword);
        if (cvNode != null) {
            Integer value = CvValueUtils.getConfigVarIntValue(cvNode, cvNumberToJideNodeMap);
            return value;
        }
        return null;
    }

    public static Long getConfigVarLongValue(Map<String, CvNode> mapKeywordToNode, String keyword) {
        CvNode cvNode = StepControlCvUtils.getNode(mapKeywordToNode, keyword);
        if (cvNode != null) {
            Long value = CvValueUtils.getConfigVarLongValue(cvNode);
            return value;
        }
        return null;
    }

    public static Long getConfigVarLongValueFromStringByCvKey(Map<String, CvNode> cvNumberToJideNodeMap, String cvKey) {
        LOGGER.info("Get the cvNode for CV key: {}", (Object)cvKey);
        CvNode cvNode = cvNumberToJideNodeMap.get(cvKey);
        if (cvNode != null) {
            String value = CvValueUtils.getConfigVarStringValue(cvNode);
            long longValue = Long.parseLong(value);
            LOGGER.info("Current string value: {}, parsed long value: {}", (Object)value, (Object)longValue);
            return longValue;
        }
        return null;
    }

    public static MicroStepsEnum getValidMicroStepping(Map<String, CvNode> mapKeywordToNode, Map<String, CvNode> cvNumberToJideNodeMap) {
        Integer microSteppingValue = StepControlCvUtils.getConfigVarByteValue(mapKeywordToNode, cvNumberToJideNodeMap, "microstepping");
        MicroStepsEnum microStepsEnum = null;
        if (microSteppingValue != null) {
            try {
                microStepsEnum = MicroStepsEnum.fromValue(microSteppingValue);
            }
            catch (Exception ex) {
                LOGGER.warn("Parse microsteps value to supported enum failed.", (Throwable)ex);
            }
        }
        if (microStepsEnum == null) {
            LOGGER.warn("Set the default microstepping value of 32!");
            microStepsEnum = MicroStepsEnum.steps64;
        }
        return microStepsEnum;
    }
}

