/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    public static final String EXCEL_EXTENSION = "xlsx";
    public static final String FILENAME_REGEX_PATTERN = "^[^\\\\/:*?\"<>\\[\\]|\\$\\s]{1,255}$";

    public static boolean isPathValid(String path) {
        try {
            File dir = org.apache.commons.io.FileUtils.getFile((String[])new String[]{path});
            dir.getCanonicalPath();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static boolean isFilenameValid(String filename) {
        if (filename == null) {
            return false;
        }
        return filename.matches(FILENAME_REGEX_PATTERN);
    }

    public static String escapeInvalidFilenameCharacters(String path, String replacement) {
        return path.replaceAll("[\\\\/:*?\"<>\\[\\]|\\$\\s]", replacement);
    }

    public static void copyFile(File srcFile, File destFile, CopyOption ... copyOptions) throws IOException {
        FileUtils.requireFileCopy(srcFile, destFile);
        FileUtils.requireFile(srcFile, "srcFile");
        FileUtils.requireCanonicalPathsNotEquals(srcFile, destFile);
        org.apache.commons.io.FileUtils.createParentDirectories((File)destFile);
        FileUtils.requireFileIfExists(destFile, "destFile");
        if (destFile.exists()) {
            FileUtils.requireCanWrite(destFile, "destFile");
        }
        Files.copy(srcFile.toPath(), destFile.toPath(), copyOptions);
    }

    private static void requireFileCopy(File source, File destination) throws FileNotFoundException {
        FileUtils.requireExistsChecked(source, "source");
        Objects.requireNonNull(destination, "destination");
    }

    private static File requireExistsChecked(File file, String fileParamName) throws FileNotFoundException {
        Objects.requireNonNull(file, fileParamName);
        if (!file.exists()) {
            throw new FileNotFoundException("File system element for parameter '" + fileParamName + "' does not exist: '" + String.valueOf(file) + "'");
        }
        return file;
    }

    private static File requireFile(File file, String name) {
        Objects.requireNonNull(file, name);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Parameter '" + name + "' is not a file: " + String.valueOf(file));
        }
        return file;
    }

    private static void requireCanonicalPathsNotEquals(File file1, File file2) throws IOException {
        String canonicalPath = file1.getCanonicalPath();
        if (canonicalPath.equals(file2.getCanonicalPath())) {
            throw new IllegalArgumentException(String.format("File canonical paths are equal: '%s' (file1='%s', file2='%s')", canonicalPath, file1, file2));
        }
    }

    private static File requireFileIfExists(File file, String name) {
        Objects.requireNonNull(file, name);
        return file.exists() ? FileUtils.requireFile(file, name) : file;
    }

    private static void requireCanWrite(File file, String name) {
        Objects.requireNonNull(file, "file");
        if (!file.canWrite()) {
            throw new IllegalArgumentException("File parameter '" + name + " is not writable: '" + String.valueOf(file) + "'");
        }
    }

    public static boolean silentlyDeleteFile(File file, Long waitAfterDelete) {
        boolean deleted = true;
        if (file.exists()) {
            deleted = file.delete();
            if (waitAfterDelete != null) {
                try {
                    Thread.sleep(waitAfterDelete);
                }
                catch (Exception ex) {
                    LOGGER.warn("Sleep after delete file silently failed.", (Throwable)ex);
                }
            }
        }
        return deleted;
    }
}

