package org.bidib.wizard.mvc.loco.model;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

import org.bidib.wizard.mvc.loco.model.command.PomRequestProcessor;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomOperationCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.common.bean.Bean;

import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.CompositeDisposable;

public class SpeedometerModel extends Bean {

    private static final Logger LOGGER = LoggerFactory.getLogger(SpeedometerModel.class);

    private static final long serialVersionUID = 1L;

    public static final String PROPERTYNAME_ACTIVE = "active";

    public static final String PROPERTYNAME_INACTIVE = "inactive";

    public static final String PROPERTYNAME_CV2_VMIN = "cv2Vmin";

    public static final String PROPERTYNAME_CV37_SCALE = "cv37Scale";

    public static final String PROPERTYNAME_DYNSTATEENERGY = "dynStateEnergy";

    public static final String PROPERTYNAME_REPORTEDSPEED = "reportedSpeed";

    public static final String PROPERTYNAME_SPEED = "speed";

    public static final String PROPERTYNAME_SPEEDMEASUREMENTSTAGE = "speedMeasurementStage";

    private AtomicBoolean active = new AtomicBoolean(false);

    private Integer cv2Vmin;

    private Integer cv37Scale;

    private Integer dynStateEnergy;

    private Integer reportedSpeed;

    private Integer speed;

    private SpeedMeasurementStage speedMeasurementStage = SpeedMeasurementStage.IDLE;

    private PomProgrammerModel pomProgrammerModel;

    private CompositeDisposable compositeDisposable;

    private PomRequestProcessor<SpeedometerProgBeanModel> pomRequestProcessor;

    private List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> pomProgCommands;

    private SingleObserver<String> completeAction;

    public enum SpeedMeasurementStage {
        // @formatter:off
        IDLE, 
        WAIT_FOR_CAR_SPEED_AND_BATTERY_RESPONSE, 
        READ_CURRENT_CV_VALUES, 
        WRITE_CV_VALUES, 
        SET_MOTOR_PID_SOFT, 
        START_MEASUREMENT, 
        SET_SPEED_MAX, 
        FINISHED, 
        ABORTED,
        STOP_FOR_USER_INTERACTION,
        MEASURE_ON, MEASURE_OFF
        // @formatter:on
    }

    public SpeedometerModel() {

    }

    public void clearValues() {
        LOGGER.info("Clear the values of the speedometer model.");

        setActive(false);
        setCv2Vmin(null);
        setCv37Scale(null);
        setDynStateEnergy(null);
        setReportedSpeed(null);
        setSpeed(null);
        setSpeedMeasurementStage(SpeedMeasurementStage.IDLE);
        setCompleteAction(null);
    }

    /**
     * @return the active
     */
    public boolean isActive() {
        return active.get();
    }

    /**
     * @return the inactive flag
     */
    public boolean isInactive() {
        return !active.get();
    }

    /**
     * @param active
     *            the active to set
     */
    public void setActive(boolean active) {
        LOGGER.info("Set the active flag: {}", active);
        boolean oldValue = this.active.get();
        this.active.set(active);
        firePropertyChange(PROPERTYNAME_ACTIVE, oldValue, active);
        firePropertyChange(PROPERTYNAME_INACTIVE, !oldValue, !active);
    }

    public Integer getDynStateEnergy() {
        return dynStateEnergy;
    }

    public void setDynStateEnergy(Integer dynStateEnergy) {
        Integer oldValue = this.dynStateEnergy;
        this.dynStateEnergy = dynStateEnergy;

        firePropertyChange(PROPERTYNAME_DYNSTATEENERGY, oldValue, dynStateEnergy);
    }

    /**
     * @return the reportedSpeed in mm/s
     */
    public Integer getReportedSpeed() {
        return reportedSpeed;
    }

    /**
     * @param reportedSpeed
     *            the reportedSpeed in mm/s to set
     */
    public void setReportedSpeed(Integer reportedSpeed) {
        Integer oldValue = this.reportedSpeed;
        this.reportedSpeed = reportedSpeed;

        LOGGER.info("New reported speed: {}", this.reportedSpeed);

        firePropertyChange(PROPERTYNAME_REPORTEDSPEED, oldValue, reportedSpeed);
    }

    /**
     * @return the speed
     */
    public Integer getSpeed() {
        return speed;
    }

    /**
     * @param speed
     *            the speed to set
     */
    public void setSpeed(Integer speed) {
        Integer oldValue = this.speed;
        this.speed = speed;

        firePropertyChange(PROPERTYNAME_SPEED, oldValue, speed);
    }

    /**
     * @return the speedMeasurementStage
     */
    public SpeedMeasurementStage getSpeedMeasurementStage() {
        return speedMeasurementStage;
    }

    /**
     * @param speedMeasurementStage
     *            the speedMeasurementStage to set
     */
    public void setSpeedMeasurementStage(SpeedMeasurementStage speedMeasurementStage) {
        LOGGER.info("Set the speedMeasurementStage: {}", speedMeasurementStage);

        SpeedMeasurementStage oldValue = this.speedMeasurementStage;
        this.speedMeasurementStage = speedMeasurementStage;

        firePropertyChange(PROPERTYNAME_SPEEDMEASUREMENTSTAGE, oldValue, speedMeasurementStage);
    }

    /**
     * @return the pomProgCommands
     */
    public List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> getPomProgCommands() {
        return pomProgCommands;
    }

    /**
     * @param pomProgCommands
     *            the pomProgCommands to set
     */
    public void setPomProgCommands(List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> pomProgCommands) {
        LOGGER.info("Set the pomProgCommands: {}", pomProgCommands);
        this.pomProgCommands = pomProgCommands;
    }

    /**
     * @return the completeAction
     */
    public SingleObserver<String> getCompleteAction() {
        return completeAction;
    }

    /**
     * @param completeAction
     *            the completeAction to set
     */
    public void setCompleteAction(SingleObserver<String> completeAction) {
        LOGGER.info("Set the complete action:{}", completeAction);
        this.completeAction = completeAction;
    }

    /**
     * @return the cv2Vmin
     */
    public Integer getCv2Vmin() {
        return cv2Vmin;
    }

    /**
     * @param cv2Vmin
     *            the cv2Vmin to set
     */
    public void setCv2Vmin(Integer cv2Vmin) {
        Integer oldValue = this.cv2Vmin;
        this.cv2Vmin = cv2Vmin;

        firePropertyChange(PROPERTYNAME_CV2_VMIN, oldValue, cv2Vmin);
    }

    /**
     * @return the cv37Scale
     */
    public Integer getCv37Scale() {
        return cv37Scale;
    }

    /**
     * @param cv37Scale
     *            the cv37Scale to set
     */
    public void setCv37Scale(Integer cv37Scale) {
        Integer oldValue = this.cv37Scale;
        this.cv37Scale = cv37Scale;

        firePropertyChange(PROPERTYNAME_CV37_SCALE, oldValue, cv37Scale);
    }

    /**
     * @return the pomProgrammerModel
     */
    public PomProgrammerModel getPomProgrammerModel() {
        return pomProgrammerModel;
    }

    /**
     * @param pomProgrammerModel
     *            the pomProgrammerModel to set
     */
    public void setPomProgrammerModel(PomProgrammerModel pomProgrammerModel) {
        this.pomProgrammerModel = pomProgrammerModel;
    }

    /**
     * @return the compositeDisposable
     */
    public CompositeDisposable getCompositeDisposable() {
        return compositeDisposable;
    }

    /**
     * @param compositeDisposable
     *            the compositeDisposable to set
     */
    public void setCompositeDisposable(CompositeDisposable compositeDisposable) {
        this.compositeDisposable = compositeDisposable;
    }

    /**
     * @return the pomRequestProcessor
     */
    public PomRequestProcessor<SpeedometerProgBeanModel> getPomRequestProcessor() {
        return pomRequestProcessor;
    }

    /**
     * @param pomRequestProcessor
     *            the pomRequestProcessor to set
     */
    public void setPomRequestProcessor(PomRequestProcessor<SpeedometerProgBeanModel> pomRequestProcessor) {
        this.pomRequestProcessor = pomRequestProcessor;
    }
}
