package org.bidib.wizard.mvc.main.view.statusbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

import org.bidib.wizard.api.model.listener.StatusListener;
import org.bidib.wizard.client.common.led.LED;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.mvc.main.model.StatusModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.status.StatusBarItem;

public class ConnectionStatusBarItem extends StatusBarItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionStatusBarItem.class);

    private static final long serialVersionUID = 1L;

    public enum Axis {
        lineAxis, pageAxis
    }

    public ConnectionStatusBarItem(StatusModel statusModel) {
        this(statusModel, Axis.lineAxis);
    }

    public ConnectionStatusBarItem(StatusModel statusModel, Axis axis) {
        super();

        Color colorOn = UIManager.getColor("ConnectionStatusBarItem.led_on");
        Color colorOff = UIManager.getColor("ConnectionStatusBarItem.led_off");

        if (colorOn == null) {
            colorOn = Color.red;
        }
        if (colorOff == null) {
            colorOff = Color.gray;
        }

        final LED connectLed = new LED(colorOn, colorOff, 1000);
        connectLed.setName("CD");

        setLedStatus(connectLed, statusModel.isCd());

        final LED receiveLed = new LED(colorOn, colorOff, 1000);
        receiveLed.setName("RX");

        setLedStatus(receiveLed, statusModel.isRx());

        final LED sendLed = new LED(colorOn, colorOff, 1000);
        sendLed.setName("TX");

        setLedStatus(sendLed, statusModel.isTx());

        final LED ctsLed = new LED(colorOn, colorOff, 1000);
        ctsLed.setName("CTS");

        setLedStatus(ctsLed, statusModel.isCd());

        if (Axis.pageAxis.equals(axis)) {
            setLayout(new GridBagLayout());

            GridBagConstraints c = new GridBagConstraints();

            c.anchor = GridBagConstraints.LINE_START;
            c.fill = GridBagConstraints.NONE;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(5, 3, 5, 3);
            c.weightx = 0;
            c.weighty = 0;
            add(connectLed, c);

            c.gridx++;
            add(receiveLed, c);

            c.gridx++;
            add(sendLed, c);

            c.gridx++;
            add(ctsLed, c);

            c.gridx = 0;
            c.gridy++;
            add(new JLabel("CD"), c);

            c.gridx++;
            add(new JLabel("RX"), c);

            c.gridx++;
            add(new JLabel("TX"), c);

            c.gridx++;
            add(new JLabel("CTS"), c);
        }
        else {
            connectLed.setBorder(new EmptyBorder(2, 4, 2, 4));
            receiveLed.setBorder(new EmptyBorder(2, 4, 2, 4));
            sendLed.setBorder(new EmptyBorder(2, 4, 2, 4));
            ctsLed.setBorder(new EmptyBorder(2, 4, 2, 4));

            setLayout(new BoxLayout(this, BoxLayout.LINE_AXIS));
            add(Box.createHorizontalGlue());
            add(new JLabel("CD"));
            add(Box.createRigidArea(new Dimension(3, 0)));
            add(connectLed);
            add(Box.createRigidArea(new Dimension(3, 0)));
            add(new JLabel("RX"));
            add(Box.createRigidArea(new Dimension(3, 0)));
            add(receiveLed);
            add(Box.createRigidArea(new Dimension(3, 0)));
            add(new JLabel("TX"));
            add(Box.createRigidArea(new Dimension(3, 0)));
            add(sendLed);
            add(Box.createRigidArea(new Dimension(3, 0)));
            add(new JLabel("CTS"));
            add(Box.createRigidArea(new Dimension(3, 0)));
            add(ctsLed);
            add(Box.createHorizontalGlue());
        }

        statusModel.addStatusListener(new StatusListener() {
            @Override
            public void cdChanged(boolean cd) {
                setLedStatus(connectLed, cd);
            }

            @Override
            public void runningChanged(boolean running) {
            }

            @Override
            public void rxChanged(boolean rx) {
                setLedStatus(receiveLed, rx);
            }

            @Override
            public void txChanged(boolean tx) {
                setLedStatus(sendLed, tx);
            }

            @Override
            public void ctsChanged(boolean cts) {
                setLedStatus(ctsLed, cts);
            }
        });
    }

    @Override
    public String getItemName() {
        return "ConnectionStatusBarItem";
    }

    /**
     * Sets the led status. As this will call the swing components we must be sure that the AWT-Thread is used to
     * perform the update.
     * 
     * @param led
     *            the led
     * @param on
     *            the led status to set
     */
    private void setLedStatus(final LED led, final boolean on) {
        LOGGER.trace("setLedStatus led: {}, on: {}", led.getName(), on);

        if (!isEnabled()) {
            LOGGER.trace("The led panel is disabled.");
            return;
        }

        SwingUtils.executeInEDT(() -> {
            if (on) {
                led.usePrimary();
            }
            else {
                led.useSecondary();
            }
        });
    }
}
