/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.accessory.view;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AccessoryAcknowledge;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.mvc.accessory.model.AccessoryModel;
import org.bidib.wizard.mvc.accessory.view.listener.AccessoryViewListener;
import org.bidib.wizard.mvc.accessory.view.panel.DccAccessoryPanel;
import org.bidib.wizard.mvc.accessory.view.panel.DccExtAccessoryPanel;
import org.bidib.wizard.mvc.accessory.view.panel.LogAreaAwarePanel;
import org.bidib.wizard.mvc.accessory.view.panel.listener.AccessoryResultListener;
import org.bidib.wizard.mvc.accessory.view.panel.listener.DccAccessoryRequestListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryView
extends EscapeDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryView.class);
    private static final long serialVersionUID = 1L;
    private final Collection<AccessoryViewListener> listeners = new LinkedList<AccessoryViewListener>();
    private final AccessoryModel accessoryModel;
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private final JTabbedPane tabbedPane;
    private final JPanel contentPanel;
    private final JButton clearButton = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"clearLogArea"));
    private final JButton closeButton = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"close"));
    private List<AccessoryResultListener> accessoryResultListeners = new LinkedList<AccessoryResultListener>();

    public AccessoryView(JFrame parent, AccessoryModel model, int x, int y) {
        super((Frame)parent, Resources.getString(AccessoryView.class, (String)"title"), false);
        this.accessoryModel = model;
        this.setLayout(new GridBagLayout());
        this.setLocation(x, y);
        this.tabbedPane = new JTabbedPane();
        DccAccessoryRequestListener accessoryRequestListener = new DccAccessoryRequestListener(){

            @Override
            public void sendRequest(AccessoryResultListener accessoryResultListener, AddressData dccAddress, int aspect, Integer switchTime, TimeBaseUnitEnum timeBaseUnit, TimingControlEnum timingControl) {
                LOGGER.info("Send request, accessoryResultListener: {}", (Object)accessoryResultListener);
                for (AccessoryResultListener resultListener : AccessoryView.this.accessoryResultListeners) {
                    resultListener.setActive(resultListener.equals(accessoryResultListener));
                }
                int selectedIndex = AccessoryView.this.tabbedPane.getSelectedIndex();
                LOGGER.info("Disable the unselected tabs, selectedIndex: {}", (Object)selectedIndex);
                for (int index = 0; index < AccessoryView.this.tabbedPane.getTabCount(); ++index) {
                    AccessoryView.this.tabbedPane.setEnabledAt(index, index == selectedIndex);
                }
                for (AccessoryViewListener l : AccessoryView.this.listeners) {
                    l.sendAccessoryRequest(dccAddress, aspect, switchTime, timeBaseUnit, timingControl);
                }
            }

            @Override
            public void sendRequest(AccessoryResultListener accessoryResultListener, AddressData dccAddress, int aspect, int coilState) {
                LOGGER.info("Send request, accessoryResultListener: {}", (Object)accessoryResultListener);
                for (AccessoryResultListener resultListener : AccessoryView.this.accessoryResultListeners) {
                    resultListener.setActive(resultListener.equals(accessoryResultListener));
                }
                int selectedIndex = AccessoryView.this.tabbedPane.getSelectedIndex();
                LOGGER.info("Disable the unselected tabs, selectedIndex: {}", (Object)selectedIndex);
                for (int index = 0; index < AccessoryView.this.tabbedPane.getTabCount(); ++index) {
                    AccessoryView.this.tabbedPane.setEnabledAt(index, index == selectedIndex);
                }
                for (AccessoryViewListener l : AccessoryView.this.listeners) {
                    l.sendAccessoryRequest(dccAddress, aspect, coilState);
                }
            }

            @Override
            public void sendRequest(AccessoryResultListener accessoryResultListener, AddressData dccAddress, int aspect) {
                LOGGER.info("Send request, accessoryResultListener: {}", (Object)accessoryResultListener);
                for (AccessoryResultListener resultListener : AccessoryView.this.accessoryResultListeners) {
                    resultListener.setActive(resultListener.equals(accessoryResultListener));
                }
                int selectedIndex = AccessoryView.this.tabbedPane.getSelectedIndex();
                LOGGER.info("Disable the unselected tabs, selectedIndex: {}", (Object)selectedIndex);
                for (int index = 0; index < AccessoryView.this.tabbedPane.getTabCount(); ++index) {
                    AccessoryView.this.tabbedPane.setEnabledAt(index, index == selectedIndex);
                }
                for (AccessoryViewListener l : AccessoryView.this.listeners) {
                    l.sendExtendedAccessoryRequest(dccAddress, aspect);
                }
            }
        };
        DccAccessoryPanel dccAccessoryPanel = new DccAccessoryPanel(this.accessoryModel);
        dccAccessoryPanel.addAccessoryRequestListener(accessoryRequestListener);
        this.accessoryResultListeners.add(dccAccessoryPanel);
        DccExtAccessoryPanel dccExtAccessoryPanel = new DccExtAccessoryPanel(this.accessoryModel);
        dccExtAccessoryPanel.addAccessoryRequestListener(accessoryRequestListener);
        this.accessoryResultListeners.add(dccExtAccessoryPanel);
        this.tabbedPane.addTab(Resources.getString(((Object)((Object)this)).getClass(), (String)"tab-normal"), null, dccAccessoryPanel.createPanel(), Resources.getString(((Object)((Object)this)).getClass(), (String)"tab-normal.tooltip"));
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(Resources.getString(((Object)((Object)this)).getClass(), (String)"tab-extended"), null, dccExtAccessoryPanel.createPanel(), Resources.getString(((Object)((Object)this)).getClass(), (String)"tab-extended.tooltip"));
        this.tabbedPane.setMnemonicAt(1, 50);
        boolean debug = false;
        FormBuilder dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows("fill:p:grow, 3dlu, p", new Object[0]).panel((JPanel)(debug ? new FormDebugPanel() : new JPanel()));
        dialogBuilder.border((Border)Paddings.DIALOG);
        dialogBuilder.add((Component)this.tabbedPane).xyw(1, 1, 3);
        JPanel buttons = new ButtonBarBuilder().addButton((JComponent)this.clearButton).addGlue().addButton((JComponent)this.closeButton).build();
        dialogBuilder.add((Component)buttons).xyw(1, 3, 3);
        this.clearButton.addActionListener(evt -> {
            Component comp = this.tabbedPane.getSelectedComponent();
            if (comp instanceof LogAreaAwarePanel) {
                ((LogAreaAwarePanel)comp).clearLogArea();
            }
        });
        this.contentPanel = dialogBuilder.build();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.closeButton.addActionListener(evt -> this.tryCloseDialog());
        this.accessoryModel.addPropertyChangeListener("acknowledge", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                final AccessoryAcknowledge acknowledge = AccessoryView.this.accessoryModel.getAcknowledge();
                LOGGER.info("Accessory acknowledge has changed: {}", (Object)acknowledge);
                if (SwingUtilities.isEventDispatchThread()) {
                    AccessoryView.this.signalAcknowledgeChanged(acknowledge);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AccessoryView.this.signalAcknowledgeChanged(acknowledge);
                        }
                    });
                }
            }
        });
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setVisible(true);
    }

    protected void performCancelAction(KeyEvent e) {
        this.tryCloseDialog();
    }

    private void tryCloseDialog() {
        this.setVisible(false);
        this.fireClose();
    }

    private void fireClose() {
        for (AccessoryViewListener l : this.listeners) {
            l.close();
        }
    }

    public void addAccessoryViewListener(AccessoryViewListener l) {
        this.listeners.add(l);
    }

    private void signalAcknowledgeChanged(AccessoryAcknowledge acknowledge) {
        if (acknowledge != null) {
            LOGGER.info("Enable the tabs");
            for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
                this.tabbedPane.setEnabledAt(index, true);
            }
        }
        for (AccessoryResultListener listener : this.accessoryResultListeners) {
            listener.signalAcknowledgeChanged(acknowledge);
        }
    }
}

