/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.accessory.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.PropertyValidationSupport;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AccessoryAcknowledge;
import org.bidib.jbidibc.messages.enums.AccessoryAddressingEnum;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.mvc.accessory.model.AccessoryBeanModel;
import org.bidib.wizard.mvc.accessory.model.AccessoryModel;
import org.bidib.wizard.mvc.accessory.view.panel.AccessoryValidationResultModel;
import org.bidib.wizard.mvc.accessory.view.panel.LogAreaAwarePanel;
import org.bidib.wizard.mvc.accessory.view.panel.RCN213Converter;
import org.bidib.wizard.mvc.accessory.view.panel.listener.AccessoryResultListener;
import org.bidib.wizard.mvc.accessory.view.panel.listener.DccAccessoryRequestListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractAccessoryPanel<T extends AccessoryBeanModel>
implements AccessoryResultListener {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "p";
    private final List<DccAccessoryRequestListener> listeners = new LinkedList<DccAccessoryRequestListener>();
    protected AccessoryValidationResultModel accessoryValidationModel;
    private ValueModel addressValueModel;
    private JComponent[] addressingButtons;
    private static final String NEWLINE = "\n";
    private JTextArea loggerArea;
    protected boolean activeTab;
    private static final int MIN_ADDRESS = 0;
    private static final int MIN_SWITCHTIME = 1;
    private static final int MAX_SWITCHTIME = 127;

    public AbstractAccessoryPanel(AccessoryModel accessoryModel) {
    }

    protected abstract T getAccessoryBeanModel();

    public JPanel createPanel() {
        FormBuilder builder;
        Object panel;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        builder.border((Border)Paddings.DIALOG);
        int currentRow = 1;
        this.accessoryValidationModel = new AccessoryValidationResultModel();
        this.addressValueModel = new PropertyAdapter(this.getAccessoryBeanModel(), "dccAddress", true);
        ConverterValueModel addressConverterModel = new ConverterValueModel(this.addressValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField addressText = new JTextField();
        InputValidationDocument addressDocument = new InputValidationDocument(4, "0123456789");
        addressText.setDocument((Document)addressDocument);
        addressText.setColumns(4);
        Bindings.bind((JTextField)addressText, (ValueModel)addressConverterModel, (boolean)false);
        builder.add(Resources.getString(AbstractAccessoryPanel.class, (String)"dcc-address"), new Object[0]).xy(1, currentRow);
        builder.add((Component)addressText).xy(3, currentRow);
        ValidationComponentUtils.setMandatory((JComponent)addressText, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)addressText, (Object[])new Object[]{"validation.address_key"});
        JLabel addressingLabel = new JLabel(Resources.getString(AbstractAccessoryPanel.class, (String)"addressing"));
        builder.add((Component)addressingLabel).xy(5, currentRow);
        addressingLabel.setHorizontalAlignment(11);
        PropertyAdapter addressingModel = new PropertyAdapter(this.getAccessoryBeanModel(), "accessoryAddressing", true);
        this.addressingButtons = new JComponent[AccessoryAddressingEnum.values().length];
        int index = 0;
        int column = 7;
        for (AccessoryAddressingEnum accessoryAddressing : AccessoryAddressingEnum.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)addressingModel, (Object)accessoryAddressing, (String)Resources.getString(AccessoryAddressingEnum.class, (String)accessoryAddressing.getKey()));
            radio.setToolTipText(Resources.getString(AccessoryAddressingEnum.class, (String)(accessoryAddressing.getKey() + ".tooltip")));
            this.addressingButtons[index++] = radio;
            builder.add((Component)radio).xy(column, currentRow);
            column += 2;
        }
        PropertyAdapter directAddressValueModel = new PropertyAdapter(this.getAccessoryBeanModel(), "dccAddress", true);
        ConverterValueModel directAddressConverterModel = new ConverterValueModel((ValueModel)directAddressValueModel, (BindingConverter)new RCN213Converter((ValueModel)addressingModel, new DecimalFormat("#")));
        JTextField directAddressText = new JTextField();
        directAddressText.setColumns(4);
        Bindings.bind((JTextField)directAddressText, (ValueModel)directAddressConverterModel, (boolean)false);
        builder.add((Component)directAddressText).xy(11, 1);
        directAddressText.setEditable(false);
        directAddressText.setEnabled(false);
        int[] rowHolder = new int[]{currentRow};
        this.addSpecificComponents(builder, rowHolder);
        currentRow = rowHolder[0];
        this.loggerArea = new JTextArea(10, 45);
        this.loggerArea.setFont(UIManager.getDefaults().getFont("Label.font"));
        JScrollPane scrollLog = new JScrollPane();
        scrollLog.getViewport().add(this.loggerArea);
        builder.appendRows("3dlu, fill:100dlu:grow", new Object[0]);
        builder.add((Component)scrollLog).xyw(1, currentRow += 2, 11);
        this.getAccessoryBeanModel().addPropertyChangeListener("dccAddress", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractAccessoryPanel.this.LOGGER.debug("DCC address has changed: {}", (Object)((AccessoryBeanModel)((Object)AbstractAccessoryPanel.this.getAccessoryBeanModel())).getDccAddress());
                AbstractAccessoryPanel.this.triggerValidation();
            }
        });
        this.getAccessoryBeanModel().addPropertyChangeListener("accessoryAddressing", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractAccessoryPanel.this.LOGGER.debug("Accessory addressing has changed: {}", (Object)((AccessoryBeanModel)((Object)AbstractAccessoryPanel.this.getAccessoryBeanModel())).getAccessoryAddressing());
                Integer dccAddress = ((AccessoryBeanModel)((Object)AbstractAccessoryPanel.this.getAccessoryBeanModel())).getDccAddress();
                if (dccAddress != null) {
                    ((AccessoryBeanModel)((Object)AbstractAccessoryPanel.this.getAccessoryBeanModel())).setDccAddress(null);
                    ((AccessoryBeanModel)((Object)AbstractAccessoryPanel.this.getAccessoryBeanModel())).setDccAddress(dccAddress);
                }
            }
        });
        this.getAccessoryBeanModel().addPropertyChangeListener("switchTime", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractAccessoryPanel.this.LOGGER.debug("Switch time has changed: {}", (Object)((AccessoryBeanModel)((Object)AbstractAccessoryPanel.this.getAccessoryBeanModel())).getSwitchTime());
                AbstractAccessoryPanel.this.triggerValidation();
            }
        });
        this.addSpecificValidation();
        this.LOGGER.debug("Create iconfeedback panel.");
        IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.accessoryValidationModel, (JComponent)builder.build());
        FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel((JPanel)new LogAreaAwarePanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void clearLogArea() {
                AbstractAccessoryPanel.this.clearLogArea();
            }
        });
        feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
        JPanel panel2 = feedbackBuilder.build();
        this.triggerValidation();
        return panel2;
    }

    protected abstract void addSpecificComponents(FormBuilder var1, int[] var2);

    protected abstract void addSpecificValidation();

    public void addAccessoryRequestListener(DccAccessoryRequestListener listener) {
        this.listeners.add(listener);
    }

    protected List<DccAccessoryRequestListener> getAccessoryRequestListeners() {
        return this.listeners;
    }

    protected void sendRequest(AddressData dccAddress, Integer aspect, Integer switchTime, TimeBaseUnitEnum timeBaseUnit, TimingControlEnum timingControl) {
        this.disableInputElements();
        for (DccAccessoryRequestListener listener : this.getAccessoryRequestListeners()) {
            listener.sendRequest(this, dccAddress, aspect, switchTime, timeBaseUnit, timingControl);
        }
    }

    protected void sendRequest(AddressData dccAddress, int aspect, int coilState) {
        this.disableInputElements();
        for (DccAccessoryRequestListener listener : this.getAccessoryRequestListeners()) {
            listener.sendRequest(this, dccAddress, aspect, coilState);
        }
    }

    protected void sendRequest(AddressData dccAddress, Integer aspect) {
        this.disableInputElements();
        for (DccAccessoryRequestListener listener : this.getAccessoryRequestListeners()) {
            listener.sendRequest(this, dccAddress, aspect);
        }
    }

    @Override
    public void signalAcknowledgeChanged(AccessoryAcknowledge acknowledge) {
        if (!this.isActive()) {
            this.LOGGER.info("Do not process result because this is not the active tab.");
            return;
        }
        this.LOGGER.info("Accessory acknowledge has changed: {}", (Object)acknowledge);
        if (acknowledge != null) {
            this.addLogText("Received acknowledge: {}", acknowledge);
            this.enableInputElements();
        }
    }

    @Override
    public void setActive(boolean active) {
        this.LOGGER.info("Set the active flag: {}", (Object)active);
        this.activeTab = active;
    }

    @Override
    public boolean isActive() {
        return this.activeTab;
    }

    protected void disableInputElements() {
    }

    protected void enableInputElements() {
    }

    public void clearLogArea() {
        if (this.loggerArea != null) {
            this.loggerArea.setText(null);
        }
    }

    @Override
    public void addLogText(String logLine, Object ... args) {
        this.LOGGER.info("Add text to loggerArea, logLine: {}, args: {}", (Object)logLine, (Object)args);
        if (args != null) {
            logLine = MessageFormatter.arrayFormat((String)logLine, (Object[])args).getMessage();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS - ");
        final StringBuilder message = new StringBuilder(sdf.format(new Date()));
        message.append(logLine).append(NEWLINE);
        if (SwingUtilities.isEventDispatchThread()) {
            this.loggerArea.append(message.toString());
            this.loggerArea.setCaretPosition(this.loggerArea.getDocument().getLength());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractAccessoryPanel.this.loggerArea.append(message.toString());
                    AbstractAccessoryPanel.this.loggerArea.setCaretPosition(AbstractAccessoryPanel.this.loggerArea.getDocument().getLength());
                }
            });
        }
    }

    protected abstract int getMaxAddress();

    private ValidationResult validate() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport(this.getAccessoryBeanModel(), "validation");
        if (((AccessoryBeanModel)((Object)this.getAccessoryBeanModel())).getDccAddress() == null) {
            support.addError("address_key", "not_empty");
        } else if (((AccessoryBeanModel)((Object)this.getAccessoryBeanModel())).getDccAddress() < 0 || ((AccessoryBeanModel)((Object)this.getAccessoryBeanModel())).getDccAddress() > this.getMaxAddress()) {
            support.addError("address_key", "invalid_value;min=0,max=" + this.getMaxAddress());
        }
        if (((AccessoryBeanModel)((Object)this.getAccessoryBeanModel())).getSwitchTime() == null) {
            support.addError("switchtime_key", "not_empty");
        } else if (((AccessoryBeanModel)((Object)this.getAccessoryBeanModel())).getSwitchTime() < 1 || ((AccessoryBeanModel)((Object)this.getAccessoryBeanModel())).getSwitchTime() > 127) {
            support.addError("switchtime_key", "invalid_value;min=1,max=127");
        }
        this.validateSpecificPanel((PropertyValidationSupport)support);
        ValidationResult validationResult = support.getResult();
        this.LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    protected abstract void validateSpecificPanel(PropertyValidationSupport var1);

    protected void triggerValidation() {
        ValidationResult validationResult = this.validate();
        this.accessoryValidationModel.setResult(validationResult);
    }
}

