/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.text;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import org.bidib.wizard.mvc.common.view.text.HistoryModelSaver;
import org.bidib.wizard.mvc.common.view.text.MutableListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryModel
extends DefaultListModel
implements MutableListModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryModel.class);
    private static int max;
    private String name;
    private static Map<String, HistoryModel> models;
    private static boolean modified;
    private static HistoryModelSaver saver;

    public HistoryModel(String name) {
        this.name = name;
    }

    public void addItem(String text) {
        LOGGER.info("Add new item: {}", (Object)text);
        if (text == null || text.length() == 0) {
            return;
        }
        int index = this.indexOf(text);
        if (index != -1) {
            this.removeElementAt(index);
        }
        this.insertElementAt(text, 0);
        while (this.getSize() > max) {
            this.removeElementAt(this.getSize() - 1);
        }
    }

    @Override
    public void insertElementAt(Object obj, int index) {
        modified = true;
        super.insertElementAt(obj, index);
    }

    public String getItem(int index) {
        return (String)this.elementAt(index);
    }

    @Override
    public boolean removeElement(Object obj) {
        modified = true;
        return super.removeElement(obj);
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    @Override
    public void removeAllElements() {
        modified = true;
        super.removeAllElements();
    }

    public String getName() {
        return this.name;
    }

    public static HistoryModel getModel(String name) {
        HistoryModel model;
        if (models == null) {
            models = Collections.synchronizedMap(new HashMap());
        }
        if ((model = models.get(name)) == null) {
            model = new HistoryModel(name);
            models.put(name, model);
        }
        return model;
    }

    public static void loadHistory() {
        if (saver != null) {
            models = saver.load(models);
        }
    }

    public static void saveHistory() {
        if (saver != null && modified && saver.save(models)) {
            modified = false;
        }
    }

    public static void setMax(int max) {
        HistoryModel.max = max;
    }

    public static void setSaver(HistoryModelSaver saver) {
        HistoryModel.saver = saver;
    }
}

