/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.features.view;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.WindowUtils;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.utils.WindowPositionUtils;
import org.bidib.wizard.mvc.features.model.FeaturesModel;
import org.bidib.wizard.mvc.features.view.listener.FeaturesViewListener;
import org.bidib.wizard.mvc.features.view.panel.FeaturesPanel;
import org.bidib.wizard.mvc.features.view.panel.listener.FeaturesWriteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesView
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesView.class);
    private static final long serialVersionUID = 1L;
    private final Collection<FeaturesViewListener> listeners = new HashSet<FeaturesViewListener>();
    private final JButton saveButton = new JButton(Resources.getString(this.getClass(), (String)"save"));
    private final JButton cancelButton = new JButton(Resources.getString(this.getClass(), (String)"cancel"));
    private final FeaturesPanel featuresPanel;
    private final WizardSettingsInterface wizardSettings;

    public FeaturesView(JFrame parent, FeaturesModel model, WizardSettingsInterface wizardSettings) {
        super(parent);
        this.wizardSettings = wizardSettings;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FeaturesView.this.cancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.setTitle(Resources.getString(this.getClass(), (String)"title", (Object[])new Object[]{model.getNode()}));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(Paddings.DIALOG.getBorderInsets()));
        String encodedWindowSize = this.wizardSettings.getWindowSize("features");
        Rectangle screenBounds = WindowUtils.getScreenWorkingArea((Window)parent);
        Dimension size = new Dimension(600, 500);
        Point location = new Point(screenBounds.x, screenBounds.y);
        if (encodedWindowSize != null) {
            try {
                size = WindowPositionUtils.decodeWindowSize((String)encodedWindowSize);
            }
            catch (Exception ex) {
                LOGGER.warn("Decode window size failed.", (Throwable)ex);
            }
            try {
                location = WindowPositionUtils.decodeWindowPos((String)encodedWindowSize);
            }
            catch (Exception ex) {
                LOGGER.warn("Decode window position failed.", (Throwable)ex);
            }
        }
        if (size.width > screenBounds.width - 50) {
            size.width = screenBounds.width - 50;
            LOGGER.info("Reduced width: {}", (Object)size.width);
        }
        if (size.height > screenBounds.height - 50) {
            size.height = screenBounds.height - 50;
            LOGGER.info("Reduced height: {}", (Object)size.height);
        }
        if (location.x < 0 || location.x > screenBounds.x + screenBounds.width) {
            location.x = screenBounds.x;
            LOGGER.info("Reduced location.x: {}", (Object)location.x);
        }
        if (location.y < 0 || location.y > screenBounds.y + screenBounds.height) {
            location.y = screenBounds.y + 10;
            LOGGER.info("Reduced location.y: {}", (Object)location.y);
        }
        mainPanel.setPreferredSize(size);
        this.featuresPanel = new FeaturesPanel(model);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.featuresPanel.getTable());
        mainPanel.add((Component)scroll, "Center");
        this.featuresPanel.addFeaturesWriteListener(new FeaturesWriteListener(){

            @Override
            public void write(Collection<Feature> features) {
                FeaturesView.this.fireWrite(features);
            }
        });
        this.saveButton.addActionListener(evt -> this.save());
        this.cancelButton.addActionListener(evt -> this.cancel());
        JPanel buttons = ((ButtonBarBuilder)new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.saveButton, this.cancelButton}).border((Border)Paddings.DLU2)).build();
        mainPanel.add((Component)buttons, "South");
        this.getContentPane().add(mainPanel);
        this.pack();
        this.setLocation(location);
        int buttonWidth = Math.max(this.saveButton.getWidth(), this.cancelButton.getWidth());
        this.saveButton.setPreferredSize(new Dimension(buttonWidth, this.saveButton.getSize().height));
        this.cancelButton.setPreferredSize(new Dimension(buttonWidth, this.cancelButton.getSize().height));
    }

    public void addFeaturesViewListener(FeaturesViewListener listener) {
        this.listeners.add(listener);
    }

    private void save() {
        LOGGER.debug("Save the changed features.");
        this.featuresPanel.writeFeatures();
        this.setVisible(false);
        this.fireClose();
    }

    private void cancel() {
        this.setVisible(false);
        this.fireClose();
    }

    private void fireClose() {
        String encodedWindowSize = WindowPositionUtils.encodedWindowPosition((Point)this.getLocation(), (Dimension)this.getSize(), (int)0);
        if (encodedWindowSize != null) {
            this.wizardSettings.setWindowSize("features", encodedWindowSize);
        }
        for (FeaturesViewListener listener : this.listeners) {
            listener.close();
        }
    }

    private void fireWrite(Collection<Feature> features) {
        for (FeaturesViewListener listener : this.listeners) {
            listener.write(features);
        }
    }
}

