/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import com.jidesoft.alert.Alert;
import com.jidesoft.alert.AlertGroup;
import com.jidesoft.animation.CustomAnimation;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PaintPanel;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.collection.SynchronizedCollection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.api.json.types.SerialPortInfo;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.common.NetBidibServiceInfo;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.bidib.wizard.api.model.event.ConsoleMessageEvent;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.client.common.alert.BidibAlert;
import org.bidib.wizard.client.common.event.BidibConnectionEvent;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.service.SystemInfoService;
import org.bidib.wizard.discovery.listener.NetBidibServiceListener;
import org.bidib.wizard.mvc.main.controller.listener.AlertListener;
import org.bidib.wizard.mvc.main.view.MainView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

public class AlertController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlertController.class);
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private SystemInfoService systemInfoService;
    @Autowired
    private StatusBar statusBar;
    @Autowired
    private List<NetBidibServiceListener> netBidibServiceListeners;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    private final BidibAlertGroup alertGroup;
    private CompositeDisposable dispUsbPortEvents = new CompositeDisposable();
    private CompositeDisposable dispNetBidibServiceListenerEvents = new CompositeDisposable();
    private final MainView mainView;
    private final List<AlertListener> alertListeners = new LinkedList<AlertListener>();

    public AlertController(MainView mainView) {
        this.mainView = mainView;
        this.alertGroup = new BidibAlertGroup();
    }

    public void start() {
        Disposable disposable = this.systemInfoService.subscribeUsbPortEvents(upe -> {
            LOGGER.info("Publish the USB port event: {}", upe);
            SerialPortInfo serialPort = upe.getSerialPort();
            switch (upe.getAction()) {
                case INSERTED: {
                    this.usbDeviceAdded(serialPort);
                    break;
                }
                default: {
                    this.usbDeviceRemoved(serialPort);
                }
            }
        }, error -> LOGGER.warn("The USB port event signalled a failure: {}", error));
        this.dispUsbPortEvents.add(disposable);
        List registeredPorts = this.systemInfoService.getRegisteredSerialPorts();
        for (SerialPortInfo port : registeredPorts) {
            this.usbDeviceAdded(port);
        }
        if (CollectionUtils.isNotEmpty(this.netBidibServiceListeners)) {
            for (NetBidibServiceListener listener : this.netBidibServiceListeners) {
                Disposable disp = listener.subscribeNetBidibServiceEvents(sie -> {
                    LOGGER.info("Received netBidibServiceEvent: {}", sie);
                    try {
                        switch (sie.getAction()) {
                            case RESOLVED: {
                                this.netBidibServiceResolved((NetBidibServiceInfo)sie);
                                break;
                            }
                            case REMOVED: {
                                this.netBidibServiceRemoved((NetBidibServiceInfo)sie);
                                break;
                            }
                            default: {
                                LOGGER.warn("Unhandled action in event: {}", sie);
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Publish changed netBidib service info event failed.", (Throwable)ex);
                    }
                }, error -> LOGGER.warn("The netBidibServiceListener event signalled a failure: {}", error));
                this.dispNetBidibServiceListenerEvents.add(disp);
            }
        }
    }

    public void stopWatcher() {
        this.dispUsbPortEvents.dispose();
        this.dispNetBidibServiceListenerEvents.dispose();
    }

    private void netBidibServiceResolved(NetBidibServiceInfo sie) {
        String text;
        StringBuilder sb = new StringBuilder();
        InetAddress address = sie.getAddresses()[0];
        LOGGER.info("Provided address: {}, port: {}", (Object)address, (Object)sie.getPort());
        sb.append(PreferencesPortType.ConnectionPortType.NetBidibClient.name()).append(':').append(address.getHostName()).append(':').append(sie.getPort());
        String highlightText = text = "<HTML><B>" + Resources.getString(AlertController.class, (String)"message.netbidib-device-resolved") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">" + Resources.getString(AlertController.class, (String)"message.product", (Object[])new Object[]{sie.getProps().get("prod")}) + "<BR>" + Resources.getString(AlertController.class, (String)"message.username", (Object[])new Object[]{sie.getProps().getOrDefault("user", "")}) + "<BR>IP: " + address.getHostAddress() + "</FONT></HTML>";
        String portName = sb.toString();
        try {
            SwingUtils.executeInEDT(() -> {
                BidibAlert<NetBidibServiceInfo> alert = this.createAlert(portName, text, highlightText, sie);
                this.notifyAlertAddedListeners(alert, AlertListener.AlertAction.DEVICE_ADDED);
                this.showAlert(alert, AlertListener.AlertAction.DEVICE_ADDED, (Component)this.mainView.getFrame());
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Show resolved event failed.", (Throwable)ex);
        }
        try {
            String messageText = Resources.getString(AlertController.class, (String)"message.netbidib-device-resolved") + ", " + Resources.getString(AlertController.class, (String)"message.product", (Object[])new Object[]{sie.getProps().get("prod")}) + ", " + Resources.getString(AlertController.class, (String)"message.username", (Object[])new Object[]{sie.getProps().getOrDefault("user", "")}) + ", IP: " + address.getHostAddress();
            this.applicationEventPublisher.publishEvent((Object)new ConsoleMessageEvent(ConsoleColor.black, messageText));
        }
        catch (Exception ex) {
            LOGGER.warn("Publish console event of netBiDiB device resolved failed.");
        }
    }

    private String getColor(String colorKey) {
        Color color = UIDefaultsLookup.getColor((Object)colorKey);
        return String.format("#%06x", color.getRGB() & 0xFFFFFF);
    }

    private void netBidibServiceRemoved(NetBidibServiceInfo sie) {
        String text;
        StringBuilder sb = new StringBuilder();
        InetAddress address = sie.getAddresses()[0];
        LOGGER.info("Provided address: {}", (Object)address);
        sb.append(PreferencesPortType.ConnectionPortType.NetBidibClient.name()).append(':').append(address.getHostName()).append(':').append(sie.getPort());
        String highlightText = text = "<HTML><B>" + Resources.getString(AlertController.class, (String)"message.netbidib-device-removed") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">" + Resources.getString(AlertController.class, (String)"message.product", (Object[])new Object[]{sie.getProps().get("prod")}) + "<BR>" + Resources.getString(AlertController.class, (String)"message.username", (Object[])new Object[]{sie.getProps().getOrDefault("user", "")}) + "<BR>IP: " + address.getHostAddress() + "</FONT></HTML>";
        String portName = sb.toString();
        try {
            SwingUtilities.invokeLater(() -> {
                BidibAlert<NetBidibServiceInfo> alert = this.createAlert(portName, highlightText, highlightText, sie);
                this.notifyAlertAddedListeners(alert, AlertListener.AlertAction.DEVICE_REMOVED);
                this.showAlert(alert, AlertListener.AlertAction.DEVICE_REMOVED, (Component)this.mainView.getFrame());
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Show removed event failed.", (Throwable)ex);
        }
    }

    private void usbDeviceRemoved(SerialPortInfo serialPort) {
        try {
            String text = "<HTML><B>" + Resources.getString(AlertController.class, (String)"message.usb-device-removed") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">VID: 0x" + serialPort.getVendorId() + "&nbsp;PID: 0x" + serialPort.getProductId() + "<BR>Serial number: " + serialPort.getSerialNumber() + "<BR>Product: " + serialPort.getProductString() + "<BR>COM Port: " + serialPort.getPortName() + "</FONT></HTML>";
            String highlightText = "<HTML><U><B>" + Resources.getString(AlertController.class, (String)"message.usb-device-removed") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">VID: 0x" + serialPort.getVendorId() + "&nbsp;PID: 0x" + serialPort.getProductId() + "<BR>Serial number: " + serialPort.getSerialNumber() + "<BR>Product: " + serialPort.getProductString() + "<BR>COM Port: " + serialPort.getPortName() + "</FONT><U></HTML>";
            SwingUtilities.invokeLater(() -> {
                BidibAlert<SerialPortInfo> alert = this.createAlert(null, text, highlightText, serialPort);
                this.notifyAlertAddedListeners(alert, AlertListener.AlertAction.DEVICE_REMOVED);
                this.showAlert(alert, AlertListener.AlertAction.DEVICE_REMOVED, (Component)this.mainView.getFrame());
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Show device removed alert failed.", (Throwable)ex);
        }
    }

    private void usbDeviceAdded(SerialPortInfo serialPort) {
        try {
            String text = "<HTML><B>" + Resources.getString(AlertController.class, (String)"message.usb-device-resolved") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">VID: 0x" + serialPort.getVendorId() + "&nbsp;PID: 0x" + serialPort.getProductId() + "<BR>Serial number: " + serialPort.getSerialNumber() + "<BR>Product: " + serialPort.getProductString() + "<BR>Manufacturer: " + serialPort.getManufacturerString() + "<BR>COM Port: " + serialPort.getPortName() + "</FONT></HTML>";
            String highlightText = "<HTML><U><B>" + Resources.getString(AlertController.class, (String)"message.usb-device-resolved") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">VID: 0x" + serialPort.getVendorId() + "&nbsp;PID: 0x" + serialPort.getProductId() + "<BR>Serial number: " + serialPort.getSerialNumber() + "<BR>Product: " + serialPort.getProductString() + "<BR>Manufacturer: " + serialPort.getManufacturerString() + "<BR>COM Port: " + serialPort.getPortName() + "</FONT><U></HTML>";
            String comPort = serialPort.getPortName();
            String serialNumber = serialPort.getSerialNumber();
            SwingUtilities.invokeLater(() -> {
                String portInfo = "SerialPort:" + comPort;
                if (serialNumber != null) {
                    portInfo = "SerialPort:" + comPort + " - " + serialNumber;
                }
                BidibAlert<SerialPortInfo> alert = this.createAlert(portInfo, text, highlightText, serialPort);
                LOGGER.info("Created alert: {}", alert);
                this.notifyAlertAddedListeners(alert, AlertListener.AlertAction.DEVICE_ADDED);
                this.showAlert(alert, AlertListener.AlertAction.DEVICE_ADDED, (Component)this.mainView.getFrame());
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Show device added alert failed.", (Throwable)ex);
        }
    }

    public void showAlert(BidibAlert<?> alert, AlertListener.AlertAction action, Component owner) {
        WizardSettingsInterface wizardSettings;
        if (action == AlertListener.AlertAction.DEVICE_ADDED) {
            this.applicationEventPublisher.publishEvent((Object)new ConsoleMessageEvent(ConsoleColor.black, "New device detected: " + alert.getComPort(), false));
        }
        if (!(wizardSettings = this.settingsService.getWizardSettings()).isShowNewDeviceAlert()) {
            LOGGER.info("Show new device alert is disabled in configuration (wizard settings).");
            return;
        }
        this.alertGroup.add((Alert)alert);
        alert.setAlertGroup((AlertGroup)this.alertGroup);
        this.alertGroup.add((Alert)alert);
        LOGGER.info("Show the alert: {}, owner: {}", alert, (Object)owner);
        alert.showPopup(4, owner);
    }

    private <T> BidibAlert<T> createAlert(final String comPort, String text, String highlightText, T serialPort) {
        final BidibAlert alert = new BidibAlert(comPort, serialPort);
        alert.getContentPane().setLayout(new BorderLayout());
        ActionListener flagAction = null;
        if (StringUtils.isNotBlank((CharSequence)comPort)) {
            flagAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.info("Use the port to connect: {}", (Object)comPort);
                    PreferencesPortType portType = PreferencesPortType.getValue((String)comPort);
                    AlertController.this.settingsService.setSelectedPortType("main", portType);
                    AlertController.this.settingsService.storeSettings();
                    AlertController.this.statusBar.setStatusText(Resources.getString(AlertController.class, (String)"message.comport-selected", (Object[])new Object[]{comPort}));
                    AlertGroup alertGroup = alert.getAlertGroup();
                    alert.hidePopupImmediately();
                    if (alertGroup instanceof BidibAlertGroup) {
                        BidibAlertGroup bidibAlertGroup = (BidibAlertGroup)alertGroup;
                        bidibAlertGroup.remove((Alert)alert);
                        LinkedList<Alert> alerts = new LinkedList<Alert>(bidibAlertGroup.getAlerts());
                        LOGGER.info("Current alerts in AlertGroup: {}", alerts);
                        for (Alert current : alerts) {
                            try {
                                LOGGER.info("Hide alert: {}", (Object)current);
                                current.hidePopupImmediately();
                                bidibAlertGroup.remove(current);
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Hide alert failed.", (Throwable)ex);
                            }
                            AlertController.this.notifyAlertRemoveListeners(alert);
                        }
                    } else {
                        LOGGER.info("No AlertGroup assigned to alert: {}", (Object)alert);
                    }
                    try {
                        LOGGER.info("Try to connect to port: {}", (Object)comPort);
                        AlertController.this.applicationEventPublisher.publishEvent((Object)new BidibConnectionEvent("main", BidibConnectionEvent.Action.connect));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Connect to port failed: {}", (Object)comPort, (Object)ex);
                    }
                }
            };
        } else {
            LOGGER.warn("No comPort identifier provided.");
        }
        alert.getContentPane().add(this.createUSBSerialAlert(flagAction, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("The user clicked on the alert: {}", (Object)alert);
                try {
                    alert.hidePopupImmediately();
                }
                catch (Exception ex) {
                    LOGGER.warn("Hide popup immediately failed.", (Throwable)ex);
                }
                AlertController.this.notifyAlertRemoveListeners(alert);
            }
        }, text, highlightText));
        alert.setResizable(true);
        alert.setMovable(true);
        alert.setTransient(true);
        boolean showFadeAnimation = SystemUtils.IS_OS_WINDOWS;
        if (showFadeAnimation) {
            CustomAnimation animation = new CustomAnimation(0, showFadeAnimation ? 201 : 100, 50, 100){
                private static final long serialVersionUID = 1L;

                public void start(Component source) {
                    try {
                        super.start(source);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Start show animation failed.", (Throwable)ex);
                    }
                }
            };
            animation.setFunctionFade(CustomAnimation.FUNC_BOUNCE);
            alert.setShowAnimation(animation);
        }
        if (showFadeAnimation) {
            CustomAnimation animationExit = new CustomAnimation(1, showFadeAnimation ? 201 : 100, 50, 100){
                private static final long serialVersionUID = 1L;

                public void start(Component source) {
                    LOGGER.info("The alert is removed: {}", (Object)alert);
                    try {
                        super.start(source);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Start exit animation failed.", (Throwable)ex);
                    }
                }
            };
            animationExit.setFunctionFade(CustomAnimation.FUNC_POW_HALF);
            alert.setHideAnimation(animationExit);
        }
        alert.addPropertyChangeListener("visible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("Received pce: {}", (Object)evt);
                if (Boolean.FALSE.equals(evt.getNewValue())) {
                    LOGGER.info("Remove alert from list: {}", (Object)alert);
                    try {
                        AlertGroup alertGroup = alert.getAlertGroup();
                        if (alertGroup instanceof BidibAlertGroup) {
                            BidibAlertGroup bidibAlertGroup = (BidibAlertGroup)alertGroup;
                            bidibAlertGroup.remove((Alert)alert);
                        } else {
                            LOGGER.info("No AlertGroup assigned to alert: {}", (Object)alert);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Remove alert from group failed.", (Throwable)ex);
                    }
                    AlertController.this.notifyAlertRemoveListeners(alert);
                }
            }
        });
        return alert;
    }

    private JideButton createButton(Icon icon) {
        JideButton button = new JideButton(icon);
        return button;
    }

    private JComponent createUSBSerialAlert(ActionListener flagAction, ActionListener closeAction, final String text, final String highlightText) {
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        if (flagAction != null) {
            JideButton flagButton = this.createButton(ImageUtils.createImageIcon(this.getClass(), (String)"/icons/16x16/connect.png"));
            flagButton.addActionListener(flagAction);
            bottomPanel.add((Component)flagButton);
        }
        JideButton deleteButton = this.createButton(ImageUtils.createImageIcon(this.getClass(), (String)"/icons/alert/delete.png"));
        deleteButton.addActionListener(closeAction);
        bottomPanel.add((Component)deleteButton);
        JPanel leftPanel = new JPanel(new BorderLayout(6, 6));
        leftPanel.add(new JLabel(ImageUtils.createImageIcon(this.getClass(), (String)"/icons/alert/usb_plug.png")));
        leftPanel.add((Component)bottomPanel, "Last");
        JPanel rightPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        rightPanel.add((Component)this.createButton(ImageUtils.createImageIcon(this.getClass(), (String)"/icons/alert/option.png")));
        JideButton closeButton = this.createButton(ImageUtils.createImageIcon(this.getClass(), (String)"/icons/alert/close.png"));
        closeButton.addActionListener(closeAction);
        rightPanel.add((Component)closeButton);
        final JLabel message = new JLabel(text);
        message.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                message.setText(highlightText);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                message.setText(text);
            }
        });
        PaintPanel panel = new PaintPanel((LayoutManager)new BorderLayout(6, 6));
        panel.setBorder(BorderFactory.createEmptyBorder(6, 7, 7, 7));
        panel.add((Component)message, (Object)"Center");
        JPanel topPanel = JideSwingUtilities.createTopPanel((Component)rightPanel);
        panel.add((Component)topPanel, (Object)"After");
        panel.add((Component)leftPanel, (Object)"Before");
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            JideSwingUtilities.setOpaqueRecursively((Component)panel.getComponent(i), (boolean)false);
        }
        panel.setOpaque(true);
        Color background = UIDefaultsLookup.getColor((Object)"AlertPanel.background");
        if (background != null) {
            panel.setBackgroundPaint((Paint)background);
        } else {
            panel.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, new Color(231, 229, 224), 0.0f, panel.getPreferredSize().height, new Color(212, 208, 200)));
        }
        return panel;
    }

    public void addAlertListener(AlertListener alertListener) {
        this.alertListeners.add(alertListener);
    }

    public void removeAlertListener(AlertListener alertListener) {
        this.alertListeners.remove(alertListener);
    }

    private void notifyAlertAddedListeners(BidibAlert<?> alert, AlertListener.AlertAction alertAction) {
        LOGGER.info("Notify the alertListeners about added, alertAction: {}, alert: {}", (Object)alertAction, alert);
        for (AlertListener listener : this.alertListeners) {
            listener.alertAdded(alert, alertAction);
        }
    }

    private void notifyAlertRemoveListeners(BidibAlert<?> alert) {
        LOGGER.info("Notify the alertListeners about remove, alert: {}", alert);
        for (AlertListener listener : this.alertListeners) {
            listener.alertRemoved(alert);
        }
    }

    private static final class BidibAlertGroup
    extends AlertGroup {
        private Collection<Alert> listAlerts = SynchronizedCollection.synchronizedCollection(new LinkedList());

        private BidibAlertGroup() {
        }

        public void add(Alert alert) {
            LOGGER.info("Add alert to group: {}", (Object)alert);
            try {
                super.add(alert);
                this.listAlerts.add(alert);
            }
            catch (Exception ex) {
                LOGGER.warn("Add alert to group failed.", (Throwable)ex);
            }
        }

        public void remove(Alert alert) {
            LOGGER.info("Remove alert from group: {}", (Object)alert);
            try {
                super.remove(alert);
                this.listAlerts.remove(alert);
            }
            catch (Exception ex) {
                LOGGER.warn("Remove alert from group failed.", (Throwable)ex);
            }
        }

        public Collection<Alert> getAlerts() {
            return Collections.unmodifiableCollection(this.listAlerts);
        }
    }
}

