/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.IoBehaviourInputEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.InputPortListener;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.model.InputPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.InputPortModelListener;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.InputPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class InputPortPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputPortPanelController.class);
    private final MainModel mainModel;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    private InputPortListPanel inputPortListPanel;
    private final Subject<PortConfigChangeEvent> portConfigChangeEventSubject;

    public InputPortPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.portConfigChangeEventSubject = PublishSubject.create().toSerialized();
    }

    public InputPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        final InputPortTableModel tableModel = new InputPortTableModel();
        tableModel.setPortListener(new InputPortModelListener(){

            public void labelChanged(InputPort port, String label) {
                port.setLabel(label);
                try {
                    NodeLabels nodeLabels = InputPortPanelController.this.getNodeLabels();
                    BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.inputPort, (int)port.getId(), (String)port.getLabel());
                    InputPortPanelController.this.saveLabels();
                }
                catch (InvalidConfigurationException ex) {
                    LOGGER.warn("Save input port labels failed.", (Throwable)ex);
                    String labelPath = ex.getReason();
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
                }
            }

            public void configChanged(InputPort port, PortConfigKeys ... portConfigKeys) {
                LOGGER.info("The port config value are changed for port: {}, portConfigKeys: {}", (Object)port, (Object)portConfigKeys);
                LinkedHashMap<Byte, BytePortConfigValue> values = new LinkedHashMap<Byte, BytePortConfigValue>();
                List inputPorts = InputPortPanelController.this.mainModel.getSelectedNode().getInputPorts();
                InputPort inputPort = (InputPort)PortListUtils.findPortByPortNumber((List)inputPorts, (int)port.getId());
                block6: for (PortConfigKeys key : portConfigKeys) {
                    if (!inputPort.isPortConfigKeySupported(key)) {
                        LOGGER.info("Unsupported port config key detected: {}", (Object)key);
                        continue;
                    }
                    switch (key) {
                        case BIDIB_PCFG_INPUT_CTRL: {
                            IoBehaviourInputEnum inputBehaviour = port.getInputBehaviour();
                            if (inputBehaviour == null || inputBehaviour == IoBehaviourInputEnum.UNKNOWN) continue block6;
                            values.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, new BytePortConfigValue(Byte.valueOf(inputBehaviour.getType())));
                            continue block6;
                        }
                        case BIDIB_PCFG_TICKS: {
                            Integer switchOffTime = port.getSwitchOffTime();
                            if (switchOffTime == null) continue block6;
                            values.put((byte)11, new BytePortConfigValue(ByteUtils.getLowByte((Integer)switchOffTime)));
                            continue block6;
                        }
                        default: {
                            LOGGER.warn("Unsupported port config key detected: {}", (Object)key);
                        }
                    }
                }
                if (MapUtils.isNotEmpty(values)) {
                    try {
                        InputPortPanelController.this.switchingNodeService.setPortConfig("main", InputPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), (Port)port, null, values);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set the inputport parameters failed.", (Throwable)ex);
                        InputPortPanelController.this.mainModel.setNodeHasError(InputPortPanelController.this.mainModel.getSelectedNode(), true);
                    }
                } else {
                    LOGGER.info("No config values to save available.");
                }
            }

            public void changePortType(LcOutputType portType, Port<? extends BidibStatus> port) {
                LOGGER.info("The port type will change to: {}, port: {}", (Object)portType, port);
                HashMap values = new HashMap();
                InputPortPanelController.this.switchingNodeService.setPortConfig("main", InputPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), port, portType, values);
            }
        });
        this.inputPortListPanel = new InputPortListPanel(this, tableModel, this.mainModel, tabVisibilityListener, this.portConfigChangeEventSubject);
        this.inputPortListPanel.setPortListener(new InputPortListener(){

            public Class<?> getPortClass() {
                return InputPort.class;
            }

            public void labelChanged(InputPort port, String label) {
                LOGGER.info("The label has been changed by nodeScript, port: {}, label: {}", (Object)port, (Object)label);
                NodeLabels nodeLabels = InputPortPanelController.this.getNodeLabels();
                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.inputPort, (int)port.getId(), (String)port.getLabel());
                InputPortPanelController.this.saveLabels();
                InputPortPanelController.this.inputPortListPanel.repaint();
            }

            public void statusChanged(NodeInterface node, InputPort port) {
                LOGGER.info("The port status has changed: {}", (Object)node, (Object)port);
                SwingUtilities.invokeLater(() -> tableModel.notifyPortStatusChanged(port));
            }

            public void configChanged(NodeInterface node, InputPort port) {
                SwingUtilities.invokeLater(() -> InputPortPanelController.this.handlePortConfigChanged(node, tableModel, port));
            }
        });
        return this.inputPortListPanel;
    }

    private void handlePortConfigChanged(NodeInterface node, InputPortTableModel tableModel, InputPort port) {
        this.inputPortListPanel.portTableLayoutChanged(node);
        tableModel.notifyPortConfigChanged(port);
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            Long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(uniqueId);
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.inputPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.inputPortListPanel.refreshView());
        }
    }
}

